/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter;

import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataError;
import proguard.classfile.kotlin.asserter.Reporter;
import proguard.classfile.kotlin.visitors.AllConstructorsVisitor;
import proguard.classfile.kotlin.visitors.AllFunctionsVisitor;
import proguard.classfile.kotlin.visitors.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitors.AllTypeVisitor;
import proguard.classfile.kotlin.visitors.AllValueParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitors.KotlinValueParameterVisitor;

@FunctionalInterface
public interface KotlinMetadataConstraint {
    public void check(Reporter var1, Clazz var2, KotlinMetadata var3, ClassPool var4, ClassPool var5);

    public static KotlinMetadataConstraint makeConstraint(ConstraintChecker checker, KotlinMetadataVisitor checkingVisitor) {
        return (reporter, clazz, metadata, programClassPool, libClassPool) -> {
            checker.setReporter(reporter);
            checker.setClassPools(programClassPool, libClassPool);
            try {
                metadata.accept(clazz, checkingVisitor);
            }
            catch (Exception e) {
                reporter.report(new KotlinMetadataError(clazz, metadata){

                    @Override
                    public String errorDescription() {
                        return "Encountered unexpected Exception when checking constraint: " + e.getMessage();
                    }
                });
            }
        };
    }

    public static <T extends ConstraintChecker & KotlinMetadataVisitor> KotlinMetadataConstraint make(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, visitor);
    }

    public static <T extends ConstraintChecker & KotlinTypeVisitor> KotlinMetadataConstraint makeFromType(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, new AllTypeVisitor(visitor));
    }

    public static <T extends ConstraintChecker & KotlinValueParameterVisitor> KotlinMetadataConstraint makeFromValueParameter(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, new AllValueParameterVisitor(visitor));
    }

    public static <T extends ConstraintChecker & KotlinPropertyVisitor> KotlinMetadataConstraint makeFromProperty(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, new AllKotlinPropertiesVisitor(visitor));
    }

    public static <T extends ConstraintChecker & KotlinFunctionVisitor> KotlinMetadataConstraint makeFromFunction(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, new AllFunctionsVisitor(visitor));
    }

    public static <T extends ConstraintChecker & KotlinConstructorVisitor> KotlinMetadataConstraint makeFromConstructor(T visitor) {
        return KotlinMetadataConstraint.makeConstraint(visitor, new AllConstructorsVisitor(visitor));
    }
}

