/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.asserter.AssertUtil;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.MissingMetadataError;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.asserter.UnexpectedFlagError;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;

public class ClassIntegrity
extends SimpleConstraintChecker
implements ConstraintChecker,
KotlinMetadataVisitor {
    private final KotlinMetadataVisitor myCompanionObjectFlagChecker = new MyCompanionObjectFlagChecker();

    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.make(new ClassIntegrity());
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        AssertUtil util = new AssertUtil("Class", clazz, kotlinClassKindMetadata, this.reporter);
        util.reportIfNullReference(kotlinClassKindMetadata.referencedClass, "referenced class");
        if (kotlinClassKindMetadata.companionObjectName != null) {
            util.reportIfNullReference(kotlinClassKindMetadata.referencedCompanionClass, "companion");
            kotlinClassKindMetadata.companionAccept(this.myCompanionObjectFlagChecker);
        }
        if (kotlinClassKindMetadata.superTypes.isEmpty()) {
            this.reporter.report(new MyMissingMetadataError("super types", clazz, kotlinClassKindMetadata));
        }
        kotlinClassKindMetadata.referencedEnumEntries.forEach(util.reportIfFieldDangling(clazz, "enum entries"));
        kotlinClassKindMetadata.referencedNestedClasses.forEach(util.reportIfNullReference("enum entries"));
        kotlinClassKindMetadata.referencedSealedSubClasses.forEach(util.reportIfNullReference("sealed subclasses"));
    }

    private static class MyMissingMetadataError
    extends MissingMetadataError {
        MyMissingMetadataError(String missingElement, Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            super("Class", missingElement, clazz, kotlinClassKindMetadata);
        }
    }

    private class MyCompanionObjectFlagChecker
    implements KotlinMetadataVisitor {
        private MyCompanionObjectFlagChecker() {
        }

        @Override
        public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
        }

        @Override
        public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
            if (!kotlinClassKindMetadata.flags.isCompanionObject) {
                ClassIntegrity.this.reporter.report(new UnexpectedFlagError("Companion class '" + clazz.getName() + "'", "isCompanionObject", false, clazz, kotlinClassKindMetadata));
            }
        }
    }
}

