/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.asserter.AssertUtil;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.MissingReferenceError;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.visitors.KotlinConstructorVisitor;

public class ConstructorIntegrity
extends SimpleConstraintChecker
implements KotlinConstructorVisitor,
ConstraintChecker {
    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.makeFromConstructor(new ConstructorIntegrity());
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        AssertUtil util = new AssertUtil("Constructor", clazz, kotlinClassKindMetadata, this.reporter);
        if (!kotlinClassKindMetadata.flags.isAnnotationClass) {
            if (kotlinConstructorMetadata.referencedMethod == null) {
                this.reporter.report(new MyMissingReferenceError("method", clazz, kotlinClassKindMetadata));
            } else {
                util.reportIfMethodDangling(clazz, kotlinConstructorMetadata.referencedMethod, "constructor method");
            }
        }
    }

    private static class MyMissingReferenceError
    extends MissingReferenceError {
        MyMissingReferenceError(String missingPart, Clazz clazz, KotlinMetadata kotlinMetadata) {
            super("Constructor", missingPart, clazz, kotlinMetadata);
        }
    }
}

