/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.asserter.AssertUtil;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.MissingMetadataError;
import proguard.classfile.kotlin.asserter.MissingReferenceError;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinValueParameterVisitor;

public class FunctionIntegrity
extends SimpleConstraintChecker
implements ConstraintChecker,
KotlinFunctionVisitor,
KotlinValueParameterVisitor {
    private boolean hasDefaults = false;

    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.makeFromFunction(new FunctionIntegrity());
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        AssertUtil util = new AssertUtil("Function", clazz, kotlinMetadata, this.reporter);
        if (kotlinFunctionMetadata.jvmSignature == null) {
            this.reporter.report(new MyMissingMetadataError(clazz, kotlinMetadata));
        }
        if (kotlinFunctionMetadata.referencedMethodClass == null) {
            this.reporter.report(new MyMissingReferenceError("method class", clazz, kotlinMetadata));
        }
        if (kotlinFunctionMetadata.referencedMethod == null) {
            this.reporter.report(new MyMissingReferenceError("method", clazz, kotlinMetadata));
        }
        if (kotlinFunctionMetadata.referencedMethod != null && kotlinFunctionMetadata.referencedMethodClass != null) {
            util.reportIfMethodDangling(kotlinFunctionMetadata.referencedMethodClass, kotlinFunctionMetadata.referencedMethod, "referenced method");
        }
        if (kotlinFunctionMetadata.referencedDefaultMethod != null && kotlinFunctionMetadata.referencedDefaultMethodClass != null) {
            util.reportIfMethodDangling(kotlinFunctionMetadata.referencedDefaultMethodClass, kotlinFunctionMetadata.referencedDefaultMethod, "referenced default method");
        }
        if (kotlinFunctionMetadata.referencedDefaultImplementationMethod != null && kotlinFunctionMetadata.referencedDefaultImplementationMethodClass != null) {
            util.reportIfMethodDangling(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass, kotlinFunctionMetadata.referencedDefaultImplementationMethod, "referenced default implementation method");
        }
        this.hasDefaults = false;
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        if (this.hasDefaults) {
            boolean hasDefaultMethod;
            boolean bl = hasDefaultMethod = kotlinFunctionMetadata.referencedDefaultMethod != null && kotlinFunctionMetadata.referencedDefaultMethod.getName(kotlinFunctionMetadata.referencedDefaultMethodClass).equals(kotlinFunctionMetadata.referencedMethod.getName(kotlinFunctionMetadata.referencedMethodClass) + "$default");
            if (!hasDefaultMethod) {
                this.reporter.report(new MyMissingReferenceError(kotlinFunctionMetadata.name + "$default method [" + kotlinFunctionMetadata.jvmSignature + "]", clazz, kotlinMetadata));
            }
        }
        if (!kotlinFunctionMetadata.flags.modality.isAbstract && kotlinMetadata.k == 1) {
            KotlinClassKindMetadata kotlinClassKindMetadata = (KotlinClassKindMetadata)kotlinMetadata;
            if (kotlinClassKindMetadata.flags.isInterface) {
                util.reportIfNullReference(kotlinFunctionMetadata.referencedDefaultImplementationMethod, "default implementation method");
                util.reportIfNullReference(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass, "default implementation method class");
            }
        }
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        this.hasDefaults |= kotlinValueParameterMetadata.flags.hasDefaultValue;
    }

    private static class MyMissingReferenceError
    extends MissingReferenceError {
        MyMissingReferenceError(String missingPart, Clazz clazz, KotlinMetadata kotlinMetadata) {
            super("Function", missingPart, clazz, kotlinMetadata);
        }
    }

    private static class MyMissingMetadataError
    extends MissingMetadataError {
        MyMissingMetadataError(Clazz clazz, KotlinMetadata kotlinMetadata) {
            super("Function", "JVM signature", clazz, kotlinMetadata);
        }
    }
}

