/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.asserter.AssertUtil;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.MissingMetadataError;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.visitors.KotlinPropertyVisitor;

public class PropertyIntegrity
extends SimpleConstraintChecker
implements ConstraintChecker,
KotlinPropertyVisitor {
    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.makeFromProperty(new PropertyIntegrity());
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        AssertUtil util = new AssertUtil("Property", clazz, kotlinDeclarationContainerMetadata, this.reporter);
        if (kotlinPropertyMetadata.backingFieldSignature == null && kotlinPropertyMetadata.getterSignature == null && kotlinPropertyMetadata.setterSignature == null) {
            this.reporter.report(new MyMissingMetadataError("accessor", clazz, kotlinDeclarationContainerMetadata));
        }
        if (kotlinPropertyMetadata.backingFieldSignature != null) {
            util.reportIfNullReference(kotlinPropertyMetadata.referencedBackingFieldClass, "backing field class");
            util.reportIfNullReference(kotlinPropertyMetadata.referencedBackingField, "backing field");
            if (kotlinPropertyMetadata.referencedBackingFieldClass != null && kotlinPropertyMetadata.referencedBackingField != null) {
                util.reportIfFieldDangling(kotlinPropertyMetadata.referencedBackingFieldClass, kotlinPropertyMetadata.referencedBackingField, "backing field");
            }
        }
        if (kotlinPropertyMetadata.getterSignature != null) {
            util.reportIfNullReference(kotlinPropertyMetadata.referencedGetterMethod, "getter");
        }
        if (kotlinPropertyMetadata.setterSignature != null) {
            util.reportIfNullReference(kotlinPropertyMetadata.referencedSetterMethod, "setter");
        }
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
            util.reportIfNullReference(kotlinPropertyMetadata.referencedSyntheticMethodClass, "synthetic annotations method class");
            util.reportIfNullReference(kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations, "synthetic annotations method");
            if (kotlinPropertyMetadata.referencedSyntheticMethodClass != null && kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations != null) {
                util.reportIfMethodDangling(kotlinPropertyMetadata.referencedSyntheticMethodClass, kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations, "synthetic annotations method");
            }
        }
    }

    private static class MyMissingMetadataError
    extends MissingMetadataError {
        MyMissingMetadataError(String missingElement, Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
            super("Property", missingElement, clazz, kotlinDeclarationContainerMetadata);
        }
    }
}

