/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.KotlinMetadataError;
import proguard.classfile.kotlin.asserter.Reporter;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;

public class SyntheticClassIntegrity
extends SimpleConstraintChecker
implements KotlinMetadataVisitor,
ConstraintChecker {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.make(new SyntheticClassIntegrity());
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        switch (kotlinSyntheticClassKindMetadata.kind) {
            case DEFAULT_IMPLS: {
                SyntheticClassIntegrity.checkSuffix(clazz, kotlinSyntheticClassKindMetadata, "$DefaultImpls", this.reporter);
                break;
            }
            case WHEN_MAPPINGS: {
                SyntheticClassIntegrity.checkSuffix(clazz, kotlinSyntheticClassKindMetadata, "$WhenMappings", this.reporter);
                break;
            }
            case LAMBDA: {
                try {
                    Integer.parseInt(kotlinSyntheticClassKindMetadata.referencedClass.getName().substring(kotlinSyntheticClassKindMetadata.referencedClass.getName().lastIndexOf("$") + 1));
                }
                catch (NumberFormatException e) {
                    this.reporter.report(new KotlinMetadataError(clazz, kotlinSyntheticClassKindMetadata){

                        @Override
                        public String errorDescription() {
                            return "Synthetic lambda inner classname is not an integer.";
                        }
                    });
                }
                if (kotlinSyntheticClassKindMetadata.functions.isEmpty()) {
                    this.reporter.report(new KotlinMetadataError(clazz, kotlinSyntheticClassKindMetadata){

                        @Override
                        public String errorDescription() {
                            return "Synthetic class has no functions";
                        }
                    });
                    break;
                }
                if (kotlinSyntheticClassKindMetadata.functions.size() <= 1) break;
                this.reporter.report(new KotlinMetadataError(clazz, kotlinSyntheticClassKindMetadata){

                    @Override
                    public String errorDescription() {
                        return "Synthetic class has multiple functions";
                    }
                });
                break;
            }
        }
    }

    private static void checkSuffix(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, final String suffix, Reporter reporter) {
        if (!kotlinSyntheticClassKindMetadata.referencedClass.getName().endsWith(suffix)) {
            reporter.report(new KotlinMetadataError(clazz, kotlinSyntheticClassKindMetadata){

                @Override
                public String errorDescription() {
                    return "Synthetic class name does not end with " + suffix;
                }
            });
        }
    }
}

