/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.asserter.constraint;

import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.asserter.AssertUtil;
import proguard.classfile.kotlin.asserter.ConstraintChecker;
import proguard.classfile.kotlin.asserter.KotlinMetadataConstraint;
import proguard.classfile.kotlin.asserter.KotlinMetadataError;
import proguard.classfile.kotlin.asserter.SimpleConstraintChecker;
import proguard.classfile.kotlin.visitors.KotlinTypeVisitor;

public class TypeIntegrity
extends SimpleConstraintChecker
implements ConstraintChecker,
KotlinTypeVisitor {
    public static KotlinMetadataConstraint constraint() {
        return KotlinMetadataConstraint.makeFromType(new TypeIntegrity());
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata type) {
        AssertUtil util = new AssertUtil("Type", clazz, null, this.reporter);
        if (type.className != null) {
            util.reportIfNullReference(type.referencedClass, "class \"" + type.className + "\"");
            if (type.aliasName != null) {
                this.reporter.report(new AmbiguousTypeError(clazz, "class name", "alias name"));
            }
            if (type.typeParamID >= 0) {
                this.reporter.report(new AmbiguousTypeError(clazz, "class name", "param ID"));
            }
        }
        if (type.aliasName != null) {
            util.reportIfNullReference(type.referencedTypeAlias, "type alias");
            if (type.className != null) {
                this.reporter.report(new AmbiguousTypeError(clazz, "class name", "alias name"));
            }
            if (type.typeParamID >= 0) {
                this.reporter.report(new AmbiguousTypeError(clazz, "class name", "param ID"));
            }
        }
    }

    private static class AmbiguousTypeError
    extends KotlinMetadataError {
        private final String variant1;
        private final String variant2;

        AmbiguousTypeError(Clazz clazz, String variant1, String variant2) {
            super(clazz, null);
            this.variant1 = variant1;
            this.variant2 = variant2;
        }

        @Override
        public String errorDescription() {
            return "Type is both " + this.variant1 + " and " + this.variant2 + ".";
        }
    }
}

