/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.initialize;

import java.util.Collections;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.WarningPrinter;

public class KotlinDefaultMethodInitializer
implements KotlinMetadataVisitor {
    private static boolean DEBUG = false;
    private final MemberFinder strictMemberFinder = new MemberFinder(false);
    private final ClassPool classPool;
    private final WarningPrinter warningPrinter;
    private final MyKotlinDefaultMethodInitializer kotlinDefaultMethodInitializer = new MyKotlinDefaultMethodInitializer();

    public KotlinDefaultMethodInitializer(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        this.kotlinDefaultMethodInitializer.isInterface = false;
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        this.kotlinDefaultMethodInitializer.isInterface = kotlinClassKindMetadata.flags.isInterface;
        kotlinClassKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        this.kotlinDefaultMethodInitializer.isInterface = false;
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this.kotlinDefaultMethodInitializer);
    }

    private static String getDescriptor(KotlinFunctionMetadata kotlinFunctionMetadata) {
        String originalDescriptor = kotlinFunctionMetadata.referencedMethod.getDescriptor(kotlinFunctionMetadata.referencedMethodClass);
        int requiredIntParams = 1 + ClassUtil.internalMethodParameterCount(originalDescriptor) / 32;
        String descriptor = originalDescriptor.replace(")", String.join((CharSequence)"", Collections.nCopies(requiredIntParams, "I")) + "Ljava/lang/Object;)");
        if ((kotlinFunctionMetadata.referencedMethod.getAccessFlags() & 8) == 0) {
            descriptor = descriptor.replace("(", "(L" + kotlinFunctionMetadata.referencedMethodClass.getName() + ";");
        }
        return descriptor;
    }

    private class MyKotlinDefaultMethodInitializer
    implements KotlinFunctionVisitor {
        private boolean isInterface = false;
        private boolean hasDefaults = false;

        private MyKotlinDefaultMethodInitializer() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            Clazz defaultImplsClass;
            if (kotlinFunctionMetadata.referencedMethod == null) {
                return;
            }
            String methodName = kotlinFunctionMetadata.referencedMethod.getName(kotlinFunctionMetadata.referencedMethodClass);
            if (methodName.endsWith("$default")) {
                return;
            }
            this.hasDefaults = false;
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, (_clazz, vp) -> this.hasDefaults |= vp.flags.hasDefaultValue);
            if (!this.hasDefaults) {
                return;
            }
            String defaultMethodName = methodName + "$default";
            String descriptor = KotlinDefaultMethodInitializer.getDescriptor(kotlinFunctionMetadata);
            if (DEBUG) {
                System.out.println("SEARCHING FOR: " + defaultMethodName + "(" + kotlinFunctionMetadata.name + ")" + descriptor);
            }
            kotlinFunctionMetadata.referencedDefaultMethod = KotlinDefaultMethodInitializer.this.strictMemberFinder.findMethod(kotlinFunctionMetadata.referencedMethodClass, defaultMethodName, descriptor);
            kotlinFunctionMetadata.referencedDefaultMethodClass = KotlinDefaultMethodInitializer.this.strictMemberFinder.correspondingClass();
            if (kotlinFunctionMetadata.referencedDefaultMethod == null && this.isInterface && (defaultImplsClass = KotlinDefaultMethodInitializer.this.classPool.getClass(clazz.getName() + "$DefaultImpls")) != null) {
                kotlinFunctionMetadata.referencedDefaultMethod = KotlinDefaultMethodInitializer.this.strictMemberFinder.findMethod(defaultImplsClass, defaultMethodName, descriptor);
                kotlinFunctionMetadata.referencedDefaultMethodClass = KotlinDefaultMethodInitializer.this.strictMemberFinder.correspondingClass();
            }
        }
    }
}

