/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.initialize;

import kotlinx.metadata.jvm.JvmMethodSignature;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitors.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinPropertyVisitor;
import proguard.classfile.util.MemberFinder;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.util.WarningPrinter;

public class KotlinInterClassReferenceInitializer
implements KotlinMetadataVisitor {
    private static boolean DEBUG = false;
    private final MemberFinder memberFinder = new MemberFinder(false);
    private final ClassPool classPool;
    private final WarningPrinter warningPrinter;

    public KotlinInterClassReferenceInitializer(ClassPool classPool, WarningPrinter warningPrinter) {
        this.classPool = classPool;
        this.warningPrinter = warningPrinter;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        kotlinClassKindMetadata.companionAccept(new AllKotlinPropertiesVisitor(new MyInterClassReferenceInitializer(clazz)));
        if (kotlinClassKindMetadata.flags.isInterface) {
            Clazz defaultImplsClass = this.classPool.getClass(clazz.getName() + "$DefaultImpls");
            kotlinClassKindMetadata.accept(clazz, new AllKotlinPropertiesVisitor(new MyInterClassReferenceInitializer(defaultImplsClass)));
        }
    }

    @Override
    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        kotlinMultiFilePartKindMetadata.accept(clazz, new AllKotlinPropertiesVisitor(new MyInterClassReferenceInitializer(kotlinMultiFilePartKindMetadata.referencedFacade)));
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, new MyInterClassSyntheticFunctionInitializer());
    }

    private class MyInterClassReferenceInitializer
    implements KotlinPropertyVisitor {
        private final Clazz clazz;

        MyInterClassReferenceInitializer(Clazz clazz) {
            this.clazz = clazz;
        }

        @Override
        public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
            if (kotlinPropertyMetadata.backingFieldSignature != null && kotlinPropertyMetadata.referencedBackingField == null) {
                kotlinPropertyMetadata.referencedBackingField = KotlinInterClassReferenceInitializer.this.memberFinder.findField(this.clazz, kotlinPropertyMetadata.backingFieldSignature.getName(), kotlinPropertyMetadata.backingFieldSignature.getDesc());
                kotlinPropertyMetadata.referencedBackingFieldClass = KotlinInterClassReferenceInitializer.this.memberFinder.correspondingClass();
            }
            if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null && kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations == null) {
                kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations = KotlinInterClassReferenceInitializer.this.memberFinder.findMethod(this.clazz, kotlinPropertyMetadata.syntheticMethodForAnnotations.getName(), kotlinPropertyMetadata.syntheticMethodForAnnotations.getDesc());
                kotlinPropertyMetadata.referencedSyntheticMethodClass = KotlinInterClassReferenceInitializer.this.memberFinder.correspondingClass();
            }
        }
    }

    private static class MyInterClassSyntheticFunctionInitializer
    extends SimplifiedVisitor
    implements KotlinFunctionVisitor,
    AttributeVisitor {
        private KotlinFunctionMetadata currentFunction;

        private MyInterClassSyntheticFunctionInitializer() {
        }

        @Override
        public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        }

        @Override
        public void visitSyntheticFunction(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
            if (kotlinFunctionMetadata.referencedMethod == null) {
                this.currentFunction = kotlinFunctionMetadata;
                clazz.attributeAccept("EnclosingMethod", this);
            }
        }

        @Override
        public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
            Method enclosingMethod = enclosingMethodAttribute.referencedMethod;
            Clazz enclosingMethodClass = enclosingMethodAttribute.referencedClass;
            if (DEBUG && this.currentFunction.jvmSignature == null && enclosingMethod != null) {
                System.err.println("EnclosingMethod is initialised for " + this.currentFunction.name + " but jvmSignature is null");
            }
            if (enclosingMethod != null) {
                if (this.currentFunction.jvmSignature == null) {
                    this.currentFunction.jvmSignature = new JvmMethodSignature(enclosingMethod.getName(enclosingMethodClass), enclosingMethod.getDescriptor(enclosingMethodClass));
                    if (DEBUG) {
                        System.out.println("Setting jvmSignature for " + this.currentFunction.name + " to " + this.currentFunction.jvmSignature);
                    }
                }
                this.currentFunction.referencedMethod = enclosingMethod;
                this.currentFunction.referencedMethodClass = enclosingMethodClass;
            }
        }
    }
}

