/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.kotlin.obfuscate;

import java.util.Arrays;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.Member;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.Constant;
import proguard.classfile.editor.CodeAttributeEditor;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.instruction.visitor.MultiInstructionVisitor;
import proguard.classfile.kotlin.obfuscate.ReplacementSequences;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.optimize.peephole.BranchTargetFinder;
import proguard.optimize.peephole.InstructionSequenceReplacer;
import proguard.optimize.peephole.PeepholeOptimizer;

public class InstructionSequenceObfuscator
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor {
    private final PeepholeOptimizer peepholeOptimizer;

    public InstructionSequenceObfuscator(ReplacementSequences replacementSequences) {
        BranchTargetFinder branchTargetFinder = new BranchTargetFinder();
        CodeAttributeEditor codeAttributeEditor = new CodeAttributeEditor();
        this.peepholeOptimizer = new PeepholeOptimizer(branchTargetFinder, codeAttributeEditor, new MyInstructionSequenceReplacer(replacementSequences.getConstants(), replacementSequences.getSequences(), branchTargetFinder, codeAttributeEditor));
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        programClass.methodsAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        programMethod.attributesAccept(programClass, this.peepholeOptimizer);
    }

    private static class MyInstructionSequenceReplacer
    extends MultiInstructionVisitor {
        MyInstructionSequenceReplacer(Constant[] constants, Instruction[][][] insSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
            super(MyInstructionSequenceReplacer.createInstructionSequenceReplacers(constants, insSequences, branchTargetFinder, codeAttributeEditor));
        }

        private static InstructionVisitor[] createInstructionSequenceReplacers(Constant[] constants, Instruction[][][] insSequences, BranchTargetFinder branchTargetFinder, CodeAttributeEditor codeAttributeEditor) {
            InstructionVisitor[] isReplacers = new InstructionSequenceReplacer[insSequences.length];
            Arrays.setAll(isReplacers, index -> new InstructionSequenceReplacer(constants, insSequences[index][0], constants, insSequences[index][1], branchTargetFinder, codeAttributeEditor, null));
            return isReplacers;
        }
    }
}

