/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;

public class ClassProcessingFlagFilter
implements ClassVisitor {
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;
    private final ClassVisitor classVisitor;

    public ClassProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, ClassVisitor classVisitor) {
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
        this.classVisitor = classVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.accepted(programClass.getProcessingFlags())) {
            this.classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.accepted(libraryClass.getProcessingFlags())) {
            this.classVisitor.visitLibraryClass(libraryClass);
        }
    }

    private boolean accepted(int processingFlags) {
        return (this.requiredSetProcessingFlags & ~processingFlags) == 0 && (this.requiredUnsetProcessingFlags & processingFlags) == 0;
    }
}

