/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.Constant;
import proguard.classfile.constant.MethodrefConstant;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.InstructionSequenceMatcher;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class ConstructorMethodFilter
extends SimplifiedVisitor
implements MemberVisitor,
AttributeVisitor,
InstructionVisitor {
    private static final int FIELD_INDEX = 0x40000000;
    private static final Constant[] CONSTANTS = new Constant[0];
    private static final Instruction[] INVOKE_INSTRUCTIONS = new Instruction[]{new ConstantInstruction(-73, 0x40000000)};
    private final InstructionSequenceMatcher invokeMatcher = new InstructionSequenceMatcher(CONSTANTS, INVOKE_INSTRUCTIONS);
    private final MemberVisitor superCallingConstructorVisitor;
    private final MemberVisitor constructorVisitor;
    private final MemberVisitor otherMethodVisitor;
    private boolean isSuperConstructorCalled;

    public ConstructorMethodFilter(MemberVisitor constructorVisitor) {
        this(constructorVisitor, constructorVisitor, null);
    }

    public ConstructorMethodFilter(MemberVisitor constructorVisitor, MemberVisitor otherMethodVisitor) {
        this(constructorVisitor, constructorVisitor, otherMethodVisitor);
    }

    public ConstructorMethodFilter(MemberVisitor superCallingConstructorVisitor, MemberVisitor constructorVisitor, MemberVisitor otherMethodVisitor) {
        this.superCallingConstructorVisitor = superCallingConstructorVisitor;
        this.constructorVisitor = constructorVisitor;
        this.otherMethodVisitor = otherMethodVisitor;
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        MemberVisitor delegateVisitor = this.delegateVisitor(programClass, programMethod);
        if (delegateVisitor != null) {
            delegateVisitor.visitProgramMethod(programClass, programMethod);
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.instructionsAccept(clazz, method, this);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
        MethodrefConstant methodrefConstant;
        instruction.accept(clazz, method, codeAttribute, offset, this.invokeMatcher);
        if (this.invokeMatcher.isMatching() && "<init>".equals((methodrefConstant = (MethodrefConstant)((ProgramClass)clazz).getConstant(this.invokeMatcher.matchedArgument(0x40000000))).getName(clazz))) {
            this.isSuperConstructorCalled |= methodrefConstant.getClassName(clazz).equals(clazz.getSuperName());
        }
    }

    private MemberVisitor delegateVisitor(ProgramClass programClass, ProgramMethod programMethod) {
        this.isSuperConstructorCalled = false;
        if ("<init>".equals(programMethod.getName(programClass))) {
            programMethod.attributesAccept(programClass, this);
            return this.isSuperConstructorCalled ? this.superCallingConstructorVisitor : this.constructorVisitor;
        }
        return this.otherMethodVisitor;
    }
}

