/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.Clazz;
import proguard.classfile.Member;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberVisitor;

public class MemberProcessingFlagFilter
extends SimplifiedVisitor
implements MemberVisitor {
    private final int requiredSetProcessingFlags;
    private final int requiredUnsetProcessingFlags;
    private final MemberVisitor acceptedMemberVisitor;
    private final MemberVisitor rejectedMemberVisitor;

    public MemberProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, MemberVisitor acceptedMemberVisitor) {
        this(requiredSetProcessingFlags, requiredUnsetProcessingFlags, acceptedMemberVisitor, null);
    }

    public MemberProcessingFlagFilter(int requiredSetProcessingFlags, int requiredUnsetProcessingFlags, MemberVisitor acceptedMemberVisitor, MemberVisitor rejectedMemberVisitor) {
        this.requiredSetProcessingFlags = requiredSetProcessingFlags;
        this.requiredUnsetProcessingFlags = requiredUnsetProcessingFlags;
        this.acceptedMemberVisitor = acceptedMemberVisitor;
        this.rejectedMemberVisitor = rejectedMemberVisitor;
    }

    @Override
    public void visitAnyMember(Clazz clazz, Member member) {
        MemberVisitor delegate = this.getDelegate(member.getProcessingFlags());
        if (delegate != null) {
            member.accept(clazz, delegate);
        }
    }

    private MemberVisitor getDelegate(int processingFlags) {
        return this.accepted(processingFlags) ? this.acceptedMemberVisitor : this.rejectedMemberVisitor;
    }

    private boolean accepted(int processingFlags) {
        return (this.requiredSetProcessingFlags & ~processingFlags) == 0 && (this.requiredUnsetProcessingFlags & processingFlags) == 0;
    }
}

