/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.visitor;

import proguard.classfile.ClassPool;
import proguard.classfile.visitor.ClassPoolVisitor;

public class MultiClassPoolVisitor
implements ClassPoolVisitor {
    private static final int ARRAY_SIZE_INCREMENT = 5;
    private ClassPoolVisitor[] classPoolVisitors;
    private int classPoolVisitorCount;

    public MultiClassPoolVisitor() {
    }

    public MultiClassPoolVisitor(ClassPoolVisitor ... classPoolVisitors) {
        this.classPoolVisitors = classPoolVisitors;
        this.classPoolVisitorCount = classPoolVisitors.length;
    }

    public void addClassPoolVisitor(ClassPoolVisitor classPoolVisitor) {
        this.ensureArraySize();
        this.classPoolVisitors[this.classPoolVisitorCount++] = classPoolVisitor;
    }

    private void ensureArraySize() {
        if (this.classPoolVisitors == null) {
            this.classPoolVisitors = new ClassPoolVisitor[5];
        } else if (this.classPoolVisitors.length == this.classPoolVisitorCount) {
            ClassPoolVisitor[] newClassPoolVisitors = new ClassPoolVisitor[this.classPoolVisitorCount + 5];
            System.arraycopy(this.classPoolVisitors, 0, newClassPoolVisitors, 0, this.classPoolVisitorCount);
            this.classPoolVisitors = newClassPoolVisitors;
        }
    }

    @Override
    public void visitClassPool(ClassPool classPool) {
        for (int index = 0; index < this.classPoolVisitorCount; ++index) {
            this.classPoolVisitors[index].visitClassPool(classPool);
        }
    }
}

