/*
 * Decompiled with CFR 0.152.
 */
package proguard.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlinx.metadata.KmAnnotation;
import kotlinx.metadata.internal.metadata.jvm.deserialization.JvmMetadataVersion;
import kotlinx.metadata.jvm.KmModule;
import kotlinx.metadata.jvm.KmModuleVisitor;
import kotlinx.metadata.jvm.KotlinModuleMetadata;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.util.ClassUtil;
import proguard.io.DataEntry;
import proguard.io.DataEntryCopier;
import proguard.io.DataEntryWriter;

public class KotlinModuleRewriter
extends DataEntryCopier {
    private final ClassPool programClassPool;

    public KotlinModuleRewriter(ClassPool programClassPool, Charset charset, DataEntryWriter writer) {
        super(writer);
        this.programClassPool = programClassPool;
    }

    @Override
    public void read(DataEntry dataEntry) throws IOException {
        super.read(dataEntry);
    }

    @Override
    protected void copyData(InputStream inputStream, OutputStream outputStream) throws IOException {
        ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
        super.copyData(inputStream, byteStream);
        byte[] bytes = byteStream.toByteArray();
        KotlinModuleMetadata kotlinModuleMetadata = KotlinModuleMetadata.read((byte[])bytes);
        KmModule kmModule = kotlinModuleMetadata.toKmModule();
        ModuleTransformer moduleTransformer = new ModuleTransformer();
        kmModule.accept((KmModuleVisitor)moduleTransformer);
        KotlinModuleMetadata.Writer writer = new KotlinModuleMetadata.Writer();
        moduleTransformer.getResult().accept((KmModuleVisitor)writer);
        byte[] transformedBytes = writer.write(JvmMetadataVersion.INSTANCE.toArray()).getBytes();
        outputStream.write(transformedBytes);
    }

    private class ModuleTransformer
    extends KmModuleVisitor {
        private final Map<String, PackageInformation> newModuleInfo = new HashMap<String, PackageInformation>();

        private ModuleTransformer() {
        }

        private PackageInformation getPackageInformation(String fqName) {
            if (this.newModuleInfo.containsKey(fqName)) {
                return this.newModuleInfo.get(fqName);
            }
            PackageInformation packageInformation = new PackageInformation(fqName);
            this.newModuleInfo.put(fqName, packageInformation);
            return packageInformation;
        }

        private PackageInformation getPackageInformation(Clazz clazz) {
            return this.getPackageInformation(ClassUtil.externalPackageName(ClassUtil.externalClassName(clazz.getName())));
        }

        public void visitPackageParts(String fqName, List<String> fileFacades, Map<String, String> multiFileClassParts) {
            for (String string : fileFacades) {
                Clazz newClass = KotlinModuleRewriter.this.programClassPool.getClass(string);
                if (newClass == null) continue;
                this.getPackageInformation(newClass).fileFacades.add(newClass.getName());
            }
            for (Map.Entry entry : multiFileClassParts.entrySet()) {
                Clazz keyClass = KotlinModuleRewriter.this.programClassPool.getClass((String)entry.getKey());
                Clazz valueClass = KotlinModuleRewriter.this.programClassPool.getClass((String)entry.getValue());
                if (keyClass == null || valueClass == null) continue;
                this.getPackageInformation(keyClass).multiFileClassParts.put(keyClass.getName(), valueClass.getName());
            }
        }

        public KmModule getResult() {
            KmModule out = new KmModule();
            for (PackageInformation packageInformation : this.newModuleInfo.values()) {
                packageInformation.addToModule(out);
            }
            return out;
        }

        public void visitAnnotation(KmAnnotation annotation) {
            System.err.println("Cannot handle annotations yet");
        }

        public void visitEnd() {
        }
    }

    private class PackageInformation {
        private final String fqName;
        private final List<String> fileFacades = new ArrayList<String>();
        private final Map<String, String> multiFileClassParts = new HashMap<String, String>();

        private PackageInformation(String fqName) {
            this.fqName = fqName;
        }

        public void addToModule(KmModule out) {
            out.visitPackageParts(this.fqName, this.fileFacades, this.multiFileClassParts);
        }
    }
}

