/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import proguard.classfile.ClassPool;
import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.kotlin.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitors.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassVisitor;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NumericNameFactory;
import proguard.obfuscate.SimpleNameFactory;
import proguard.util.FileNameParser;
import proguard.util.ListParser;
import proguard.util.StringMatcher;

public class ClassObfuscator
extends SimplifiedVisitor
implements ClassVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ConstantVisitor {
    private final DictionaryNameFactory classNameFactory;
    private final DictionaryNameFactory packageNameFactory;
    private final boolean useMixedCaseClassNames;
    private final StringMatcher keepPackageNamesMatcher;
    private final String flattenPackageHierarchy;
    private final String repackageClasses;
    private final boolean allowAccessModification;
    private final Set classNamesToAvoid = new HashSet();
    private final Map packagePrefixMap = new HashMap();
    private final Map packagePrefixPackageNameFactoryMap = new HashMap();
    private final Map packagePrefixClassNameFactoryMap = new HashMap();
    private final Map packagePrefixNumericClassNameFactoryMap = new HashMap();
    private String newClassName;
    private boolean numericClassName;
    private final boolean adaptKotlin;

    public ClassObfuscator(ClassPool programClassPool, ClassPool libraryClassPool, DictionaryNameFactory classNameFactory, DictionaryNameFactory packageNameFactory, boolean useMixedCaseClassNames, List keepPackageNames, String flattenPackageHierarchy, String repackageClasses, boolean allowAccessModification, boolean adaptKotlin) {
        this.classNameFactory = classNameFactory;
        this.packageNameFactory = packageNameFactory;
        this.adaptKotlin = adaptKotlin;
        if (flattenPackageHierarchy != null && flattenPackageHierarchy.length() > 0) {
            flattenPackageHierarchy = flattenPackageHierarchy + '/';
        }
        if (repackageClasses != null && repackageClasses.length() > 0) {
            repackageClasses = repackageClasses + '/';
        }
        this.useMixedCaseClassNames = useMixedCaseClassNames;
        this.keepPackageNamesMatcher = keepPackageNames == null ? null : new ListParser(new FileNameParser()).parse(keepPackageNames);
        this.flattenPackageHierarchy = flattenPackageHierarchy;
        this.repackageClasses = repackageClasses;
        this.allowAccessModification = allowAccessModification;
        this.packagePrefixMap.put("", "");
        programClassPool.classesAccept(new MyKeepCollector());
        libraryClassPool.classesAccept(new MyKeepCollector());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.newClassName = ClassObfuscator.newClassName(programClass);
        if (this.newClassName == null) {
            programClass.attributesAccept(this);
            String newPackagePrefix = this.newClassName != null ? this.newClassName + '$' : this.newPackagePrefix(ClassUtil.internalPackagePrefix(programClass.getName()));
            this.newClassName = this.newClassName != null && this.numericClassName ? this.generateUniqueNumericClassName(newPackagePrefix) : this.generateUniqueClassName(newPackagePrefix);
            ClassObfuscator.setNewClassName(programClass, this.newClassName);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.newClassName = libraryClass.getName();
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        enclosingMethodAttribute.referencedClassAccept(this);
        String innerClassName = clazz.getName();
        String outerClassName = clazz.getClassName(enclosingMethodAttribute.u2classIndex);
        this.numericClassName = this.isNumericClassName(clazz, innerClassName, outerClassName);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        String innerClassName;
        int innerClassIndex = innerClassesInfo.u2innerClassIndex;
        int outerClassIndex = innerClassesInfo.u2outerClassIndex;
        if (innerClassIndex != 0 && outerClassIndex != 0 && (innerClassName = clazz.getClassName(innerClassIndex)).equals(clazz.getName())) {
            clazz.constantPoolEntryAccept(outerClassIndex, this);
            String outerClassName = clazz.getClassName(outerClassIndex);
            this.numericClassName = this.isNumericClassName(clazz, innerClassName, outerClassName);
        }
    }

    private boolean isNumericClassName(Clazz innerClass, String innerClassName, String outerClassName) {
        int innerClassNameLength;
        int innerClassNameStart;
        if (this.adaptKotlin) {
            ClassCounter counter = new ClassCounter();
            innerClass.accept(new ReferencedKotlinMetadataVisitor(new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, new KotlinMetadataToClazzVisitor(counter))));
            if (counter.getCount() == 1) {
                return true;
            }
        }
        if ((innerClassNameStart = outerClassName.length() + 1) >= (innerClassNameLength = innerClassName.length())) {
            return false;
        }
        for (int index = innerClassNameStart; index < innerClassNameLength; ++index) {
            if (Character.isDigit(innerClassName.charAt(index))) continue;
            return false;
        }
        return true;
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        classConstant.referencedClassAccept(this);
    }

    private String newPackagePrefix(String packagePrefix) {
        String newPackagePrefix = (String)this.packagePrefixMap.get(packagePrefix);
        if (newPackagePrefix == null) {
            if (this.keepPackageNamesMatcher != null && this.keepPackageNamesMatcher.matches(packagePrefix.length() > 0 ? packagePrefix.substring(0, packagePrefix.length() - 1) : packagePrefix)) {
                return packagePrefix;
            }
            if (this.repackageClasses != null) {
                return this.repackageClasses;
            }
            String newSuperPackagePrefix = this.flattenPackageHierarchy != null ? this.flattenPackageHierarchy : this.newPackagePrefix(ClassUtil.internalPackagePrefix(packagePrefix));
            newPackagePrefix = this.generateUniquePackagePrefix(newSuperPackagePrefix);
            this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
        }
        return newPackagePrefix;
    }

    private String generateUniquePackagePrefix(String newSuperPackagePrefix) {
        NameFactory packageNameFactory = (NameFactory)this.packagePrefixPackageNameFactoryMap.get(newSuperPackagePrefix);
        if (packageNameFactory == null) {
            packageNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.packageNameFactory != null) {
                packageNameFactory = new DictionaryNameFactory(this.packageNameFactory, packageNameFactory);
            }
            this.packagePrefixPackageNameFactoryMap.put(newSuperPackagePrefix, packageNameFactory);
        }
        return this.generateUniquePackagePrefix(newSuperPackagePrefix, packageNameFactory);
    }

    private String generateUniquePackagePrefix(String newSuperPackagePrefix, NameFactory packageNameFactory) {
        String newPackagePrefix;
        while (this.packagePrefixMap.containsValue(newPackagePrefix = newSuperPackagePrefix + packageNameFactory.nextName() + '/')) {
        }
        return newPackagePrefix;
    }

    private String generateUniqueClassName(String newPackagePrefix) {
        NameFactory classNameFactory = (NameFactory)this.packagePrefixClassNameFactoryMap.get(newPackagePrefix);
        if (classNameFactory == null) {
            classNameFactory = new SimpleNameFactory(this.useMixedCaseClassNames);
            if (this.classNameFactory != null) {
                classNameFactory = new DictionaryNameFactory(this.classNameFactory, classNameFactory);
            }
            this.packagePrefixClassNameFactoryMap.put(newPackagePrefix, classNameFactory);
        }
        return this.generateUniqueClassName(newPackagePrefix, classNameFactory);
    }

    private String generateUniqueNumericClassName(String newPackagePrefix) {
        NameFactory classNameFactory = (NameFactory)this.packagePrefixNumericClassNameFactoryMap.get(newPackagePrefix);
        if (classNameFactory == null) {
            classNameFactory = new NumericNameFactory();
            this.packagePrefixNumericClassNameFactoryMap.put(newPackagePrefix, classNameFactory);
        }
        return this.generateUniqueClassName(newPackagePrefix, classNameFactory);
    }

    private String generateUniqueClassName(String newPackagePrefix, NameFactory classNameFactory) {
        String newClassName;
        String newMixedCaseClassName;
        while (this.classNamesToAvoid.contains(newMixedCaseClassName = this.mixedCaseClassName(newClassName = newPackagePrefix + classNameFactory.nextName()))) {
        }
        if (this.classNameFactory != null && !this.useMixedCaseClassNames) {
            this.classNamesToAvoid.add(newMixedCaseClassName);
        }
        return newClassName;
    }

    private String mixedCaseClassName(String className) {
        return this.useMixedCaseClassNames ? className : className.toLowerCase();
    }

    static void setNewClassName(Clazz clazz, String name) {
        clazz.setVisitorInfo(name);
    }

    static boolean hasOriginalClassName(Clazz clazz) {
        return clazz.getName().equals(ClassObfuscator.newClassName(clazz));
    }

    static String newClassName(Clazz clazz) {
        Object visitorInfo = clazz.getVisitorInfo();
        return visitorInfo instanceof String ? (String)visitorInfo : null;
    }

    private class MyKeepCollector
    implements ClassVisitor {
        private MyKeepCollector() {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            String newClassName = ClassObfuscator.newClassName(programClass);
            if (newClassName != null) {
                ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(newClassName));
                if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                    String className = programClass.getName();
                    this.mapPackageName(className, newClassName, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
                }
            }
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            String newClassName = ClassObfuscator.newClassName(libraryClass);
            if (newClassName == null) {
                newClassName = libraryClass.getName();
            }
            ClassObfuscator.this.classNamesToAvoid.add(ClassObfuscator.this.mixedCaseClassName(newClassName));
            if (ClassObfuscator.this.repackageClasses == null || !ClassObfuscator.this.allowAccessModification) {
                String className = libraryClass.getName();
                this.mapPackageName(className, newClassName, ClassObfuscator.this.repackageClasses == null && ClassObfuscator.this.flattenPackageHierarchy == null);
            }
        }

        private void mapPackageName(String className, String newClassName, boolean recursively) {
            String packagePrefix = ClassUtil.internalPackagePrefix(className);
            String newPackagePrefix = ClassUtil.internalPackagePrefix(newClassName);
            do {
                ClassObfuscator.this.packagePrefixMap.put(packagePrefix, newPackagePrefix);
                if (!recursively) break;
                packagePrefix = ClassUtil.internalPackagePrefix(packagePrefix);
                newPackagePrefix = ClassUtil.internalPackagePrefix(newPackagePrefix);
            } while (packagePrefix.length() > 0 && newPackagePrefix.length() > 0);
        }
    }
}

