/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.visitors.KotlinInterfaceToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.visitor.AllFieldVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberNameFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.MemberObfuscator;

public class KotlinSyntheticClassFixer
implements KotlinMetadataVisitor {
    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (kotlinClassKindMetadata.flags.isInterface && kotlinClassKindMetadata.referencedDefaultImplsClass != null) {
            String className = ClassObfuscator.newClassName(kotlinClassKindMetadata.referencedClass);
            final String defaultImplsClassName = className.endsWith("$DefaultImpls") ? className : className + "$DefaultImpls";
            kotlinClassKindMetadata.accept(clazz, new KotlinInterfaceToDefaultImplsClassVisitor(new ClassVisitor(){

                @Override
                public void visitProgramClass(ProgramClass programClass) {
                    ClassObfuscator.setNewClassName(programClass, defaultImplsClassName);
                }

                @Override
                public void visitLibraryClass(LibraryClass libraryClass) {
                }
            }));
        }
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        if (kotlinSyntheticClassKindMetadata.kind == KotlinSyntheticClassKindMetadata.Kind.WHEN_MAPPINGS) {
            String originalName = ClassObfuscator.newClassName(kotlinSyntheticClassKindMetadata.referencedClass);
            if (!originalName.endsWith("$WhenMappings")) {
                ClassObfuscator.setNewClassName(kotlinSyntheticClassKindMetadata.referencedClass, originalName + "$WhenMappings");
            }
        } else if (kotlinSyntheticClassKindMetadata.kind == KotlinSyntheticClassKindMetadata.Kind.LAMBDA) {
            kotlinSyntheticClassKindMetadata.referencedClass.accept(new AllFieldVisitor(new MemberNameFilter("$*", new MemberVisitor(){

                @Override
                public void visitProgramField(ProgramClass programClass, ProgramField programField) {
                    MemberObfuscator.setNewMemberName(programField, "$" + MemberObfuscator.newMemberName(programField));
                }

                @Override
                public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
                }

                @Override
                public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
                }

                @Override
                public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
                }
            })));
        }
    }
}

