/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AllBootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.AllInnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.AttributeNameFilter;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.MultiAttributeVisitor;
import proguard.classfile.attribute.visitor.NonEmptyAttributeFilter;
import proguard.classfile.attribute.visitor.RequiredAttributeFilter;
import proguard.classfile.constant.visitor.AllBootstrapMethodArgumentVisitor;
import proguard.classfile.constant.visitor.AllConstantVisitor;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.editor.AccessFixer;
import proguard.classfile.editor.BridgeMethodFixer;
import proguard.classfile.editor.ClassReferenceFixer;
import proguard.classfile.editor.ConstantPoolShrinker;
import proguard.classfile.editor.InnerClassesAccessFixer;
import proguard.classfile.editor.MemberReferenceFixer;
import proguard.classfile.kotlin.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.asserter.KotlinMetadataAsserter;
import proguard.classfile.kotlin.fixer.KotlinAliasReferenceFixer;
import proguard.classfile.kotlin.obfuscate.InstructionSequenceObfuscator;
import proguard.classfile.kotlin.obfuscate.IntrinsicsReplacementSequences;
import proguard.classfile.kotlin.obfuscate.SourceDebugExtensionAttributeObfuscator;
import proguard.classfile.kotlin.obfuscate.UnsupportedExceptionReplacementSequences;
import proguard.classfile.kotlin.visitors.AllFunctionsVisitor;
import proguard.classfile.kotlin.visitors.AllKotlinPropertiesVisitor;
import proguard.classfile.kotlin.visitors.AllTypeVisitor;
import proguard.classfile.kotlin.visitors.AllValueParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinFunctionToDefaultMethodVisitor;
import proguard.classfile.kotlin.visitors.KotlinInterfaceToDefaultImplsClassVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataToClazzVisitor;
import proguard.classfile.kotlin.visitors.MultiKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.filter.KotlinClassKindFilter;
import proguard.classfile.kotlin.visitors.filter.KotlinSyntheticClassKindFilter;
import proguard.classfile.util.MethodLinker;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.AllMemberVisitor;
import proguard.classfile.visitor.AllMethodVisitor;
import proguard.classfile.visitor.BottomClassFilter;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.ClassVersionFilter;
import proguard.classfile.visitor.DynamicReturnedClassVisitor;
import proguard.classfile.visitor.FunctionalInterfaceFilter;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.obfuscate.AttributeShrinker;
import proguard.obfuscate.AttributeUsageMarker;
import proguard.obfuscate.ClassObfuscator;
import proguard.obfuscate.ClassRenamer;
import proguard.obfuscate.DictionaryNameFactory;
import proguard.obfuscate.KotlinAliasNameObfuscator;
import proguard.obfuscate.KotlinCompanionEqualizer;
import proguard.obfuscate.KotlinDataClassObfuscator;
import proguard.obfuscate.KotlinDefaultImplsMethodNameEqualizer;
import proguard.obfuscate.KotlinDefaultMethodNameEqualizer;
import proguard.obfuscate.KotlinPropertyNameObfuscator;
import proguard.obfuscate.KotlinPropertyRenamer;
import proguard.obfuscate.KotlinSyntheticClassFixer;
import proguard.obfuscate.KotlinValueParameterNameShrinker;
import proguard.obfuscate.KotlinValueParameterUsageMarker;
import proguard.obfuscate.MapCleaner;
import proguard.obfuscate.MappingKeeper;
import proguard.obfuscate.MappingPrinter;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.obfuscate.MemberNameCollector;
import proguard.obfuscate.MemberNameConflictFixer;
import proguard.obfuscate.MemberNameFilter;
import proguard.obfuscate.MemberObfuscator;
import proguard.obfuscate.MemberSpecialNameFilter;
import proguard.obfuscate.MultiMappingProcessor;
import proguard.obfuscate.NameFactory;
import proguard.obfuscate.NameMarker;
import proguard.obfuscate.ParameterNameMarker;
import proguard.obfuscate.RenamedFlagSetter;
import proguard.obfuscate.SimpleNameFactory;
import proguard.obfuscate.SourceFileRenamer;
import proguard.obfuscate.SpecialNameFactory;
import proguard.util.PrintWriterUtil;

public class Obfuscator {
    private final Configuration configuration;

    public Obfuscator(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null && this.configuration.applyMapping == null && this.configuration.printMapping == null) {
            throw new IOException("You have to specify '-keep' options for the obfuscation step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        PrintWriter err = new PrintWriter(System.err, true);
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        BottomClassFilter memberInfoLinker = new BottomClassFilter(new MethodLinker());
        programClassPool.classesAccept(memberInfoLinker);
        libraryClassPool.classesAccept(memberInfoLinker);
        if (this.configuration.useUniqueClassMemberNames) {
            programClassPool.classesAccept(new AllMemberVisitor(new MethodLinker()));
        }
        NameMarker nameMarker = new NameMarker();
        libraryClassPool.classesAccept(nameMarker);
        libraryClassPool.classesAccept(new AllMemberVisitor(nameMarker));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassProcessingFlagFilter(0x400000, 0, nameMarker), new AllMemberVisitor(new MemberProcessingFlagFilter(0x400000, 0, nameMarker))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllAttributeVisitor(new AttributeNameFilter("BootstrapMethods", (AttributeVisitor)new AllBootstrapMethodInfoVisitor(new AllBootstrapMethodArgumentVisitor(new ConstantTagFilter(7, (ConstantVisitor)new ReferencedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new AllMethodVisitor(new MemberAccessFilter(1024, 0, nameMarker))))))))))));
        programClassPool.classesAccept(new ClassVersionFilter(0x330000, new AllConstantVisitor(new DynamicReturnedClassVisitor(new FunctionalInterfaceFilter(new ClassHierarchyTraveler(true, false, true, false, new AllMethodVisitor(new MemberAccessFilter(1024, 0, nameMarker))))))));
        if (this.configuration.adaptKotlinMetadata) {
            programClassPool.classesAccept(new ClassProcessingFlagFilter(0x400000, 0, new ReferencedKotlinMetadataVisitor(new KotlinInterfaceToDefaultImplsClassVisitor(nameMarker))));
        }
        NonEmptyAttributeFilter attributeUsageMarker = new NonEmptyAttributeFilter(new AttributeUsageMarker());
        AttributeNameFilter optionalAttributeUsageMarker = this.configuration.keepAttributes == null ? null : new AttributeNameFilter(this.configuration.keepAttributes, (AttributeVisitor)attributeUsageMarker);
        programClassPool.classesAccept(new AllAttributeVisitor(true, new RequiredAttributeFilter(attributeUsageMarker, optionalAttributeUsageMarker)));
        if (this.configuration.keepParameterNames) {
            programClassPool.classesAccept(new AllMethodVisitor(new MemberNameFilter(new AllAttributeVisitor(true, new ParameterNameMarker(attributeUsageMarker)))));
            if (this.configuration.adaptKotlinMetadata) {
                programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinValueParameterUsageMarker()));
            }
        }
        if (this.configuration.adaptKotlinMetadata) {
            programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new AllValueParameterVisitor(new KotlinValueParameterNameShrinker())));
            programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinSyntheticClassKindFilter(KotlinSyntheticClassKindFilter::isLambda, new KotlinMetadataToClazzVisitor(new AllAttributeVisitor(new AttributeNameFilter("SourceDebugExtension", (AttributeVisitor)new MultiAttributeVisitor(attributeUsageMarker, new SourceDebugExtensionAttributeObfuscator())))))));
        }
        programClassPool.classesAccept(new AttributeShrinker());
        if (this.configuration.applyMapping != null) {
            if (this.configuration.verbose) {
                out.println("Applying mapping from [" + PrintWriterUtil.fileName(this.configuration.applyMapping) + "]...");
            }
            WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
            MappingReader reader = new MappingReader(this.configuration.applyMapping);
            MultiMappingProcessor keeper = new MultiMappingProcessor(new MappingProcessor[]{new MappingKeeper(programClassPool, warningPrinter), new MappingKeeper(libraryClassPool, null)});
            reader.pump(keeper);
            int warningCount = warningPrinter.getWarningCount();
            if (warningCount > 0) {
                err.println("Warning: there were " + warningCount + " kept classes and class members that were remapped anyway.");
                err.println("         You should adapt your configuration or edit the mapping file.");
                if (!this.configuration.ignoreWarnings) {
                    err.println("         If you are sure this remapping won't hurt,");
                    err.println("         you could try your luck using the '-ignorewarnings' option.");
                }
                err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#mappingconflict1)");
                if (!this.configuration.ignoreWarnings) {
                    throw new IOException("Please correct the above warnings first.");
                }
            }
        }
        DictionaryNameFactory classNameFactory = this.configuration.classObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.classObfuscationDictionary, null) : null;
        DictionaryNameFactory packageNameFactory = this.configuration.packageObfuscationDictionary != null ? new DictionaryNameFactory(this.configuration.packageObfuscationDictionary, null) : null;
        programClassPool.classesAccept(new ClassObfuscator(programClassPool, libraryClassPool, classNameFactory, packageNameFactory, this.configuration.useMixedCaseClassNames, this.configuration.keepPackageNames, this.configuration.flattenPackageHierarchy, this.configuration.repackageClasses, this.configuration.allowAccessModification, this.configuration.adaptKotlinMetadata));
        NameFactory nameFactory = new SimpleNameFactory();
        if (this.configuration.obfuscationDictionary != null) {
            nameFactory = new DictionaryNameFactory(this.configuration.obfuscationDictionary, nameFactory);
        }
        WarningPrinter warningPrinter = new WarningPrinter(err, this.configuration.warn);
        HashMap descriptorMap = new HashMap();
        if (this.configuration.useUniqueClassMemberNames) {
            programClassPool.classesAccept(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)));
            programClassPool.classesAccept(new AllMemberVisitor(new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap)));
        } else {
            programClassPool.classesAccept(new MultiClassVisitor(new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, true, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)));
            programClassPool.classesAccept(new MultiClassVisitor(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(false, false, false, true, new ClassAccessFilter(1024, 0, new ClassHierarchyTraveler(false, false, true, false, new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new ClassHierarchyTraveler(false, false, false, true, new ClassHierarchyTraveler(false, false, true, false, new AllMethodVisitor(new MemberAccessFilter(0, 1032, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap))))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberObfuscator(this.configuration.overloadAggressively, nameFactory, descriptorMap))), new MapCleaner(descriptorMap)));
        }
        SpecialNameFactory specialNameFactory = new SpecialNameFactory(new SimpleNameFactory());
        HashMap specialDescriptorMap = new HashMap();
        programClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        libraryClassPool.classesAccept(new AllMemberVisitor(new MemberSpecialNameFilter(new MemberNameCollector(this.configuration.overloadAggressively, specialDescriptorMap))));
        programClassPool.classesAccept(new MultiClassVisitor(new ClassHierarchyTraveler(true, false, false, true, new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new ClassHierarchyTraveler(true, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap))))), new MapCleaner(descriptorMap)));
        programClassPool.classesAccept(new MultiClassVisitor(new AllMemberVisitor(new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)), new ClassHierarchyTraveler(false, true, true, false, new AllMemberVisitor(new MemberAccessFilter(0, 2, new MemberNameCollector(this.configuration.overloadAggressively, descriptorMap)))), new AllMemberVisitor(new MemberAccessFilter(2, 0, new MemberNameConflictFixer(this.configuration.overloadAggressively, descriptorMap, warningPrinter, new MemberObfuscator(this.configuration.overloadAggressively, specialNameFactory, specialDescriptorMap)))), new MapCleaner(descriptorMap)));
        int warningCount = warningPrinter.getWarningCount();
        if (warningCount > 0) {
            err.println("Warning: there were " + warningCount + " conflicting class member name mappings.");
            err.println("         Your configuration may be inconsistent.");
            if (!this.configuration.ignoreWarnings) {
                err.println("         If you are sure the conflicts are harmless,");
                err.println("         you could try your luck using the '-ignorewarnings' option.");
            }
            err.println("         (http://proguard.sourceforge.net/manual/troubleshooting.html#mappingconflict2)");
            if (!this.configuration.ignoreWarnings) {
                throw new IOException("Please correct the above warnings first.");
            }
        }
        if (this.configuration.adaptKotlinMetadata) {
            programClassPool.classesAccept(new MultiClassVisitor(new InstructionSequenceObfuscator(new IntrinsicsReplacementSequences(programClassPool, libraryClassPool)), new ReferencedKotlinMetadataVisitor(new MultiKotlinMetadataVisitor(new KotlinPropertyNameObfuscator(nameFactory), new KotlinAliasNameObfuscator(nameFactory), new KotlinCompanionEqualizer(), new KotlinSyntheticClassFixer(), new AllFunctionsVisitor(new KotlinDefaultImplsMethodNameEqualizer(), new KotlinDefaultMethodNameEqualizer(), new KotlinFunctionToDefaultMethodVisitor(new InstructionSequenceObfuscator(new UnsupportedExceptionReplacementSequences(programClassPool, libraryClassPool)))), new KotlinClassKindFilter(kc -> kc.flags.isData, new KotlinDataClassObfuscator())))));
        }
        if (this.configuration.printMapping != null) {
            if (this.configuration.verbose) {
                out.println("Printing mapping to [" + PrintWriterUtil.fileName(this.configuration.printMapping) + "]...");
            }
            PrintWriter mappingWriter = PrintWriterUtil.createPrintWriter(this.configuration.printMapping, out);
            try {
                programClassPool.classesAcceptAlphabetically(new MappingPrinter(mappingWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printMapping, mappingWriter);
            }
        }
        if (this.configuration.addConfigurationDebugging) {
            programClassPool.classesAccept(new RenamedFlagSetter());
        }
        programClassPool.classesAccept(new ClassRenamer());
        libraryClassPool.classesAccept(new ClassRenamer());
        if (this.configuration.adaptKotlinMetadata) {
            programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new AllKotlinPropertiesVisitor(new KotlinPropertyRenamer())));
        }
        programClassPool.classesAccept(new ClassReferenceFixer(false));
        libraryClassPool.classesAccept(new ClassReferenceFixer(false));
        programClassPool.classesAccept(new MemberReferenceFixer(this.configuration.android));
        if (this.configuration.adaptKotlinMetadata) {
            programClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new AllTypeVisitor(new KotlinAliasReferenceFixer())));
            if (this.configuration.enableKotlinAsserter) {
                ReferencedKotlinMetadataVisitor kotlinAsserter = new ReferencedKotlinMetadataVisitor(new KotlinMetadataAsserter(programClassPool, libraryClassPool, warningPrinter));
                programClassPool.classesAccept(kotlinAsserter);
                libraryClassPool.classesAccept(kotlinAsserter);
            }
        }
        if (this.configuration.repackageClasses != null && this.configuration.allowAccessModification) {
            programClassPool.classesAccept(new AccessFixer());
            programClassPool.classesAccept(new AllAttributeVisitor(new AllInnerClassesInfoVisitor(new InnerClassesAccessFixer())));
        }
        programClassPool.classesAccept(new AllMethodVisitor(new BridgeMethodFixer()));
        if (this.configuration.newSourceFileAttribute != null) {
            programClassPool.classesAccept(new SourceFileRenamer(this.configuration.newSourceFileAttribute));
        }
        programClassPool.classesAccept(new ConstantPoolShrinker());
    }
}

