/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.Field;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.BootstrapMethodInfo;
import proguard.classfile.attribute.BootstrapMethodsAttribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.ConstantValueAttribute;
import proguard.classfile.attribute.DeprecatedAttribute;
import proguard.classfile.attribute.EnclosingMethodAttribute;
import proguard.classfile.attribute.ExceptionInfo;
import proguard.classfile.attribute.ExceptionsAttribute;
import proguard.classfile.attribute.InnerClassesAttribute;
import proguard.classfile.attribute.InnerClassesInfo;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.LocalVariableTableAttribute;
import proguard.classfile.attribute.LocalVariableTypeTableAttribute;
import proguard.classfile.attribute.MethodParametersAttribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.ParameterInfo;
import proguard.classfile.attribute.SignatureAttribute;
import proguard.classfile.attribute.SourceDebugExtensionAttribute;
import proguard.classfile.attribute.SourceDirAttribute;
import proguard.classfile.attribute.SourceFileAttribute;
import proguard.classfile.attribute.SyntheticAttribute;
import proguard.classfile.attribute.UnknownAttribute;
import proguard.classfile.attribute.annotation.AnnotationDefaultAttribute;
import proguard.classfile.attribute.annotation.AnnotationsAttribute;
import proguard.classfile.attribute.annotation.ParameterAnnotationsAttribute;
import proguard.classfile.attribute.module.ExportsInfo;
import proguard.classfile.attribute.module.ModuleAttribute;
import proguard.classfile.attribute.module.ModuleMainClassAttribute;
import proguard.classfile.attribute.module.ModulePackagesAttribute;
import proguard.classfile.attribute.module.OpensInfo;
import proguard.classfile.attribute.module.ProvidesInfo;
import proguard.classfile.attribute.module.RequiresInfo;
import proguard.classfile.attribute.module.visitor.ExportsInfoVisitor;
import proguard.classfile.attribute.module.visitor.OpensInfoVisitor;
import proguard.classfile.attribute.module.visitor.ProvidesInfoVisitor;
import proguard.classfile.attribute.module.visitor.RequiresInfoVisitor;
import proguard.classfile.attribute.preverification.FullFrame;
import proguard.classfile.attribute.preverification.MoreZeroFrame;
import proguard.classfile.attribute.preverification.ObjectType;
import proguard.classfile.attribute.preverification.SameOneFrame;
import proguard.classfile.attribute.preverification.StackMapAttribute;
import proguard.classfile.attribute.preverification.StackMapFrame;
import proguard.classfile.attribute.preverification.StackMapTableAttribute;
import proguard.classfile.attribute.preverification.VerificationType;
import proguard.classfile.attribute.preverification.visitor.StackMapFrameVisitor;
import proguard.classfile.attribute.preverification.visitor.VerificationTypeVisitor;
import proguard.classfile.attribute.visitor.AllAttributeVisitor;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.attribute.visitor.BootstrapMethodInfoVisitor;
import proguard.classfile.attribute.visitor.ExceptionInfoVisitor;
import proguard.classfile.attribute.visitor.InnerClassesInfoVisitor;
import proguard.classfile.attribute.visitor.ParameterInfoVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.DoubleConstant;
import proguard.classfile.constant.DynamicConstant;
import proguard.classfile.constant.FloatConstant;
import proguard.classfile.constant.IntegerConstant;
import proguard.classfile.constant.InvokeDynamicConstant;
import proguard.classfile.constant.LongConstant;
import proguard.classfile.constant.MethodHandleConstant;
import proguard.classfile.constant.MethodTypeConstant;
import proguard.classfile.constant.ModuleConstant;
import proguard.classfile.constant.NameAndTypeConstant;
import proguard.classfile.constant.PackageConstant;
import proguard.classfile.constant.PrimitiveArrayConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantTagFilter;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.instruction.ConstantInstruction;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassAccessFilter;
import proguard.classfile.visitor.ClassHierarchyTraveler;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.ConcreteClassDownTraveler;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ProgramClassFilter;
import proguard.classfile.visitor.ReferencedClassVisitor;
import proguard.shrink.SimpleUsageMarker;

public class ClassUsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
ConstantVisitor,
AttributeVisitor,
InnerClassesInfoVisitor,
ExceptionInfoVisitor,
StackMapFrameVisitor,
VerificationTypeVisitor,
ParameterInfoVisitor,
RequiresInfoVisitor,
ExportsInfoVisitor,
OpensInfoVisitor,
ProvidesInfoVisitor,
InstructionVisitor {
    private final Object POSSIBLY_USED = new Object();
    private final SimpleUsageMarker usageMarker;
    private final ClassVisitor interfaceUsageMarker;
    private final MyDefaultMethodUsageMarker defaultMethodUsageMarker = new MyDefaultMethodUsageMarker();
    private final MyPossiblyUsedMemberUsageMarker possiblyUsedMemberUsageMarker = new MyPossiblyUsedMemberUsageMarker();
    private final MemberVisitor nonEmptyMethodUsageMarker = new AllAttributeVisitor(new MyNonEmptyMethodUsageMarker());
    private final ConstantVisitor parameterlessConstructorMarker = new ConstantTagFilter(new int[]{8, 7}, (ConstantVisitor)new ReferencedClassVisitor(new NamedMethodVisitor("<init>", "()V", this)));
    private ConstantVisitor extraConstantVisitor;
    private MemberVisitor extraMethodVisitor;

    public ClassUsageMarker() {
        this(new SimpleUsageMarker(), false);
    }

    public ClassUsageMarker(SimpleUsageMarker usageMarker) {
        this(usageMarker, false);
    }

    public ClassUsageMarker(SimpleUsageMarker usageMarker, boolean keepAllInterfaces) {
        this.usageMarker = usageMarker;
        this.interfaceUsageMarker = keepAllInterfaces ? this : new MyInterfaceUsageMarker();
    }

    public SimpleUsageMarker getUsageMarker() {
        return this.usageMarker;
    }

    public void setExtraConstantVisitor(ConstantVisitor extraConstantVisitor) {
        this.extraConstantVisitor = extraConstantVisitor;
    }

    public ConstantVisitor getExtraConstantVisitor() {
        return this.extraConstantVisitor;
    }

    public void setExtraMethodVisitor(MemberVisitor extraMethodVisitor) {
        this.extraMethodVisitor = extraMethodVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.shouldBeMarkedAsUsed(programClass)) {
            this.markAsUsed(programClass);
            this.markProgramClassBody(programClass);
        }
    }

    protected void markProgramClassBody(ProgramClass programClass) {
        this.markConstant(programClass, programClass.u2thisClass);
        this.markOptionalConstant(programClass, programClass.u2superClass);
        programClass.hierarchyAccept(false, false, true, false, this.interfaceUsageMarker);
        programClass.methodAccept("<clinit>", "()V", this.nonEmptyMethodUsageMarker);
        programClass.fieldsAccept(this.possiblyUsedMemberUsageMarker);
        programClass.methodsAccept(this.possiblyUsedMemberUsageMarker);
        programClass.attributesAccept(this);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        if (this.shouldBeMarkedAsUsed(libraryClass)) {
            Clazz[] interfaceClasses;
            this.markAsUsed(libraryClass);
            Clazz superClass = libraryClass.superClass;
            if (superClass != null) {
                superClass.accept(this);
            }
            if ((interfaceClasses = libraryClass.interfaceClasses) != null) {
                for (int index = 0; index < interfaceClasses.length; ++index) {
                    if (interfaceClasses[index] == null) continue;
                    interfaceClasses[index].accept(this);
                }
            }
            libraryClass.methodsAccept(this);
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.shouldBeMarkedAsUsed(programField)) {
            if (this.isUsed(programClass)) {
                this.markAsUsed(programField);
                this.markProgramFieldBody(programClass, programField);
            } else if (this.shouldBeMarkedAsPossiblyUsed(programClass, programField)) {
                this.markAsPossiblyUsed(programField);
            }
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.shouldBeMarkedAsUsed(programMethod)) {
            if (this.isUsed(programClass)) {
                this.markAsUsed(programMethod);
                this.markProgramMethodBody(programClass, programMethod);
                this.markMethodHierarchy(programClass, programMethod);
            } else if (this.shouldBeMarkedAsPossiblyUsed(programClass, programMethod)) {
                this.markAsPossiblyUsed(programMethod);
                this.markMethodHierarchy(programClass, programMethod);
            }
        }
    }

    @Override
    public void visitLibraryField(LibraryClass programClass, LibraryField programField) {
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        if (this.shouldBeMarkedAsUsed(libraryMethod)) {
            this.markAsUsed(libraryMethod);
            this.markMethodHierarchy(libraryClass, libraryMethod);
            if (this.extraMethodVisitor != null) {
                libraryMethod.accept(libraryClass, this.extraMethodVisitor);
            }
        }
    }

    protected void markProgramFieldBody(ProgramClass programClass, ProgramField programField) {
        this.markConstant(programClass, programField.u2nameIndex);
        this.markConstant(programClass, programField.u2descriptorIndex);
        programField.attributesAccept(programClass, this);
        programField.referencedClassesAccept(this);
    }

    protected void markProgramMethodBody(ProgramClass programClass, ProgramMethod programMethod) {
        this.markConstant(programClass, programMethod.u2nameIndex);
        this.markConstant(programClass, programMethod.u2descriptorIndex);
        programMethod.attributesAccept(programClass, this);
        programMethod.referencedClassesAccept(this);
        if (this.extraMethodVisitor != null) {
            programMethod.accept(programClass, this.extraMethodVisitor);
        }
    }

    protected void markMethodHierarchy(Clazz clazz, Method method) {
        int accessFlags = method.getAccessFlags();
        if ((accessFlags & 0xA) == 0 && !ClassUtil.isInitializer(method.getName(clazz))) {
            int requiredUnsetAccessFlags = 0xA | ((accessFlags & 1) == 0 ? 0 : 1024);
            clazz.accept(new ClassAccessFilter(512, 0, new ClassHierarchyTraveler(false, false, false, true, new ProgramClassFilter(new ClassAccessFilter(512, 0, new NamedMethodVisitor(method.getName(clazz), method.getDescriptor(clazz), new MemberAccessFilter(0, requiredUnsetAccessFlags, this.defaultMethodUsageMarker)))))));
            clazz.accept(new ConcreteClassDownTraveler(new ClassHierarchyTraveler(true, true, false, true, new NamedMethodVisitor(method.getName(clazz), method.getDescriptor(clazz), new MemberAccessFilter(0, requiredUnsetAccessFlags, this)))));
        }
    }

    @Override
    public void visitIntegerConstant(Clazz clazz, IntegerConstant integerConstant) {
        if (this.shouldBeMarkedAsUsed(integerConstant)) {
            this.markAsUsed(integerConstant);
            if (this.extraConstantVisitor != null) {
                this.extraConstantVisitor.visitIntegerConstant(clazz, integerConstant);
            }
        }
    }

    @Override
    public void visitLongConstant(Clazz clazz, LongConstant longConstant) {
        if (this.shouldBeMarkedAsUsed(longConstant)) {
            this.markAsUsed(longConstant);
        }
    }

    @Override
    public void visitFloatConstant(Clazz clazz, FloatConstant floatConstant) {
        if (this.shouldBeMarkedAsUsed(floatConstant)) {
            this.markAsUsed(floatConstant);
        }
    }

    @Override
    public void visitDoubleConstant(Clazz clazz, DoubleConstant doubleConstant) {
        if (this.shouldBeMarkedAsUsed(doubleConstant)) {
            this.markAsUsed(doubleConstant);
        }
    }

    @Override
    public void visitPrimitiveArrayConstant(Clazz clazz, PrimitiveArrayConstant primitiveArrayConstant) {
        if (this.shouldBeMarkedAsUsed(primitiveArrayConstant)) {
            this.markAsUsed(primitiveArrayConstant);
        }
        if (this.extraConstantVisitor != null) {
            this.extraConstantVisitor.visitPrimitiveArrayConstant(clazz, primitiveArrayConstant);
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        if (this.shouldBeMarkedAsUsed(stringConstant)) {
            this.markAsUsed(stringConstant);
            this.markConstant(clazz, stringConstant.u2stringIndex);
            stringConstant.referencedClassAccept(this);
            stringConstant.referencedMemberAccept(this);
            if (this.extraConstantVisitor != null) {
                this.extraConstantVisitor.visitStringConstant(clazz, stringConstant);
            }
        }
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (this.shouldBeMarkedAsUsed(utf8Constant)) {
            this.markAsUsed(utf8Constant);
        }
    }

    @Override
    public void visitDynamicConstant(Clazz clazz, DynamicConstant dynamicConstant) {
        if (this.shouldBeMarkedAsUsed(dynamicConstant)) {
            this.markAsUsed(dynamicConstant);
            this.markConstant(clazz, dynamicConstant.u2nameAndTypeIndex);
            dynamicConstant.referencedClassesAccept(this);
            clazz.attributesAccept(new MyBootStrapMethodUsageMarker(dynamicConstant.u2bootstrapMethodAttributeIndex));
        }
    }

    @Override
    public void visitInvokeDynamicConstant(Clazz clazz, InvokeDynamicConstant invokeDynamicConstant) {
        if (this.shouldBeMarkedAsUsed(invokeDynamicConstant)) {
            this.markAsUsed(invokeDynamicConstant);
            this.markConstant(clazz, invokeDynamicConstant.u2nameAndTypeIndex);
            invokeDynamicConstant.referencedClassesAccept(this);
            clazz.attributesAccept(new MyBootStrapMethodUsageMarker(invokeDynamicConstant.u2bootstrapMethodAttributeIndex));
        }
    }

    @Override
    public void visitMethodHandleConstant(Clazz clazz, MethodHandleConstant methodHandleConstant) {
        if (this.shouldBeMarkedAsUsed(methodHandleConstant)) {
            this.markAsUsed(methodHandleConstant);
            this.markConstant(clazz, methodHandleConstant.u2referenceIndex);
        }
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        if (this.shouldBeMarkedAsUsed(refConstant)) {
            this.markAsUsed(refConstant);
            this.markConstant(clazz, refConstant.u2classIndex);
            this.markConstant(clazz, refConstant.u2nameAndTypeIndex);
            refConstant.referencedClassAccept(this);
            refConstant.referencedMemberAccept(this);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        if (this.shouldBeMarkedAsUsed(classConstant)) {
            this.markAsUsed(classConstant);
            this.markConstant(clazz, classConstant.u2nameIndex);
            classConstant.referencedClassAccept(this);
        }
    }

    @Override
    public void visitMethodTypeConstant(Clazz clazz, MethodTypeConstant methodTypeConstant) {
        if (this.shouldBeMarkedAsUsed(methodTypeConstant)) {
            this.markAsUsed(methodTypeConstant);
            this.markConstant(clazz, methodTypeConstant.u2descriptorIndex);
            methodTypeConstant.referencedClassesAccept(this);
        }
    }

    @Override
    public void visitNameAndTypeConstant(Clazz clazz, NameAndTypeConstant nameAndTypeConstant) {
        if (this.shouldBeMarkedAsUsed(nameAndTypeConstant)) {
            this.markAsUsed(nameAndTypeConstant);
            this.markConstant(clazz, nameAndTypeConstant.u2nameIndex);
            this.markConstant(clazz, nameAndTypeConstant.u2descriptorIndex);
        }
    }

    @Override
    public void visitModuleConstant(Clazz clazz, ModuleConstant moduleConstant) {
        if (this.shouldBeMarkedAsUsed(moduleConstant)) {
            this.markAsUsed(moduleConstant);
            this.markConstant(clazz, moduleConstant.u2nameIndex);
        }
    }

    @Override
    public void visitPackageConstant(Clazz clazz, PackageConstant packageConstant) {
        if (this.shouldBeMarkedAsUsed(packageConstant)) {
            this.markAsUsed(packageConstant);
            this.markConstant(clazz, packageConstant.u2nameIndex);
        }
    }

    @Override
    public void visitUnknownAttribute(Clazz clazz, UnknownAttribute unknownAttribute) {
        this.markAsUsed(unknownAttribute);
        this.markConstant(clazz, unknownAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitSourceDebugExtensionAttribute(Clazz clazz, SourceDebugExtensionAttribute sourceDebugExtensionAttribute) {
        this.markAsUsed(sourceDebugExtensionAttribute);
        this.markConstant(clazz, sourceDebugExtensionAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
    }

    @Override
    public void visitSourceFileAttribute(Clazz clazz, SourceFileAttribute sourceFileAttribute) {
        this.markAsUsed(sourceFileAttribute);
        this.markConstant(clazz, sourceFileAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceFileAttribute.u2sourceFileIndex);
    }

    @Override
    public void visitSourceDirAttribute(Clazz clazz, SourceDirAttribute sourceDirAttribute) {
        this.markAsUsed(sourceDirAttribute);
        this.markConstant(clazz, sourceDirAttribute.u2attributeNameIndex);
        this.markConstant(clazz, sourceDirAttribute.u2sourceDirIndex);
    }

    @Override
    public void visitInnerClassesAttribute(Clazz clazz, InnerClassesAttribute innerClassesAttribute) {
        innerClassesAttribute.innerClassEntriesAccept(clazz, this);
    }

    @Override
    public void visitEnclosingMethodAttribute(Clazz clazz, EnclosingMethodAttribute enclosingMethodAttribute) {
        this.markAsUsed(enclosingMethodAttribute);
        this.markConstant(clazz, enclosingMethodAttribute.u2attributeNameIndex);
        this.markConstant(clazz, enclosingMethodAttribute.u2classIndex);
        this.markOptionalConstant(clazz, enclosingMethodAttribute.u2nameAndTypeIndex);
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
    }

    @Override
    public void visitModuleAttribute(Clazz clazz, ModuleAttribute moduleAttribute) {
        this.markAsUsed(moduleAttribute);
        this.markConstant(clazz, moduleAttribute.u2attributeNameIndex);
        this.markConstant(clazz, moduleAttribute.u2moduleNameIndex);
        this.markOptionalConstant(clazz, moduleAttribute.u2moduleVersionIndex);
        moduleAttribute.requiresAccept(clazz, this);
        moduleAttribute.exportsAccept(clazz, this);
        moduleAttribute.opensAccept(clazz, this);
        this.markConstants(clazz, moduleAttribute.u2uses, moduleAttribute.u2usesCount);
        moduleAttribute.providesAccept(clazz, this);
    }

    @Override
    public void visitModuleMainClassAttribute(Clazz clazz, ModuleMainClassAttribute moduleMainClassAttribute) {
        this.markAsUsed(moduleMainClassAttribute);
        this.markConstant(clazz, moduleMainClassAttribute.u2attributeNameIndex);
        this.markConstant(clazz, moduleMainClassAttribute.u2mainClass);
    }

    @Override
    public void visitModulePackagesAttribute(Clazz clazz, ModulePackagesAttribute modulePackagesAttribute) {
        this.markAsUsed(modulePackagesAttribute);
        this.markConstant(clazz, modulePackagesAttribute.u2attributeNameIndex);
        modulePackagesAttribute.packagesAccept(clazz, this);
    }

    @Override
    public void visitDeprecatedAttribute(Clazz clazz, DeprecatedAttribute deprecatedAttribute) {
        this.markAsUsed(deprecatedAttribute);
        this.markConstant(clazz, deprecatedAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitSyntheticAttribute(Clazz clazz, SyntheticAttribute syntheticAttribute) {
        this.markAsUsed(syntheticAttribute);
        this.markConstant(clazz, syntheticAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitSignatureAttribute(Clazz clazz, SignatureAttribute signatureAttribute) {
        this.markAsUsed(signatureAttribute);
        this.markConstant(clazz, signatureAttribute.u2attributeNameIndex);
        this.markConstant(clazz, signatureAttribute.u2signatureIndex);
    }

    @Override
    public void visitConstantValueAttribute(Clazz clazz, Field field, ConstantValueAttribute constantValueAttribute) {
        this.markAsUsed(constantValueAttribute);
        this.markConstant(clazz, constantValueAttribute.u2attributeNameIndex);
        this.markConstant(clazz, constantValueAttribute.u2constantValueIndex);
    }

    @Override
    public void visitMethodParametersAttribute(Clazz clazz, Method method, MethodParametersAttribute methodParametersAttribute) {
        this.markAsUsed(methodParametersAttribute);
        this.markConstant(clazz, methodParametersAttribute.u2attributeNameIndex);
        methodParametersAttribute.parametersAccept(clazz, method, this);
    }

    @Override
    public void visitExceptionsAttribute(Clazz clazz, Method method, ExceptionsAttribute exceptionsAttribute) {
        this.markAsUsed(exceptionsAttribute);
        this.markConstant(clazz, exceptionsAttribute.u2attributeNameIndex);
        exceptionsAttribute.exceptionEntriesAccept(clazz, this);
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        this.markAsUsed(codeAttribute);
        this.markConstant(clazz, codeAttribute.u2attributeNameIndex);
        codeAttribute.instructionsAccept(clazz, method, this);
        codeAttribute.exceptionsAccept(clazz, method, this);
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitStackMapAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapAttribute stackMapAttribute) {
        this.markAsUsed(stackMapAttribute);
        this.markConstant(clazz, stackMapAttribute.u2attributeNameIndex);
        stackMapAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitStackMapTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, StackMapTableAttribute stackMapTableAttribute) {
        this.markAsUsed(stackMapTableAttribute);
        this.markConstant(clazz, stackMapTableAttribute.u2attributeNameIndex);
        stackMapTableAttribute.stackMapFramesAccept(clazz, method, codeAttribute, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.markAsUsed(lineNumberTableAttribute);
        this.markConstant(clazz, lineNumberTableAttribute.u2attributeNameIndex);
    }

    @Override
    public void visitLocalVariableTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTableAttribute localVariableTableAttribute) {
    }

    @Override
    public void visitLocalVariableTypeTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LocalVariableTypeTableAttribute localVariableTypeTableAttribute) {
    }

    @Override
    public void visitAnyAnnotationsAttribute(Clazz clazz, AnnotationsAttribute annotationsAttribute) {
    }

    @Override
    public void visitAnyParameterAnnotationsAttribute(Clazz clazz, Method method, ParameterAnnotationsAttribute parameterAnnotationsAttribute) {
    }

    @Override
    public void visitAnnotationDefaultAttribute(Clazz clazz, Method method, AnnotationDefaultAttribute annotationDefaultAttribute) {
    }

    @Override
    public void visitExceptionInfo(Clazz clazz, Method method, CodeAttribute codeAttribute, ExceptionInfo exceptionInfo) {
        this.markAsUsed(exceptionInfo);
        this.markOptionalConstant(clazz, exceptionInfo.u2catchType);
    }

    @Override
    public void visitInnerClassesInfo(Clazz clazz, InnerClassesInfo innerClassesInfo) {
        if (innerClassesInfo.u2innerClassIndex != 0 && clazz.getName().equals(clazz.getClassName(innerClassesInfo.u2innerClassIndex))) {
            this.markAsUsed(innerClassesInfo);
            innerClassesInfo.innerClassConstantAccept(clazz, this);
            innerClassesInfo.outerClassConstantAccept(clazz, this);
            innerClassesInfo.innerNameConstantAccept(clazz, this);
        }
    }

    @Override
    public void visitAnyStackMapFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, StackMapFrame stackMapFrame) {
    }

    @Override
    public void visitSameOneFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, SameOneFrame sameOneFrame) {
        sameOneFrame.stackItemAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitMoreZeroFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, MoreZeroFrame moreZeroFrame) {
        moreZeroFrame.additionalVariablesAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitFullFrame(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, FullFrame fullFrame) {
        fullFrame.variablesAccept(clazz, method, codeAttribute, offset, this);
        fullFrame.stackAccept(clazz, method, codeAttribute, offset, this);
    }

    @Override
    public void visitAnyVerificationType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, VerificationType verificationType) {
    }

    @Override
    public void visitObjectType(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ObjectType objectType) {
        this.markConstant(clazz, objectType.u2classIndex);
    }

    @Override
    public void visitParameterInfo(Clazz clazz, Method method, int parameterIndex, ParameterInfo parameterInfo) {
        parameterInfo.nameConstantAccept(clazz, this);
    }

    @Override
    public void visitRequiresInfo(Clazz clazz, RequiresInfo requiresInfo) {
        this.markConstant(clazz, requiresInfo.u2requiresIndex);
        this.markOptionalConstant(clazz, requiresInfo.u2requiresVersionIndex);
    }

    @Override
    public void visitExportsInfo(Clazz clazz, ExportsInfo exportsInfo) {
        this.markConstant(clazz, exportsInfo.u2exportsIndex);
        this.markConstants(clazz, exportsInfo.u2exportsToIndex, exportsInfo.u2exportsToCount);
    }

    @Override
    public void visitOpensInfo(Clazz clazz, OpensInfo opensInfo) {
        this.markConstant(clazz, opensInfo.u2opensIndex);
        this.markConstants(clazz, opensInfo.u2opensToIndex, opensInfo.u2opensToCount);
    }

    @Override
    public void visitProvidesInfo(Clazz clazz, ProvidesInfo providesInfo) {
        this.markConstant(clazz, providesInfo.u2providesIndex);
        this.markConstants(clazz, providesInfo.u2providesWithIndex, providesInfo.u2providesWithCount);
    }

    @Override
    public void visitAnyInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, Instruction instruction) {
    }

    @Override
    public void visitConstantInstruction(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, ConstantInstruction constantInstruction) {
        this.markConstant(clazz, constantInstruction.constantIndex);
        clazz.constantPoolEntryAccept(constantInstruction.constantIndex, this.parameterlessConstructorMarker);
    }

    public void markAsUsed(VisitorAccepter visitorAccepter) {
        this.usageMarker.markAsUsed(visitorAccepter);
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass) {
        return this.shouldBeMarkedAsUsed((VisitorAccepter)programClass);
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass, ProgramMember programMember) {
        return this.shouldBeMarkedAsUsed(programMember);
    }

    public boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        return !this.isUsed(visitorAccepter);
    }

    public boolean isUsed(VisitorAccepter visitorAccepter) {
        return this.usageMarker.isUsed(visitorAccepter);
    }

    public void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        this.usageMarker.markAsPossiblyUsed(visitorAccepter);
    }

    public boolean shouldBeMarkedAsPossiblyUsed(ProgramClass programClass, ProgramMember programMember) {
        return this.shouldBeMarkedAsPossiblyUsed(programMember);
    }

    public boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        return !this.isUsed(visitorAccepter) && !this.isPossiblyUsed(visitorAccepter);
    }

    public boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        return this.usageMarker.isPossiblyUsed(visitorAccepter);
    }

    public void markAsUnused(VisitorAccepter visitorAccepter) {
        this.usageMarker.markAsUnused(visitorAccepter);
    }

    private void markConstants(Clazz clazz, int[] constantIndices, int constantIndicesCount) {
        for (int index = 0; index < constantIndicesCount; ++index) {
            this.markConstant(clazz, constantIndices[index]);
        }
    }

    private void markOptionalConstant(Clazz clazz, int constantIndex) {
        if (constantIndex != 0) {
            this.markConstant(clazz, constantIndex);
        }
    }

    private void markConstant(Clazz clazz, int constantIndex) {
        clazz.constantPoolEntryAccept(constantIndex, this);
    }

    private class MyBootStrapMethodUsageMarker
    extends SimplifiedVisitor
    implements AttributeVisitor,
    BootstrapMethodInfoVisitor {
        private int bootstrapMethodIndex;

        private MyBootStrapMethodUsageMarker(int bootstrapMethodIndex) {
            this.bootstrapMethodIndex = bootstrapMethodIndex;
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitBootstrapMethodsAttribute(Clazz clazz, BootstrapMethodsAttribute bootstrapMethodsAttribute) {
            if (ClassUsageMarker.this.shouldBeMarkedAsUsed(bootstrapMethodsAttribute)) {
                ClassUsageMarker.this.markAsUsed(bootstrapMethodsAttribute);
                ClassUsageMarker.this.markConstant(clazz, bootstrapMethodsAttribute.u2attributeNameIndex);
            }
            bootstrapMethodsAttribute.bootstrapMethodEntryAccept(clazz, this.bootstrapMethodIndex, this);
        }

        @Override
        public void visitBootstrapMethodInfo(Clazz clazz, BootstrapMethodInfo bootstrapMethodInfo) {
            ClassUsageMarker.this.markAsUsed(bootstrapMethodInfo);
            ClassUsageMarker.this.markConstant(clazz, bootstrapMethodInfo.u2methodHandleIndex);
            bootstrapMethodInfo.methodArgumentsAccept(clazz, ClassUsageMarker.this);
        }
    }

    private class MyNonEmptyMethodUsageMarker
    extends SimplifiedVisitor
    implements AttributeVisitor {
        private MyNonEmptyMethodUsageMarker() {
        }

        @Override
        public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
        }

        @Override
        public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
            if (codeAttribute.u4codeLength > 1) {
                method.accept(clazz, ClassUsageMarker.this);
            }
        }
    }

    private class MyPossiblyUsedMemberUsageMarker
    extends SimplifiedVisitor
    implements MemberVisitor {
        private MyPossiblyUsedMemberUsageMarker() {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            if (ClassUsageMarker.this.isPossiblyUsed(programField)) {
                ClassUsageMarker.this.markAsUsed(programField);
                ClassUsageMarker.this.markConstant(programClass, programField.u2nameIndex);
                ClassUsageMarker.this.markConstant(programClass, programField.u2descriptorIndex);
                programField.attributesAccept(programClass, ClassUsageMarker.this);
                programField.referencedClassesAccept(ClassUsageMarker.this);
            }
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if (ClassUsageMarker.this.isPossiblyUsed(programMethod)) {
                ClassUsageMarker.this.markAsUsed(programMethod);
                ClassUsageMarker.this.markProgramMethodBody(programClass, programMethod);
            }
        }
    }

    private class MyDefaultMethodUsageMarker
    extends SimplifiedVisitor
    implements MemberVisitor {
        private MyDefaultMethodUsageMarker() {
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            if (ClassUsageMarker.this.shouldBeMarkedAsUsed(programMethod)) {
                ClassUsageMarker.this.markAsUsed(programMethod);
                ClassUsageMarker.this.markProgramMethodBody(programClass, programMethod);
            }
        }
    }

    private class MyInterfaceUsageMarker
    implements ClassVisitor {
        private MyInterfaceUsageMarker() {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            if (ClassUsageMarker.this.shouldBeMarkedAsPossiblyUsed(programClass)) {
                ClassUsageMarker.this.markAsPossiblyUsed(programClass);
            }
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
            ClassUsageMarker.this.visitLibraryClass(libraryClass);
        }
    }
}

