/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;

public class InterfaceUsageMarker
extends SimplifiedVisitor
implements ClassVisitor,
ConstantVisitor {
    private final ClassUsageMarker usageMarker;
    private boolean used;
    private boolean anyUsed;

    public InterfaceUsageMarker(ClassUsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        boolean classUsed = this.usageMarker.isUsed(programClass);
        boolean classPossiblyUsed = this.usageMarker.isPossiblyUsed(programClass);
        if (classUsed || classPossiblyUsed) {
            boolean oldAnyUsed = this.anyUsed;
            this.anyUsed = false;
            programClass.interfaceConstantsAccept(this);
            classUsed |= this.anyUsed;
            this.anyUsed = oldAnyUsed;
            if (classPossiblyUsed) {
                if (classUsed) {
                    this.usageMarker.markAsUsed(programClass);
                    programClass.thisClassConstantAccept(this);
                    programClass.superClassConstantAccept(this);
                } else {
                    this.usageMarker.markAsUnused(programClass);
                }
            }
        }
        this.used = classUsed;
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.used = true;
        this.anyUsed = true;
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        boolean classUsed = this.usageMarker.isUsed(classConstant);
        if (!classUsed) {
            classConstant.referencedClassAccept(this);
            classUsed = this.used;
            if (classUsed) {
                this.usageMarker.markAsUsed(classConstant);
                clazz.constantPoolEntryAccept(classConstant.u2nameIndex, this);
            }
        }
        this.used = classUsed;
        this.anyUsed |= classUsed;
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        if (!this.usageMarker.isUsed(utf8Constant)) {
            this.usageMarker.markAsUsed(utf8Constant);
        }
    }
}

