/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.visitors.AllTypeVisitor;
import proguard.classfile.kotlin.visitors.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitors.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinVersionRequirementVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.MemberAccessFlagCleaner;
import proguard.classfile.visitor.MemberAccessSetter;
import proguard.classfile.visitor.MultiMemberVisitor;
import proguard.shrink.SimpleUsageMarker;

public class KotlinShrinker
extends SimplifiedVisitor
implements KotlinMetadataVisitor,
KotlinPropertyVisitor,
KotlinFunctionVisitor,
KotlinTypeAliasVisitor,
KotlinTypeVisitor,
KotlinConstructorVisitor,
KotlinTypeParameterVisitor,
KotlinValueParameterVisitor,
KotlinVersionRequirementVisitor {
    private final SimpleUsageMarker usageMarker;

    KotlinShrinker(SimpleUsageMarker usageMarker) {
        this.usageMarker = usageMarker;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.properties);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.functions);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.typeAliases);
        this.shrinkMetadataArray(kotlinDeclarationContainerMetadata.localDelegatedProperties);
        kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
        kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
        kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        if (this.shouldShrinkMetadata(kotlinClassKindMetadata.companionObjectName, kotlinClassKindMetadata.referencedCompanionClass)) {
            kotlinClassKindMetadata.companionObjectName = null;
            kotlinClassKindMetadata.referencedCompanionClass = null;
        }
        this.shrinkMetadataArray(kotlinClassKindMetadata.constructors);
        this.shrinkArray(kotlinClassKindMetadata.enumEntryNames, kotlinClassKindMetadata.referencedEnumEntries);
        this.shrinkArray(kotlinClassKindMetadata.nestedClassNames, kotlinClassKindMetadata.referencedNestedClasses);
        this.shrinkArray(kotlinClassKindMetadata.sealedSubclassNames, kotlinClassKindMetadata.referencedSealedSubClasses);
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
        kotlinClassKindMetadata.superTypesAccept(clazz, this);
        kotlinClassKindMetadata.typeParametersAccept(clazz, this);
        kotlinClassKindMetadata.versionRequirementAccept(clazz, this);
        kotlinClassKindMetadata.constructorsAccept(clazz, this);
    }

    @Override
    public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        this.shrinkMetadataArray(kotlinSyntheticClassKindMetadata.functions);
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
    }

    @Override
    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
        this.shrinkArray(kotlinMultiFileFacadeKindMetadata.partClassNames, kotlinMultiFileFacadeKindMetadata.referencedPartClasses);
    }

    @Override
    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.backingFieldSignature, kotlinPropertyMetadata.referencedBackingField)) {
            kotlinPropertyMetadata.backingFieldSignature = null;
            kotlinPropertyMetadata.referencedBackingField = null;
        }
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.getterSignature, kotlinPropertyMetadata.referencedGetterMethod)) {
            kotlinPropertyMetadata.getterSignature = null;
            kotlinPropertyMetadata.referencedGetterMethod = null;
            kotlinPropertyMetadata.flags.hasGetter = false;
        }
        if (this.shouldShrinkMetadata(kotlinPropertyMetadata.setterSignature, kotlinPropertyMetadata.referencedSetterMethod)) {
            kotlinPropertyMetadata.setterSignature = null;
            kotlinPropertyMetadata.referencedSetterMethod = null;
            kotlinPropertyMetadata.flags.hasSetter = false;
            kotlinPropertyMetadata.setterParameters.clear();
        }
        kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        if (kotlinPropertyMetadata.syntheticMethodForAnnotations != null && !this.usageMarker.isUsed(kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations)) {
            kotlinPropertyMetadata.syntheticMethodForAnnotations = null;
            kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations = null;
            kotlinPropertyMetadata.referencedSyntheticMethodClass = null;
            kotlinPropertyMetadata.flags.common.hasAnnotations = false;
        }
        if (kotlinPropertyMetadata.referencedBackingField != null && kotlinPropertyMetadata.getterSignature == null && kotlinPropertyMetadata.setterSignature == null && (kotlinPropertyMetadata.referencedBackingField.getAccessFlags() & 2) != 0 && !kotlinPropertyMetadata.flags.visibility.isPrivate) {
            int visibility = kotlinPropertyMetadata.flags.visibility.isProtected ? 4 : 1;
            kotlinPropertyMetadata.referencedBackingField.accept(kotlinPropertyMetadata.referencedBackingFieldClass, new MultiMemberVisitor(new MemberAccessFlagCleaner(2), new MemberAccessSetter(visibility)));
        }
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        if (kotlinFunctionMetadata.referencedLambdaClassOrigin != null && this.shouldShrinkMetadata(kotlinFunctionMetadata.lambdaClassOriginName, kotlinFunctionMetadata.referencedLambdaClassOrigin)) {
            kotlinFunctionMetadata.lambdaClassOriginName = null;
            kotlinFunctionMetadata.referencedLambdaClassOrigin = null;
        }
        kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
        kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, new AllTypeVisitor(this));
        if (kotlinFunctionMetadata.referencedDefaultMethod != null && !this.usageMarker.isUsed(kotlinFunctionMetadata.referencedDefaultMethod)) {
            kotlinFunctionMetadata.referencedDefaultMethod = null;
            kotlinFunctionMetadata.referencedDefaultMethodClass = null;
        }
        if (kotlinFunctionMetadata.referencedDefaultImplementationMethod != null && !this.usageMarker.isUsed(kotlinFunctionMetadata.referencedDefaultImplementationMethod)) {
            kotlinFunctionMetadata.referencedDefaultImplementationMethod = null;
            kotlinFunctionMetadata.referencedDefaultImplementationMethodClass = null;
        }
        if (!kotlinFunctionMetadata.flags.modality.isAbstract && kotlinMetadata.k == 1 && ((KotlinClassKindMetadata)kotlinMetadata).flags.isInterface && kotlinFunctionMetadata.referencedDefaultImplementationMethod == null) {
            kotlinFunctionMetadata.flags.modality.isAbstract = true;
        }
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
        kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, this);
    }

    @Override
    public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
        kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        this.shrinkMetadataArray(kotlinTypeAliasMetadata.annotations);
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
        kotlinTypeMetadata.upperBoundsAccept(clazz, this);
        kotlinTypeMetadata.abbreviationAccept(clazz, this);
        this.shrinkMetadataArray(kotlinTypeMetadata.annotations);
    }

    @Override
    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
        this.shrinkMetadataArray(kotlinTypeParameterMetadata.annotations);
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
    }

    @Override
    public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        if (kotlinValueParameterMetadata.flags.hasDefaultValue && !this.usageMarker.isUsed(kotlinFunctionMetadata.referencedDefaultMethod)) {
            kotlinValueParameterMetadata.flags.hasDefaultValue = false;
        }
    }

    @Override
    public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
    }

    @Override
    public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
    }

    @Override
    public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
    }

    private boolean shouldShrinkMetadata(Object metadataElement, VisitorAccepter jvmElement) {
        return metadataElement != null && !this.usageMarker.isUsed(jvmElement);
    }

    private void shrinkArray(List<?> elements, List<? extends VisitorAccepter> referencedJavaElements) {
        for (int k = elements.size() - 1; k >= 0; --k) {
            if (this.usageMarker.isUsed(referencedJavaElements.get(k))) continue;
            elements.remove(k);
            referencedJavaElements.remove(k);
        }
    }

    private void shrinkMetadataArray(List<? extends VisitorAccepter> elements) {
        for (int k = elements.size() - 1; k >= 0; --k) {
            if (this.usageMarker.isUsed(elements.get(k))) continue;
            elements.remove(k);
        }
    }
}

