/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.util.List;
import proguard.classfile.Clazz;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.kotlin.KotlinClassKindMetadata;
import proguard.classfile.kotlin.KotlinConstructorMetadata;
import proguard.classfile.kotlin.KotlinContractMetadata;
import proguard.classfile.kotlin.KotlinDeclarationContainerMetadata;
import proguard.classfile.kotlin.KotlinEffectExpressionMetadata;
import proguard.classfile.kotlin.KotlinEffectMetadata;
import proguard.classfile.kotlin.KotlinFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinFunctionMetadata;
import proguard.classfile.kotlin.KotlinMetadata;
import proguard.classfile.kotlin.KotlinMetadataAnnotation;
import proguard.classfile.kotlin.KotlinMultiFileFacadeKindMetadata;
import proguard.classfile.kotlin.KotlinMultiFilePartKindMetadata;
import proguard.classfile.kotlin.KotlinPropertyMetadata;
import proguard.classfile.kotlin.KotlinSyntheticClassKindMetadata;
import proguard.classfile.kotlin.KotlinTypeAliasMetadata;
import proguard.classfile.kotlin.KotlinTypeMetadata;
import proguard.classfile.kotlin.KotlinTypeParameterMetadata;
import proguard.classfile.kotlin.KotlinValueParameterMetadata;
import proguard.classfile.kotlin.KotlinVersionRequirementMetadata;
import proguard.classfile.kotlin.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinAnnotationCounter;
import proguard.classfile.kotlin.visitors.KotlinAnnotationVisitor;
import proguard.classfile.kotlin.visitors.KotlinConstructorVisitor;
import proguard.classfile.kotlin.visitors.KotlinContractVisitor;
import proguard.classfile.kotlin.visitors.KotlinEffectExprVisitor;
import proguard.classfile.kotlin.visitors.KotlinEffectVisitor;
import proguard.classfile.kotlin.visitors.KotlinFunctionVisitor;
import proguard.classfile.kotlin.visitors.KotlinMetadataVisitor;
import proguard.classfile.kotlin.visitors.KotlinPropertyVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeAliasVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinTypeVisitor;
import proguard.classfile.kotlin.visitors.KotlinValueParameterVisitor;
import proguard.classfile.kotlin.visitors.KotlinVersionRequirementVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.SimpleUsageMarker;

public class KotlinUsageMarker
extends SimplifiedVisitor
implements KotlinMetadataVisitor,
KotlinPropertyVisitor,
KotlinFunctionVisitor,
KotlinTypeAliasVisitor,
KotlinTypeVisitor,
KotlinConstructorVisitor,
KotlinTypeParameterVisitor,
KotlinValueParameterVisitor,
KotlinVersionRequirementVisitor,
KotlinContractVisitor,
KotlinEffectVisitor,
KotlinEffectExprVisitor,
KotlinAnnotationVisitor {
    private final SimpleUsageMarker javaUsageMarker;
    private final ClassUsageMarker javaClassUsageMarker;

    KotlinUsageMarker(SimpleUsageMarker javaUsageMarker, ClassUsageMarker javaClassUsageMarker) {
        this.javaUsageMarker = javaUsageMarker;
        this.javaClassUsageMarker = javaClassUsageMarker;
    }

    @Override
    public void visitAnyKotlinMetadata(Clazz clazz, KotlinMetadata kotlinMetadata) {
    }

    @Override
    public void visitKotlinDeclarationContainerMetadata(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata) {
        if (!this.isUsed(kotlinDeclarationContainerMetadata) && this.isJavaClassUsed(kotlinDeclarationContainerMetadata.ownerReferencedClass)) {
            this.markAsUsed(kotlinDeclarationContainerMetadata);
        }
        if (this.isUsed(kotlinDeclarationContainerMetadata)) {
            kotlinDeclarationContainerMetadata.propertiesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.functionsAccept(clazz, this);
            kotlinDeclarationContainerMetadata.typeAliasesAccept(clazz, this);
            kotlinDeclarationContainerMetadata.delegatedPropertiesAccept(clazz, this);
        }
    }

    @Override
    public void visitKotlinClassMetadata(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinClassKindMetadata);
        if (this.isUsed(kotlinClassKindMetadata)) {
            this.markAsUsed(kotlinClassKindMetadata.superTypes);
            this.markAsUsed(kotlinClassKindMetadata.typeParameters);
            if (kotlinClassKindMetadata.flags.isAnnotationClass) {
                this.markAsUsed(kotlinClassKindMetadata.constructors);
            } else {
                kotlinClassKindMetadata.constructorsAccept(clazz, this);
            }
            kotlinClassKindMetadata.superTypesAccept(clazz, this);
            kotlinClassKindMetadata.typeParametersAccept(clazz, this);
            kotlinClassKindMetadata.versionRequirementAccept(clazz, this);
        }
    }

    @Override
    public void visitKotlinFileFacadeMetadata(Clazz clazz, KotlinFileFacadeKindMetadata kotlinFileFacadeKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinFileFacadeKindMetadata);
    }

    @Override
    public void visitKotlinSyntheticClassMetadata(Clazz clazz, KotlinSyntheticClassKindMetadata kotlinSyntheticClassKindMetadata) {
        this.markAsUsed(kotlinSyntheticClassKindMetadata);
        kotlinSyntheticClassKindMetadata.functionsAccept(clazz, this);
    }

    @Override
    public void visitKotlinMultiFileFacadeMetadata(Clazz clazz, KotlinMultiFileFacadeKindMetadata kotlinMultiFileFacadeKindMetadata) {
    }

    @Override
    public void visitKotlinMultiFilePartMetadata(Clazz clazz, KotlinMultiFilePartKindMetadata kotlinMultiFilePartKindMetadata) {
        this.visitKotlinDeclarationContainerMetadata(clazz, kotlinMultiFilePartKindMetadata);
        if (this.isUsed(kotlinMultiFilePartKindMetadata) && !this.isJavaClassUsed(kotlinMultiFilePartKindMetadata.referencedFacade)) {
            kotlinMultiFilePartKindMetadata.referencedFacade.accept(this.javaClassUsageMarker);
        }
    }

    @Override
    public void visitAnyProperty(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata) {
        if (!this.isUsed(kotlinPropertyMetadata)) {
            boolean setterUsed;
            boolean backingFieldUsed = kotlinPropertyMetadata.referencedBackingField != null && this.isUsed(kotlinPropertyMetadata.referencedBackingField);
            boolean getterUsed = kotlinPropertyMetadata.referencedGetterMethod != null && this.isUsed(kotlinPropertyMetadata.referencedGetterMethod);
            boolean bl = setterUsed = kotlinPropertyMetadata.referencedSetterMethod != null && this.isUsed(kotlinPropertyMetadata.referencedSetterMethod);
            if (backingFieldUsed || getterUsed || setterUsed) {
                this.markAsUsed(kotlinPropertyMetadata);
            }
        }
        if (this.isUsed(kotlinPropertyMetadata)) {
            this.markAsUsed(kotlinPropertyMetadata.receiverType);
            this.markAsUsed(kotlinPropertyMetadata.typeParameters);
            this.markAsUsed(kotlinPropertyMetadata.setterParameters);
            this.markAsUsed(kotlinPropertyMetadata.type);
            if (kotlinPropertyMetadata.flags.common.hasAnnotations && kotlinPropertyMetadata.syntheticMethodForAnnotations != null) {
                KotlinAnnotationCounter annotationCounter = new KotlinAnnotationCounter(this.javaUsageMarker);
                kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations.accept(kotlinPropertyMetadata.referencedSyntheticMethodClass, annotationCounter);
                if (annotationCounter.getCount() != 0) {
                    kotlinPropertyMetadata.referencedSyntheticMethodForAnnotations.accept(kotlinPropertyMetadata.referencedSyntheticMethodClass, this.javaClassUsageMarker);
                }
            }
            kotlinPropertyMetadata.receiverTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.setterParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinPropertyMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }
    }

    @Override
    public void visitAnyFunction(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        if (!this.isUsed(kotlinFunctionMetadata) && this.isUsed(kotlinFunctionMetadata.referencedMethod)) {
            this.markAsUsed(kotlinFunctionMetadata);
        }
        if (this.isUsed(kotlinFunctionMetadata)) {
            this.markAsUsed(kotlinFunctionMetadata.receiverType);
            this.markAsUsed(kotlinFunctionMetadata.typeParameters);
            this.markAsUsed(kotlinFunctionMetadata.valueParameters);
            this.markAsUsed(kotlinFunctionMetadata.returnType);
            this.markAsUsed(kotlinFunctionMetadata.contracts);
            if (kotlinFunctionMetadata.referencedDefaultMethod != null && (kotlinFunctionMetadata.referencedMethod.getProcessingFlags() & 0x100000) != 0 && !this.javaUsageMarker.isUsed(kotlinFunctionMetadata.referencedDefaultMethod)) {
                kotlinFunctionMetadata.referencedDefaultMethod.accept(kotlinFunctionMetadata.referencedDefaultMethodClass, this.javaClassUsageMarker);
            }
            kotlinFunctionMetadata.receiverTypeAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.typeParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.valueParametersAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.returnTypeAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.contractsAccept(clazz, kotlinMetadata, this);
            kotlinFunctionMetadata.versionRequirementAccept(clazz, kotlinMetadata, this);
        }
    }

    @Override
    public void visitFunction(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinFunctionMetadata kotlinFunctionMetadata) {
        this.visitAnyFunction(clazz, kotlinDeclarationContainerMetadata, kotlinFunctionMetadata);
        if (this.isUsed(kotlinFunctionMetadata) && kotlinDeclarationContainerMetadata.k == 1 && ((KotlinClassKindMetadata)kotlinDeclarationContainerMetadata).flags.isInterface && !kotlinFunctionMetadata.flags.modality.isAbstract && (kotlinFunctionMetadata.referencedMethod.getProcessingFlags() & 0x100000) != 0) {
            if (!this.isJavaClassUsed(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass)) {
                kotlinFunctionMetadata.referencedDefaultImplementationMethodClass.accept(this.javaClassUsageMarker);
            }
            kotlinFunctionMetadata.referencedDefaultImplementationMethod.accept(kotlinFunctionMetadata.referencedDefaultImplementationMethodClass, this.javaClassUsageMarker);
        }
    }

    @Override
    public void visitTypeAlias(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinTypeAliasMetadata kotlinTypeAliasMetadata) {
        if (!this.isUsed(kotlinTypeAliasMetadata)) {
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            if (this.isUsed(kotlinTypeAliasMetadata.expandedType)) {
                this.markAsUsed(kotlinTypeAliasMetadata);
            }
        }
        if (this.isUsed(kotlinTypeAliasMetadata)) {
            if (!this.isJavaClassUsed(clazz)) {
                clazz.accept(this.javaClassUsageMarker);
                clazz.accept(new ReferencedKotlinMetadataVisitor(this));
            }
            this.markAsUsed(kotlinTypeAliasMetadata.typeParameters);
            this.markAsUsed(kotlinTypeAliasMetadata.underlyingType);
            this.markAsUsed(kotlinTypeAliasMetadata.expandedType);
            kotlinTypeAliasMetadata.typeParametersAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.underlyingTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.expandedTypeAccept(clazz, kotlinDeclarationContainerMetadata, this);
            kotlinTypeAliasMetadata.versionRequirementAccept(clazz, kotlinDeclarationContainerMetadata, this);
        }
    }

    @Override
    public void visitAnyType(Clazz clazz, KotlinTypeMetadata kotlinTypeMetadata) {
        if (!this.isUsed(kotlinTypeMetadata)) {
            if (kotlinTypeMetadata.className != null) {
                if (this.isJavaClassUsed(kotlinTypeMetadata.referencedClass)) {
                    this.markAsUsed(kotlinTypeMetadata);
                }
            } else if (kotlinTypeMetadata.aliasName != null) {
                kotlinTypeMetadata.referencedTypeAlias.accept(kotlinTypeMetadata.referencedTypeAlias.referencedDeclarationContainer.ownerReferencedClass, kotlinTypeMetadata.referencedTypeAlias.referencedDeclarationContainer, this);
                if (this.isUsed(kotlinTypeMetadata.referencedTypeAlias)) {
                    this.markAsUsed(kotlinTypeMetadata);
                }
            } else {
                this.markAsUsed(kotlinTypeMetadata);
            }
        }
        if (this.isUsed(kotlinTypeMetadata)) {
            if (kotlinTypeMetadata.className != null && !this.isJavaClassUsed(kotlinTypeMetadata.referencedClass)) {
                kotlinTypeMetadata.referencedClass.accept(this.javaClassUsageMarker);
            } else if (kotlinTypeMetadata.aliasName != null && !this.isUsed(kotlinTypeMetadata.referencedTypeAlias)) {
                this.markAsUsed(kotlinTypeMetadata.referencedTypeAlias);
                kotlinTypeMetadata.referencedTypeAlias.accept(kotlinTypeMetadata.referencedTypeAlias.referencedDeclarationContainer.ownerReferencedClass, kotlinTypeMetadata.referencedTypeAlias.referencedDeclarationContainer, this);
            }
            this.markAsUsed(kotlinTypeMetadata.typeArguments);
            this.markAsUsed(kotlinTypeMetadata.upperBounds);
            this.markAsUsed(kotlinTypeMetadata.outerClassType);
            kotlinTypeMetadata.typeArgumentsAccept(clazz, this);
            kotlinTypeMetadata.upperBoundsAccept(clazz, this);
            kotlinTypeMetadata.abbreviationAccept(clazz, this);
            kotlinTypeMetadata.annotationsAccept(clazz, this);
        }
    }

    @Override
    public void visitConstructor(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata) {
        if (!this.isUsed(kotlinConstructorMetadata) && this.isUsed(kotlinConstructorMetadata.referencedMethod)) {
            this.markAsUsed(kotlinConstructorMetadata);
        }
        if (this.isUsed(kotlinConstructorMetadata)) {
            this.markAsUsed(kotlinConstructorMetadata.valueParameters);
            kotlinConstructorMetadata.valueParametersAccept(clazz, kotlinClassKindMetadata, this);
            kotlinConstructorMetadata.versionRequirementAccept(clazz, kotlinClassKindMetadata, this);
        }
    }

    @Override
    public void visitAnyTypeParameter(Clazz clazz, KotlinTypeParameterMetadata kotlinTypeParameterMetadata) {
        if (this.isUsed(kotlinTypeParameterMetadata)) {
            this.markAsUsed(kotlinTypeParameterMetadata.upperBounds);
            kotlinTypeParameterMetadata.upperBoundsAccept(clazz, this);
            kotlinTypeParameterMetadata.annotationsAccept(clazz, this);
        }
    }

    @Override
    public void visitAnyValueParameter(Clazz clazz, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
    }

    @Override
    public void visitFunctionValParameter(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        if (this.isUsed(kotlinValueParameterMetadata)) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, (KotlinTypeVisitor)this);
        }
    }

    @Override
    public void visitConstructorValParameter(Clazz clazz, KotlinClassKindMetadata kotlinClassKindMetadata, KotlinConstructorMetadata kotlinConstructorMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        if (this.isUsed(kotlinValueParameterMetadata)) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinClassKindMetadata, kotlinConstructorMetadata, (KotlinTypeVisitor)this);
        }
    }

    @Override
    public void visitPropertyValParameter(Clazz clazz, KotlinDeclarationContainerMetadata kotlinDeclarationContainerMetadata, KotlinPropertyMetadata kotlinPropertyMetadata, KotlinValueParameterMetadata kotlinValueParameterMetadata) {
        if (this.isUsed(kotlinValueParameterMetadata)) {
            kotlinValueParameterMetadata.typeAccept(clazz, kotlinDeclarationContainerMetadata, kotlinPropertyMetadata, (KotlinTypeVisitor)this);
        }
    }

    @Override
    public void visitAnyVersionRequirement(Clazz clazz, KotlinVersionRequirementMetadata kotlinVersionRequirementMetadata) {
        this.markAsUsed(kotlinVersionRequirementMetadata);
    }

    @Override
    public void visitAnyAnnotation(Clazz clazz, KotlinMetadataAnnotation annotation) {
        if (!this.isUsed(annotation) && this.isJavaClassUsed(annotation.referencedAnnotationClass)) {
            this.markAsUsed(annotation);
        }
    }

    @Override
    public void visitContract(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata) {
        if (this.isUsed(kotlinContractMetadata)) {
            this.markAsUsed(kotlinContractMetadata.effects);
            kotlinContractMetadata.effectsAccept(clazz, kotlinMetadata, kotlinFunctionMetadata, this);
        }
    }

    @Override
    public void visitEffect(Clazz clazz, KotlinMetadata kotlinMetadata, KotlinFunctionMetadata kotlinFunctionMetadata, KotlinContractMetadata kotlinContractMetadata, KotlinEffectMetadata kotlinEffectMetadata) {
        if (this.isUsed(kotlinEffectMetadata)) {
            this.markAsUsed(kotlinEffectMetadata.constructorArguments);
            this.markAsUsed(kotlinEffectMetadata.conclusionOfConditionalEffect);
            kotlinEffectMetadata.constructorArgumentAccept(clazz, this);
            kotlinEffectMetadata.conclusionOfConditionalEffectAccept(clazz, this);
        }
    }

    @Override
    public void visitAnyEffectExpression(Clazz clazz, KotlinEffectMetadata kotlinEffectMetadata, KotlinEffectExpressionMetadata kotlinEffectExpressionMetadata) {
        if (!this.isUsed(kotlinEffectExpressionMetadata)) {
            this.markAsUsed(kotlinEffectExpressionMetadata.typeOfIs);
            this.markAsUsed(kotlinEffectExpressionMetadata.orRightHandSides);
            this.markAsUsed(kotlinEffectExpressionMetadata.andRightHandSides);
            kotlinEffectExpressionMetadata.typeOfIsAccept(clazz, this);
            kotlinEffectExpressionMetadata.orRightHandSideAccept(clazz, kotlinEffectMetadata, this);
            kotlinEffectExpressionMetadata.andRightHandSideAccept(clazz, kotlinEffectMetadata, this);
        }
    }

    private void markAsUsed(VisitorAccepter metadataElement) {
        if (metadataElement != null) {
            this.javaUsageMarker.markAsUsed(metadataElement);
        }
    }

    private boolean isJavaClassUsed(Clazz clazz) {
        return this.isUsed(clazz) || (clazz.getProcessingFlags() & 0x100000) != 0;
    }

    private void markAsUsed(List<? extends VisitorAccepter> metadataElements) {
        metadataElements.forEach(this::markAsUsed);
    }

    public boolean isUsed(VisitorAccepter metadataElement) {
        return this.javaUsageMarker.isUsed(metadataElement);
    }
}

