/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.NestHostAttribute;
import proguard.classfile.attribute.NestMembersAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.Utf8Constant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.ClassUsageMarker;

public class NestUsageMarker
extends SimplifiedVisitor
implements AttributeVisitor,
ConstantVisitor,
ClassVisitor {
    private final ClassUsageMarker classUsageMarker;
    private boolean attributeUsed;
    private boolean classUsed;

    public NestUsageMarker(ClassUsageMarker classUsageMarker) {
        this.classUsageMarker = classUsageMarker;
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitNestHostAttribute(Clazz clazz, NestHostAttribute nestHostAttribute) {
        this.attributeUsed = false;
        clazz.constantPoolEntryAccept(nestHostAttribute.u2hostClassIndex, this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed(nestHostAttribute);
            this.markConstant(clazz, nestHostAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitNestMembersAttribute(Clazz clazz, NestMembersAttribute nestMembersAttribute) {
        this.attributeUsed = false;
        nestMembersAttribute.memberClassConstantsAccept(clazz, this);
        if (this.attributeUsed) {
            this.classUsageMarker.markAsUsed(nestMembersAttribute);
            this.markConstant(clazz, nestMembersAttribute.u2attributeNameIndex);
        }
    }

    @Override
    public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
        this.classUsed = this.classUsageMarker.isUsed(classConstant);
        if (!this.classUsed) {
            this.classUsed = true;
            classConstant.referencedClassAccept(this);
            if (this.classUsed) {
                this.classUsageMarker.markAsUsed(classConstant);
                this.markConstant(clazz, classConstant.u2nameIndex);
            }
        }
        this.attributeUsed |= this.classUsed;
    }

    @Override
    public void visitUtf8Constant(Clazz clazz, Utf8Constant utf8Constant) {
        this.classUsageMarker.markAsUsed(utf8Constant);
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        this.classUsed = this.classUsageMarker.isUsed(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        this.classUsed = true;
    }

    private void markConstant(Clazz clazz, int index) {
        clazz.constantPoolEntryAccept(index, this);
    }
}

