/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryField;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.VisitorAccepter;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.ShortestUsageMark;
import proguard.shrink.SimpleUsageMarker;

public class ShortestUsageMarker
extends SimpleUsageMarker {
    public ShortestUsageMark currentUsageMark;
    private final MyReferenceChecker referenceChecker = new MyReferenceChecker();

    public void setCurrentUsageMark(ShortestUsageMark currentUsageMark) {
        this.currentUsageMark = currentUsageMark;
    }

    @Override
    public void markAsUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        ShortestUsageMark shortestUsageMark = visitorInfo instanceof ShortestUsageMark && !((ShortestUsageMark)visitorInfo).isCertain() && !this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) ? new ShortestUsageMark((ShortestUsageMark)visitorInfo, true) : this.currentUsageMark;
        visitorAccepter.setVisitorInfo(shortestUsageMark);
    }

    @Override
    public boolean isUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo != null && visitorInfo instanceof ShortestUsageMark && ((ShortestUsageMark)visitorInfo).isCertain();
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass) {
        Object visitorInfo = programClass.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)visitorInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) && !this.referencesClassMember(this.currentUsageMark, programClass);
    }

    public boolean shouldBeMarkedAsUsed(ProgramClass programClass, ProgramMember programMember) {
        Object visitorInfo = programMember.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)visitorInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) && !this.referencesClass(this.currentUsageMark, programClass);
    }

    public boolean shouldBeMarkedAsUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || !((ShortestUsageMark)visitorInfo).isCertain() || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo);
    }

    @Override
    public void markAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        visitorAccepter.setVisitorInfo(new ShortestUsageMark(this.currentUsageMark, false));
    }

    public boolean shouldBeMarkedAsPossiblyUsed(ProgramClass programClass, ProgramMember programMember) {
        Object visitorInfo = programMember.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) && !((ShortestUsageMark)visitorInfo).isCertain() && !this.referencesClass(this.currentUsageMark, programClass);
    }

    public boolean shouldBeMarkedAsPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo == null || !(visitorInfo instanceof ShortestUsageMark) || this.currentUsageMark.isShorter((ShortestUsageMark)visitorInfo) && !((ShortestUsageMark)visitorInfo).isCertain();
    }

    @Override
    public boolean isPossiblyUsed(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return visitorInfo != null && visitorInfo instanceof ShortestUsageMark && !((ShortestUsageMark)visitorInfo).isCertain();
    }

    protected ShortestUsageMark getShortestUsageMark(VisitorAccepter visitorAccepter) {
        Object visitorInfo = visitorAccepter.getVisitorInfo();
        return (ShortestUsageMark)visitorInfo;
    }

    private boolean referencesClass(ShortestUsageMark shortestUsageMark, Clazz clazz) {
        return this.referenceChecker.referencesClass(shortestUsageMark, clazz);
    }

    private boolean referencesClassMember(ShortestUsageMark shortestUsageMark, Clazz clazz) {
        return this.referenceChecker.referencesClassMember(shortestUsageMark, clazz);
    }

    private class MyReferenceChecker
    extends SimplifiedVisitor
    implements ClassVisitor,
    MemberVisitor {
        private Clazz checkClass;
        private boolean checkMember;
        private boolean isReferencing;

        private MyReferenceChecker() {
        }

        public boolean referencesClass(ShortestUsageMark shortestUsageMark, Clazz clazz) {
            this.checkClass = clazz;
            this.checkMember = false;
            this.isReferencing = false;
            this.checkReferenceFrom(shortestUsageMark);
            return this.isReferencing;
        }

        public boolean referencesClassMember(ShortestUsageMark shortestUsageMark, Clazz clazz) {
            this.checkClass = clazz;
            this.checkMember = true;
            this.isReferencing = false;
            this.checkReferenceFrom(shortestUsageMark);
            return this.isReferencing;
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            this.checkReferenceFrom(programClass);
        }

        @Override
        public void visitLibraryField(LibraryClass libraryClass, LibraryField libraryField) {
        }

        @Override
        public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        }

        @Override
        public void visitProgramField(ProgramClass programClass, ProgramField programField) {
            this.checkReferenceFrom(programField);
        }

        @Override
        public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
            this.checkReferenceFrom(programMethod);
        }

        private void checkReferenceFrom(VisitorAccepter visitorAccepter) {
            if (!this.isReferencing) {
                this.checkReferenceFrom(ShortestUsageMarker.this.getShortestUsageMark(visitorAccepter));
            }
        }

        private void checkReferenceFrom(ShortestUsageMark shortestUsageMark) {
            this.isReferencing = this.checkMember ? shortestUsageMark.isCausedByMember(this.checkClass) : shortestUsageMark.isCausedBy(this.checkClass);
            shortestUsageMark.acceptClassVisitor(this);
            shortestUsageMark.acceptMemberVisitor(this);
        }
    }
}

