/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.IOException;
import java.io.PrintWriter;
import proguard.ClassSpecificationVisitorFactory;
import proguard.Configuration;
import proguard.classfile.ClassPool;
import proguard.classfile.kotlin.ReferencedKotlinMetadataVisitor;
import proguard.classfile.kotlin.asserter.KotlinMetadataAsserter;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassCleaner;
import proguard.classfile.visitor.ClassCounter;
import proguard.classfile.visitor.ClassPoolFiller;
import proguard.classfile.visitor.ClassPoolVisitor;
import proguard.classfile.visitor.ClassProcessingFlagFilter;
import proguard.classfile.visitor.MultiClassVisitor;
import proguard.shrink.ClassShrinker;
import proguard.shrink.ClassUsageMarker;
import proguard.shrink.KotlinShrinker;
import proguard.shrink.ShortestClassUsageMarker;
import proguard.shrink.ShortestUsageMarker;
import proguard.shrink.ShortestUsagePrinter;
import proguard.shrink.SimpleUsageMarker;
import proguard.shrink.UsageMarker;
import proguard.shrink.UsagePrinter;
import proguard.shrink.UsedClassFilter;
import proguard.util.PrintWriterUtil;

public class Shrinker {
    private final Configuration configuration;

    public Shrinker(Configuration configuration) {
        this.configuration = configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPool execute(ClassPool programClassPool, ClassPool libraryClassPool) throws IOException {
        if (this.configuration.keep == null) {
            throw new IOException("You have to specify '-keep' options for the shrinking step.");
        }
        PrintWriter out = new PrintWriter(System.out, true);
        programClassPool.classesAccept(new ClassCleaner());
        libraryClassPool.classesAccept(new ClassCleaner());
        SimpleUsageMarker simpleUsageMarker = this.configuration.whyAreYouKeeping == null ? new SimpleUsageMarker() : new ShortestUsageMarker();
        ClassUsageMarker classUsageMarker = this.configuration.whyAreYouKeeping == null ? new ClassUsageMarker(simpleUsageMarker) : new ShortestClassUsageMarker((ShortestUsageMarker)simpleUsageMarker, "is kept by a directive in the configuration.\n\n");
        new UsageMarker(this.configuration).mark(programClassPool, libraryClassPool, simpleUsageMarker, classUsageMarker);
        if (this.configuration.whyAreYouKeeping != null) {
            out.println();
            ShortestUsagePrinter shortestUsagePrinter = new ShortestUsagePrinter((ShortestUsageMarker)classUsageMarker.getUsageMarker(), this.configuration.verbose, out);
            ClassPoolVisitor whyClassPoolvisitor = new ClassSpecificationVisitorFactory().createClassPoolVisitor(this.configuration.whyAreYouKeeping, shortestUsagePrinter, shortestUsagePrinter);
            programClassPool.accept(whyClassPoolvisitor);
            libraryClassPool.accept(whyClassPoolvisitor);
        }
        if (this.configuration.printUsage != null) {
            PrintWriter usageWriter = PrintWriterUtil.createPrintWriterOut(this.configuration.printUsage);
            try {
                programClassPool.classesAcceptAlphabetically(new UsagePrinter(simpleUsageMarker, true, usageWriter));
            }
            finally {
                PrintWriterUtil.closePrintWriter(this.configuration.printUsage, usageWriter);
            }
        }
        ClassPool newProgramClassPool = new ClassPool();
        programClassPool.classesAccept(new UsedClassFilter(simpleUsageMarker, new MultiClassVisitor(new ClassShrinker(simpleUsageMarker), new ClassPoolFiller(newProgramClassPool))));
        libraryClassPool.classesAccept(new UsedClassFilter(simpleUsageMarker, new ClassShrinker(simpleUsageMarker)));
        if (this.configuration.adaptKotlinMetadata) {
            newProgramClassPool.classesAccept(new ReferencedKotlinMetadataVisitor(new KotlinShrinker(simpleUsageMarker)));
            if (this.configuration.enableKotlinAsserter) {
                WarningPrinter warningPrinter = new WarningPrinter(new PrintWriter(System.err, true));
                ReferencedKotlinMetadataVisitor kotlinAsserter = new ReferencedKotlinMetadataVisitor(new KotlinMetadataAsserter(programClassPool, libraryClassPool, warningPrinter));
                programClassPool.classesAccept(kotlinAsserter);
                libraryClassPool.classesAccept(kotlinAsserter);
            }
        }
        int newProgramClassPoolSize = newProgramClassPool.size();
        if (this.configuration.verbose) {
            ClassCounter originalClassCounter = new ClassCounter();
            programClassPool.classesAccept(new ClassProcessingFlagFilter(0, 512, originalClassCounter));
            ClassCounter newClassCounter = new ClassCounter();
            newProgramClassPool.classesAccept(new ClassProcessingFlagFilter(0, 512, newClassCounter));
            out.println("Removing unused program classes and class elements...");
            out.println("  Original number of program classes:            " + originalClassCounter.getCount());
            out.println("  Final number of program classes:               " + newClassCounter.getCount());
            if (newClassCounter.getCount() != newProgramClassPoolSize) {
                out.println("  Final number of program and injected classes:  " + newProgramClassPoolSize);
            }
        }
        if (!(newProgramClassPoolSize != 0 || this.configuration.warn != null && this.configuration.warn.isEmpty())) {
            if (this.configuration.ignoreWarnings) {
                System.err.println("Warning: the output jar is empty. Did you specify the proper '-keep' options?");
            } else {
                throw new IOException("The output jar is empty. Did you specify the proper '-keep' options?");
            }
        }
        return newProgramClassPool;
    }
}

