/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import java.io.PrintWriter;
import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramField;
import proguard.classfile.ProgramMethod;
import proguard.classfile.attribute.Attribute;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.attribute.LineNumberTableAttribute;
import proguard.classfile.attribute.visitor.AttributeVisitor;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberVisitor;
import proguard.shrink.SimpleUsageMarker;

public class UsagePrinter
extends SimplifiedVisitor
implements ClassVisitor,
MemberVisitor,
AttributeVisitor {
    private final SimpleUsageMarker usageMarker;
    private final boolean printUnusedItems;
    private final PrintWriter pw;
    private String className;

    public UsagePrinter(SimpleUsageMarker usageMarker, boolean printUnusedItems, PrintWriter printWriter) {
        this.usageMarker = usageMarker;
        this.printUnusedItems = printUnusedItems;
        this.pw = printWriter;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        if (this.usageMarker.isUsed(programClass)) {
            if (this.printUnusedItems) {
                this.className = programClass.getName();
                programClass.fieldsAccept(this);
                programClass.methodsAccept(this);
                this.className = null;
            } else {
                this.pw.println(ClassUtil.externalClassName(programClass.getName()));
            }
        } else if (this.printUnusedItems) {
            this.pw.println(ClassUtil.externalClassName(programClass.getName()));
        }
    }

    @Override
    public void visitProgramField(ProgramClass programClass, ProgramField programField) {
        if (this.usageMarker.isUsed(programField) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.pw.println("    " + ClassUtil.externalFullFieldDescription(programField.getAccessFlags(), programField.getName(programClass), programField.getDescriptor(programClass)));
        }
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        if (this.usageMarker.isUsed(programMethod) ^ this.printUnusedItems) {
            this.printClassNameHeader();
            this.pw.print("    ");
            programMethod.attributesAccept(programClass, this);
            this.pw.println(ClassUtil.externalFullMethodDescription(programClass.getName(), programMethod.getAccessFlags(), programMethod.getName(programClass), programMethod.getDescriptor(programClass)));
        }
    }

    @Override
    public void visitAnyAttribute(Clazz clazz, Attribute attribute) {
    }

    @Override
    public void visitCodeAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute) {
        codeAttribute.attributesAccept(clazz, method, this);
    }

    @Override
    public void visitLineNumberTableAttribute(Clazz clazz, Method method, CodeAttribute codeAttribute, LineNumberTableAttribute lineNumberTableAttribute) {
        this.pw.print(lineNumberTableAttribute.getLowestLineNumber() + ":" + lineNumberTableAttribute.getHighestLineNumber() + ":");
    }

    private void printClassNameHeader() {
        if (this.className != null) {
            this.pw.println(ClassUtil.externalClassName(this.className) + ":");
            this.className = null;
        }
    }
}

