/*
 * Decompiled with CFR 0.152.
 */
package proguard.shrink;

import proguard.classfile.LibraryClass;
import proguard.classfile.ProgramClass;
import proguard.classfile.visitor.ClassVisitor;
import proguard.shrink.SimpleUsageMarker;

public class UsedClassFilter
implements ClassVisitor {
    private final SimpleUsageMarker simpleUsageMarker;
    private final ClassVisitor usedClassVisitor;
    private final ClassVisitor unusedClassVisitor;

    public UsedClassFilter(SimpleUsageMarker simpleUsageMarker, ClassVisitor usedClassVisitor) {
        this(simpleUsageMarker, usedClassVisitor, null);
    }

    public UsedClassFilter(SimpleUsageMarker simpleUsageMarker, ClassVisitor usedClassVisitor, ClassVisitor unusedClassVisitor) {
        this.simpleUsageMarker = simpleUsageMarker;
        this.usedClassVisitor = usedClassVisitor;
        this.unusedClassVisitor = unusedClassVisitor;
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = this.simpleUsageMarker.isUsed(programClass) ? this.usedClassVisitor : this.unusedClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitProgramClass(programClass);
        }
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ClassVisitor classVisitor;
        ClassVisitor classVisitor2 = classVisitor = this.simpleUsageMarker.isUsed(libraryClass) ? this.usedClassVisitor : this.unusedClassVisitor;
        if (classVisitor != null) {
            classVisitor.visitLibraryClass(libraryClass);
        }
    }
}

