/*
 * Decompiled with CFR 0.152.
 */
package proguard.gradle;

import groovy.lang.Closure;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.gradle.api.DefaultTask;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.tasks.InputFiles;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.gradle.logging.LoggingManagerInternal;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.KeepClassSpecification;
import proguard.MemberSpecification;
import proguard.MemberValueSpecification;
import proguard.ParseException;
import proguard.ProGuard;
import proguard.classfile.util.ClassUtil;
import proguard.util.ListUtil;

public class ProGuardTask
extends DefaultTask {
    private final List inJarFiles = new ArrayList();
    private final List inJarFilters = new ArrayList();
    private final List outJarFiles = new ArrayList();
    private final List outJarFilters = new ArrayList();
    private final List inJarCounts = new ArrayList();
    private final List libraryJarFiles = new ArrayList();
    private final List libraryJarFilters = new ArrayList();
    private final List configurationFiles = new ArrayList();
    protected final Configuration configuration = new Configuration();
    private boolean allowValues;
    private ClassSpecification classSpecification;
    private static final String CONFIGURATION_FILE_NAME_PREFIX = "/proguard/gradle/proguard-";
    private String resolvedConfigurationFileNamePrefix = this.getProject().file((Object)"/proguard/gradle/proguard-").toString();

    @InputFiles
    protected FileCollection getInJarFileCollection() {
        return this.getProject().files(new Object[]{this.inJarFiles});
    }

    @Optional
    @OutputFiles
    protected FileCollection getOutJarFileCollection() {
        return this.getProject().files(new Object[]{this.outJarFiles});
    }

    @InputFiles
    protected FileCollection getLibraryJarFileCollection() {
        return this.getProject().files(new Object[]{this.libraryJarFiles});
    }

    @InputFiles
    protected FileCollection getConfigurationFileCollection() {
        return this.getProject().files(new Object[]{this.configurationFiles});
    }

    public List getInJarFiles() {
        return this.inJarFiles;
    }

    public List getInJarFilters() {
        return this.inJarFilters;
    }

    public List getOutJarFiles() {
        return this.outJarFiles;
    }

    public List getOutJarFilters() {
        return this.outJarFilters;
    }

    public List getInJarCounts() {
        return this.inJarCounts;
    }

    public List getLibraryJarFiles() {
        return this.libraryJarFiles;
    }

    public List getLibraryJarFilters() {
        return this.libraryJarFilters;
    }

    public List getConfigurationFiles() {
        return this.configurationFiles;
    }

    public void configuration(Object configurationFiles) throws ParseException, IOException {
        if (configurationFiles instanceof Collection) {
            this.configurationFiles.addAll((Collection)configurationFiles);
        } else {
            this.configurationFiles.add(configurationFiles);
        }
    }

    public void injars(Object inJarFiles) throws ParseException {
        this.injars(null, inJarFiles);
    }

    public void injars(Map filterArgs, Object inJarFiles) throws ParseException {
        this.inJarFiles.add(inJarFiles);
        this.inJarFilters.add(filterArgs);
    }

    public void outjars(Object outJarFiles) throws ParseException {
        this.outjars(null, outJarFiles);
    }

    public void outjars(Map filterArgs, Object outJarFiles) throws ParseException {
        this.outJarFiles.add(outJarFiles);
        this.outJarFilters.add(filterArgs);
        this.inJarCounts.add(this.inJarFiles.size());
    }

    public void libraryjars(Object libraryJarFiles) throws ParseException {
        this.libraryjars(null, libraryJarFiles);
    }

    public void libraryjars(Map filterArgs, Object libraryJarFiles) throws ParseException {
        this.libraryJarFiles.add(libraryJarFiles);
        this.libraryJarFilters.add(filterArgs);
    }

    public Object getskipnonpubliclibraryclasses() {
        this.skipnonpubliclibraryclasses();
        return null;
    }

    public void skipnonpubliclibraryclasses() {
        this.configuration.skipNonPublicLibraryClasses = true;
    }

    public Object getdontskipnonpubliclibraryclassmembers() {
        this.dontskipnonpubliclibraryclassmembers();
        return null;
    }

    public void dontskipnonpubliclibraryclassmembers() {
        this.configuration.skipNonPublicLibraryClassMembers = false;
    }

    public Object getkeepdirectories() {
        this.keepdirectories();
        return null;
    }

    public void keepdirectories() {
        this.keepdirectories(null);
    }

    public void keepdirectories(String filter) {
        this.configuration.keepDirectories = this.extendFilter(this.configuration.keepDirectories, filter);
    }

    public void target(String targetClassVersion) {
        this.configuration.targetClassVersion = ClassUtil.internalClassVersion((String)targetClassVersion);
    }

    public Object getforceprocessing() {
        this.forceprocessing();
        return null;
    }

    public void forceprocessing() {
        this.configuration.lastModified = Long.MAX_VALUE;
    }

    public void keep(String classSpecificationString) throws ParseException {
        this.keep(null, classSpecificationString);
    }

    public void keep(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, true, false, keepArgs, classSpecificationString));
    }

    public void keep(Map keepClassSpecificationArgs) throws ParseException {
        this.keep(keepClassSpecificationArgs, (Closure)null);
    }

    public void keep(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, true, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclassmembers(String classSpecificationString) throws ParseException {
        this.keepclassmembers(null, classSpecificationString);
    }

    public void keepclassmembers(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, false, keepArgs, classSpecificationString));
    }

    public void keepclassmembers(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclassmembers(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclassmembers(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclasseswithmembers(String classSpecificationString) throws ParseException {
        this.keepclasseswithmembers(null, classSpecificationString);
    }

    public void keepclasseswithmembers(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, true, keepArgs, classSpecificationString));
    }

    public void keepclasseswithmembers(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclasseswithmembers(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclasseswithmembers(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(false, false, true, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepnames(String classSpecificationString) throws ParseException {
        this.keepnames(null, classSpecificationString);
    }

    public void keepnames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, true, false, keepArgs, classSpecificationString));
    }

    public void keepnames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepnames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepnames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, true, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclassmembernames(String classSpecificationString) throws ParseException {
        this.keepclassmembernames(null, classSpecificationString);
    }

    public void keepclassmembernames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, false, keepArgs, classSpecificationString));
    }

    public void keepclassmembernames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclassmembernames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclassmembernames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, false, keepClassSpecificationArgs, classMembersClosure));
    }

    public void keepclasseswithmembernames(String classSpecificationString) throws ParseException {
        this.keepclasseswithmembernames(null, classSpecificationString);
    }

    public void keepclasseswithmembernames(Map keepArgs, String classSpecificationString) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, true, keepArgs, classSpecificationString));
    }

    public void keepclasseswithmembernames(Map keepClassSpecificationArgs) throws ParseException {
        this.keepclasseswithmembernames(keepClassSpecificationArgs, (Closure)null);
    }

    public void keepclasseswithmembernames(Map keepClassSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.keep = this.extendClassSpecifications(this.configuration.keep, (ClassSpecification)this.createKeepClassSpecification(true, false, true, keepClassSpecificationArgs, classMembersClosure));
    }

    public Object getprintseeds() {
        this.printseeds();
        return null;
    }

    public void printseeds() {
        this.configuration.printSeeds = Configuration.STD_OUT;
    }

    public void printseeds(Object printSeeds) throws ParseException {
        this.configuration.printSeeds = this.getProject().file(printSeeds);
    }

    public Object getdontshrink() {
        this.dontshrink();
        return null;
    }

    public void dontshrink() {
        this.configuration.shrink = false;
    }

    public Object getprintusage() {
        this.printusage();
        return null;
    }

    public void printusage() {
        this.configuration.printUsage = Configuration.STD_OUT;
    }

    public void printusage(Object printUsage) throws ParseException {
        this.configuration.printUsage = this.getProject().file(printUsage);
    }

    public void whyareyoukeeping(String classSpecificationString) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(false, classSpecificationString));
    }

    public void whyareyoukeeping(Map classSpecificationArgs) throws ParseException {
        this.whyareyoukeeping(classSpecificationArgs, null);
    }

    public void whyareyoukeeping(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.whyAreYouKeeping = this.extendClassSpecifications(this.configuration.whyAreYouKeeping, this.createClassSpecification(false, classSpecificationArgs, classMembersClosure));
    }

    public Object getdontoptimize() {
        this.dontoptimize();
        return null;
    }

    public void dontoptimize() {
        this.configuration.optimize = false;
    }

    public void optimizations(String filter) {
        this.configuration.optimizations = this.extendFilter(this.configuration.optimizations, filter);
    }

    public void optimizationpasses(int optimizationPasses) {
        this.configuration.optimizationPasses = optimizationPasses;
    }

    public void assumenosideeffects(String classSpecificationString) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(true, classSpecificationString));
    }

    public void assumenosideeffects(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeNoSideEffects = this.extendClassSpecifications(this.configuration.assumeNoSideEffects, this.createClassSpecification(true, classSpecificationArgs, classMembersClosure));
    }

    public void assumenoexternalsideeffects(String classSpecificationString) throws ParseException {
        this.configuration.assumeNoExternalSideEffects = this.extendClassSpecifications(this.configuration.assumeNoExternalSideEffects, this.createClassSpecification(true, classSpecificationString));
    }

    public void assumenoexternalsideeffects(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeNoExternalSideEffects = this.extendClassSpecifications(this.configuration.assumeNoExternalSideEffects, this.createClassSpecification(true, classSpecificationArgs, classMembersClosure));
    }

    public void assumenoescapingparameters(String classSpecificationString) throws ParseException {
        this.configuration.assumeNoEscapingParameters = this.extendClassSpecifications(this.configuration.assumeNoEscapingParameters, this.createClassSpecification(true, classSpecificationString));
    }

    public void assumenoescapingparameters(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeNoEscapingParameters = this.extendClassSpecifications(this.configuration.assumeNoEscapingParameters, this.createClassSpecification(true, classSpecificationArgs, classMembersClosure));
    }

    public void assumenoexternalreturnvalues(String classSpecificationString) throws ParseException {
        this.configuration.assumeNoExternalReturnValues = this.extendClassSpecifications(this.configuration.assumeNoExternalReturnValues, this.createClassSpecification(true, classSpecificationString));
    }

    public void assumenoexternalreturnvalues(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeNoExternalReturnValues = this.extendClassSpecifications(this.configuration.assumeNoExternalReturnValues, this.createClassSpecification(true, classSpecificationArgs, classMembersClosure));
    }

    public void assumevalues(String classSpecificationString) throws ParseException {
        this.configuration.assumeValues = this.extendClassSpecifications(this.configuration.assumeValues, this.createClassSpecification(true, classSpecificationString));
    }

    public void assumevalues(Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        this.configuration.assumeValues = this.extendClassSpecifications(this.configuration.assumeValues, this.createClassSpecification(true, classSpecificationArgs, classMembersClosure));
    }

    public Object getallowaccessmodification() {
        this.allowaccessmodification();
        return null;
    }

    public void allowaccessmodification() {
        this.configuration.allowAccessModification = true;
    }

    public Object getmergeinterfacesaggressively() {
        this.mergeinterfacesaggressively();
        return null;
    }

    public void mergeinterfacesaggressively() {
        this.configuration.mergeInterfacesAggressively = true;
    }

    public Object getdontobfuscate() {
        this.dontobfuscate();
        return null;
    }

    public void dontobfuscate() {
        this.configuration.obfuscate = false;
    }

    public Object getprintmapping() {
        this.printmapping();
        return null;
    }

    public void printmapping() {
        this.configuration.printMapping = Configuration.STD_OUT;
    }

    public void printmapping(Object printMapping) throws ParseException {
        this.configuration.printMapping = this.getProject().file(printMapping);
    }

    public void applymapping(Object applyMapping) throws ParseException {
        this.configuration.applyMapping = this.getProject().file(applyMapping);
    }

    public void obfuscationdictionary(Object obfuscationDictionary) throws ParseException, MalformedURLException {
        this.configuration.obfuscationDictionary = this.url(obfuscationDictionary);
    }

    public void classobfuscationdictionary(Object classObfuscationDictionary) throws ParseException, MalformedURLException {
        this.configuration.classObfuscationDictionary = this.url(classObfuscationDictionary);
    }

    public void packageobfuscationdictionary(Object packageObfuscationDictionary) throws ParseException, MalformedURLException {
        this.configuration.packageObfuscationDictionary = this.url(packageObfuscationDictionary);
    }

    public Object getoverloadaggressively() {
        this.overloadaggressively();
        return null;
    }

    public void overloadaggressively() {
        this.configuration.overloadAggressively = true;
    }

    public Object getuseuniqueclassmembernames() {
        this.useuniqueclassmembernames();
        return null;
    }

    public void useuniqueclassmembernames() {
        this.configuration.useUniqueClassMemberNames = true;
    }

    public Object getdontusemixedcaseclassnames() {
        this.dontusemixedcaseclassnames();
        return null;
    }

    public void dontusemixedcaseclassnames() {
        this.configuration.useMixedCaseClassNames = false;
    }

    public Object getkeeppackagenames() {
        this.keeppackagenames();
        return null;
    }

    public void keeppackagenames() {
        this.keeppackagenames(null);
    }

    public void keeppackagenames(String filter) {
        this.configuration.keepPackageNames = this.extendFilter(this.configuration.keepPackageNames, filter, true);
    }

    public Object getflattenpackagehierarchy() {
        this.flattenpackagehierarchy();
        return null;
    }

    public void flattenpackagehierarchy() {
        this.flattenpackagehierarchy("");
    }

    public void flattenpackagehierarchy(String flattenPackageHierarchy) {
        this.configuration.flattenPackageHierarchy = ClassUtil.internalClassName((String)flattenPackageHierarchy);
    }

    public Object getrepackageclasses() {
        this.repackageclasses();
        return null;
    }

    public void repackageclasses() {
        this.repackageclasses("");
    }

    public void repackageclasses(String repackageClasses) {
        this.configuration.repackageClasses = ClassUtil.internalClassName((String)repackageClasses);
    }

    public Object getkeepattributes() {
        this.keepattributes();
        return null;
    }

    public void keepattributes() {
        this.keepattributes(null);
    }

    public void keepattributes(String filter) {
        this.configuration.keepAttributes = this.extendFilter(this.configuration.keepAttributes, filter);
    }

    public Object getkeepparameternames() {
        this.keepparameternames();
        return null;
    }

    public void keepparameternames() {
        this.configuration.keepParameterNames = true;
    }

    public Object getrenamesourcefileattribute() {
        this.renamesourcefileattribute();
        return null;
    }

    public void renamesourcefileattribute() {
        this.renamesourcefileattribute("");
    }

    public void renamesourcefileattribute(String newSourceFileAttribute) {
        this.configuration.newSourceFileAttribute = newSourceFileAttribute;
    }

    public Object getadaptclassstrings() {
        this.adaptclassstrings();
        return null;
    }

    public void adaptclassstrings() {
        this.adaptclassstrings(null);
    }

    public void adaptclassstrings(String filter) {
        this.configuration.adaptClassStrings = this.extendFilter(this.configuration.adaptClassStrings, filter, true);
    }

    public Object getadaptresourcefilenames() {
        this.adaptresourcefilenames();
        return null;
    }

    public void adaptresourcefilenames() {
        this.adaptresourcefilenames(null);
    }

    public void adaptresourcefilenames(String filter) {
        this.configuration.adaptResourceFileNames = this.extendFilter(this.configuration.adaptResourceFileNames, filter);
    }

    public Object getadaptresourcefilecontents() {
        this.adaptresourcefilecontents();
        return null;
    }

    public void adaptresourcefilecontents() {
        this.adaptresourcefilecontents(null);
    }

    public void adaptresourcefilecontents(String filter) {
        this.configuration.adaptResourceFileContents = this.extendFilter(this.configuration.adaptResourceFileContents, filter);
    }

    public Object getdontpreverify() {
        this.dontpreverify();
        return null;
    }

    public void dontpreverify() {
        this.configuration.preverify = false;
    }

    public Object getmicroedition() {
        this.microedition();
        return null;
    }

    public void microedition() {
        this.configuration.microEdition = true;
    }

    public Object getandroid() {
        this.android();
        return null;
    }

    public void android() {
        this.configuration.android = true;
    }

    public Object getverbose() {
        this.verbose();
        return null;
    }

    public void verbose() {
        this.configuration.verbose = true;
    }

    public Object getdontnote() {
        this.dontnote();
        return null;
    }

    public void dontnote() {
        this.dontnote(null);
    }

    public void dontnote(String filter) {
        this.configuration.note = this.extendFilter(this.configuration.note, filter, true);
    }

    public Object getdontwarn() {
        this.dontwarn();
        return null;
    }

    public void dontwarn() {
        this.dontwarn(null);
    }

    public void dontwarn(String filter) {
        this.configuration.warn = this.extendFilter(this.configuration.warn, filter, true);
    }

    public Object getignorewarnings() {
        this.ignorewarnings();
        return null;
    }

    public void ignorewarnings() {
        this.configuration.ignoreWarnings = true;
    }

    public Object getprintconfiguration() {
        this.printconfiguration();
        return null;
    }

    public void printconfiguration() {
        this.configuration.printConfiguration = Configuration.STD_OUT;
    }

    public void printconfiguration(Object printConfiguration) throws ParseException {
        this.configuration.printConfiguration = this.getProject().file(printConfiguration);
    }

    public Object getdump() {
        this.dump();
        return null;
    }

    public void dump() {
        this.configuration.dump = Configuration.STD_OUT;
    }

    public void dump(Object dump) throws ParseException {
        this.configuration.dump = this.getProject().file(dump);
    }

    public Object getaddconfigurationdebugging() {
        this.addconfigurationdebugging();
        return null;
    }

    public void addconfigurationdebugging() {
        this.configuration.addConfigurationDebugging = true;
    }

    public void field(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'field' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addField(this.createMemberSpecification(false, false, this.allowValues, memberSpecificationArgs));
    }

    public void constructor(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'constructor' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, true, this.allowValues, memberSpecificationArgs));
    }

    public void method(Map memberSpecificationArgs) throws ParseException {
        if (this.classSpecification == null) {
            throw new IllegalArgumentException("The 'method' method can only be used nested inside a class specification.");
        }
        this.classSpecification.addMethod(this.createMemberSpecification(true, false, this.allowValues, memberSpecificationArgs));
    }

    @TaskAction
    public void proguard() throws ParseException, IOException {
        LoggingManagerInternal loggingManager = this.getLogging();
        loggingManager.captureStandardOutput(LogLevel.INFO);
        loggingManager.captureStandardError(LogLevel.WARN);
        new ProGuard(this.getConfiguration()).execute();
    }

    private Configuration getConfiguration() throws IOException, ParseException {
        this.configuration.programJars = new ClassPath();
        int outJarIndex = 0;
        int inJarCount = this.inJarCounts.size() == 0 ? -1 : (Integer)this.inJarCounts.get(0);
        int inJarIndex = 0;
        while (inJarIndex < this.inJarFiles.size()) {
            this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.inJarFiles.get(inJarIndex), (Map)this.inJarFilters.get(inJarIndex), false);
            while (inJarIndex == inJarCount - 1) {
                this.configuration.programJars = this.extendClassPath(this.configuration.programJars, this.outJarFiles.get(outJarIndex), (Map)this.outJarFilters.get(outJarIndex), true);
                int n = inJarCount = this.inJarCounts.size() == ++outJarIndex ? -1 : (Integer)this.inJarCounts.get(outJarIndex);
            }
            ++inJarIndex;
        }
        this.configuration.libraryJars = new ClassPath();
        int libraryJarIndex = 0;
        while (libraryJarIndex < this.libraryJarFiles.size()) {
            this.configuration.libraryJars = this.extendClassPath(this.configuration.libraryJars, this.libraryJarFiles.get(libraryJarIndex), (Map)this.libraryJarFilters.get(libraryJarIndex), false);
            ++libraryJarIndex;
        }
        int index = 0;
        while (index < this.configurationFiles.size()) {
            Object fileObject = this.configurationFiles.get(index);
            ConfigurableFileCollection fileCollection = this.getProject().files(new Object[]{fileObject});
            for (File file : fileCollection) {
                if (this.isInternalConfigurationFile(file)) {
                    this.getLogger().debug("Loading default configuration file " + file.getAbsolutePath());
                    String internalConfigFileName = this.internalConfigurationFileName(file);
                    URL configurationURL = ProGuardTask.class.getResource(internalConfigFileName);
                    if (configurationURL == null) {
                        throw new FileNotFoundException("'" + file.getAbsolutePath() + "'");
                    }
                    try (ConfigurationParser parser = new ConfigurationParser(configurationURL, System.getProperties());){
                        parser.parse(this.configuration);
                        continue;
                    }
                }
                this.getLogger().debug("Loading configuration file " + file.getAbsolutePath());
                try (ConfigurationParser parser = new ConfigurationParser(file, System.getProperties());){
                    parser.parse(this.configuration);
                }
            }
            ++index;
        }
        this.configuration.lastModified = Long.MAX_VALUE;
        return this.configuration;
    }

    private boolean isInternalConfigurationFile(Object fileObject) {
        return fileObject.toString().startsWith(this.resolvedConfigurationFileNamePrefix);
    }

    private String internalConfigurationFileName(Object fileObject) {
        return fileObject.toString().substring(this.resolvedConfigurationFileNamePrefix.length() - CONFIGURATION_FILE_NAME_PREFIX.length()).replace('\\', '/');
    }

    private ClassPath extendClassPath(ClassPath classPath, Object files, Map filterArgs, boolean output) {
        ConfigurableFileCollection fileCollection = this.getProject().files(new Object[]{files});
        if (classPath == null) {
            classPath = new ClassPath();
        }
        for (File file : fileCollection) {
            if (!output && !file.exists()) continue;
            ClassPathEntry classPathEntry = new ClassPathEntry(file, output);
            if (filterArgs != null) {
                classPathEntry.setFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("filter"))));
                classPathEntry.setApkFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("apkfilter"))));
                classPathEntry.setJarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("jarfilter"))));
                classPathEntry.setAarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("aarfilter"))));
                classPathEntry.setWarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("warfilter"))));
                classPathEntry.setEarFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("earfilter"))));
                classPathEntry.setZipFilter(ListUtil.commaSeparatedList((String)((String)filterArgs.get("zipfilter"))));
            }
            classPath.add(classPathEntry);
        }
        return classPath;
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map keepArgs, String classSpecificationString) throws ParseException {
        ClassSpecification condition = this.createIfClassSpecification(keepArgs);
        ClassSpecification classSpecification = this.createClassSpecification(false, classSpecificationString);
        return this.createKeepClassSpecification(allowShrinking, markClasses, markConditionally, keepArgs, condition, classSpecification);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        ClassSpecification condition = this.createIfClassSpecification(classSpecificationArgs);
        ClassSpecification classSpecification = this.createClassSpecification(false, classSpecificationArgs, classMembersClosure);
        return this.createKeepClassSpecification(allowShrinking, markClasses, markConditionally, classSpecificationArgs, condition, classSpecification);
    }

    private ClassSpecification createIfClassSpecification(Map classSpecificationArgs) throws ParseException {
        if (classSpecificationArgs == null) {
            return null;
        }
        String conditionString = (String)classSpecificationArgs.get("if");
        if (conditionString == null) {
            return null;
        }
        return this.createClassSpecification(false, conditionString);
    }

    private KeepClassSpecification createKeepClassSpecification(boolean allowShrinking, boolean markClasses, boolean markConditionally, Map keepArgs, ClassSpecification condition, ClassSpecification classSpecification) {
        return new KeepClassSpecification(markClasses, markConditionally, this.retrieveBoolean(keepArgs, "includedescriptorclasses", false), false, this.retrieveBoolean(keepArgs, "allowshrinking", allowShrinking), this.retrieveBoolean(keepArgs, "allowoptimization", false), this.retrieveBoolean(keepArgs, "allowobfuscation", false), condition, classSpecification);
    }

    private ClassSpecification createClassSpecification(boolean allowValues, String classSpecificationString) throws ParseException {
        ClassSpecification classSpecification;
        ConfigurationParser parser = new ConfigurationParser(new String[]{classSpecificationString}, null);
        try {
            classSpecification = parser.parseClassSpecificationArguments(allowValues);
        }
        catch (Throwable throwable) {
            try {
                parser.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new ParseException(e.getMessage());
            }
        }
        parser.close();
        return classSpecification;
    }

    private ClassSpecification createClassSpecification(boolean allowValues, Map classSpecificationArgs, Closure classMembersClosure) throws ParseException {
        String access = (String)classSpecificationArgs.get("access");
        String annotation = (String)classSpecificationArgs.get("annotation");
        String type = (String)classSpecificationArgs.get("type");
        String name = (String)classSpecificationArgs.get("name");
        String extendsAnnotation = (String)classSpecificationArgs.get("extendsannotation");
        String extends_ = (String)classSpecificationArgs.get("extends");
        if (extends_ == null) {
            extends_ = (String)classSpecificationArgs.get("implements");
        }
        ClassSpecification classSpecification = new ClassSpecification(null, this.requiredClassAccessFlags(true, access, type), this.requiredClassAccessFlags(false, access, type), annotation != null ? ClassUtil.internalType((String)annotation) : null, name != null ? ClassUtil.internalClassName((String)name) : null, extendsAnnotation != null ? ClassUtil.internalType((String)extendsAnnotation) : null, extends_ != null ? ClassUtil.internalClassName((String)extends_) : null);
        if (classMembersClosure != null) {
            this.allowValues = allowValues;
            this.classSpecification = classSpecification;
            classMembersClosure.call((Object)classSpecification);
            this.allowValues = false;
            this.classSpecification = null;
        }
        return classSpecification;
    }

    private int requiredClassAccessFlags(boolean set, String access, String type) throws ParseException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("synthetic") ? 4096 : (accessFlag = strippedToken.equals("@") ? 8192 : 0))));
                if (accessFlag == 0) {
                    throw new ParseException("Incorrect class access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        if (type != null && type.startsWith("!") ^ set) {
            int accessFlag;
            int n = type.equals("class") ? 0 : (type.equals("interface") || type.equals("!interface") ? 512 : (accessFlag = type.equals("enum") || type.equals("!enum") ? 16384 : -1));
            if (accessFlag == -1) {
                throw new ParseException("Incorrect class type [" + type + "]");
            }
            accessFlags |= accessFlag;
        }
        return accessFlags;
    }

    private MemberSpecification createMemberSpecification(boolean isMethod, boolean isConstructor, boolean allowValues, Map classSpecificationArgs) throws ParseException {
        String access = (String)classSpecificationArgs.get("access");
        String type = (String)classSpecificationArgs.get("type");
        String annotation = (String)classSpecificationArgs.get("annotation");
        String name = (String)classSpecificationArgs.get("name");
        String parameters = (String)classSpecificationArgs.get("parameters");
        String values = (String)classSpecificationArgs.get("value");
        if (annotation != null) {
            annotation = ClassUtil.internalType((String)annotation);
        }
        if (isMethod) {
            if (isConstructor) {
                if (type != null) {
                    throw new ParseException("Type attribute not allowed in constructor specification [" + type + "]");
                }
                if (parameters != null) {
                    type = "void";
                }
                if (values != null) {
                    throw new ParseException("Values attribute not allowed in constructor specification [" + values + "]");
                }
                name = "<init>";
            } else if (type != null ^ parameters != null) {
                throw new ParseException("Type and parameters attributes must always be present in combination in method specification");
            }
        } else if (parameters != null) {
            throw new ParseException("Parameters attribute not allowed in field specification [" + parameters + "]");
        }
        if (values != null) {
            if (!allowValues) {
                throw new ParseException("Values attribute not allowed in this class specification [" + values + "]");
            }
            if (type == null) {
                throw new ParseException("Values attribute must be specified in combination with type attribute in class member specification [" + values + "]");
            }
        }
        List parameterList = ListUtil.commaSeparatedList((String)parameters);
        String descriptor = parameters != null ? ClassUtil.internalMethodDescriptor((String)type, (List)parameterList) : (type != null ? ClassUtil.internalType((String)type) : null);
        return values != null ? new MemberValueSpecification(this.requiredMemberAccessFlags(true, access), this.requiredMemberAccessFlags(false, access), annotation, name, descriptor, this.parseValues(type, ClassUtil.internalType((String)type), values)) : new MemberSpecification(this.requiredMemberAccessFlags(true, access), this.requiredMemberAccessFlags(false, access), annotation, name, descriptor);
    }

    private int requiredMemberAccessFlags(boolean set, String access) throws ParseException {
        int accessFlags = 0;
        if (access != null) {
            StringTokenizer tokenizer = new StringTokenizer(access, " ,");
            while (tokenizer.hasMoreTokens()) {
                int accessFlag;
                String strippedToken;
                String token = tokenizer.nextToken();
                if (!(token.startsWith("!") ^ set)) continue;
                String string = strippedToken = token.startsWith("!") ? token.substring(1) : token;
                int n = strippedToken.equals("public") ? 1 : (strippedToken.equals("private") ? 2 : (strippedToken.equals("protected") ? 4 : (strippedToken.equals("static") ? 8 : (strippedToken.equals("final") ? 16 : (strippedToken.equals("synchronized") ? 32 : (strippedToken.equals("volatile") ? 64 : (strippedToken.equals("transient") ? 128 : (strippedToken.equals("bridge") ? 64 : (strippedToken.equals("varargs") ? 128 : (strippedToken.equals("native") ? 256 : (strippedToken.equals("abstract") ? 1024 : (strippedToken.equals("strictfp") ? 2048 : (accessFlag = strippedToken.equals("synthetic") ? 4096 : 0)))))))))))));
                if (accessFlag == 0) {
                    throw new ParseException("Incorrect class member access modifier [" + strippedToken + "]");
                }
                accessFlags |= accessFlag;
            }
        }
        return accessFlags;
    }

    private boolean retrieveBoolean(Map args, String name, boolean defaultValue) {
        if (args == null) {
            return defaultValue;
        }
        Object arg = args.get(name);
        return arg == null ? defaultValue : (Boolean)arg;
    }

    private Number[] parseValues(String externalType, String internalType, String string) throws ParseException {
        Number[] numberArray;
        int rangeIndex = string.lastIndexOf("..");
        if (rangeIndex >= 0) {
            Number[] numberArray2 = new Number[2];
            numberArray2[0] = this.parseValue(externalType, internalType, string.substring(0, rangeIndex));
            numberArray = numberArray2;
            numberArray2[1] = this.parseValue(externalType, internalType, string.substring(rangeIndex + 2));
        } else {
            Number[] numberArray3 = new Number[1];
            numberArray = numberArray3;
            numberArray3[0] = this.parseValue(externalType, internalType, string);
        }
        return numberArray;
    }

    private Number parseValue(String externalType, String internalType, String string) throws ParseException {
        try {
            switch (internalType.charAt(0)) {
                case 'Z': {
                    return this.parseBoolean(string);
                }
                case 'B': 
                case 'C': 
                case 'I': 
                case 'S': {
                    return Integer.decode(string);
                }
            }
            throw new ParseException("Can't handle '" + externalType + "' constant [" + string + "]");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException("Can't parse " + externalType + " constant [" + string + "]");
        }
    }

    private Integer parseBoolean(String string) throws ParseException {
        if ("false".equals(string)) {
            return 0;
        }
        if ("true".equals(string)) {
            return 1;
        }
        throw new ParseException("Unknown boolean constant [" + string + "]");
    }

    protected List extendClassSpecifications(List classSpecifications, ClassSpecification classSpecification) {
        if (classSpecifications == null) {
            classSpecifications = new ArrayList<ClassSpecification>();
        }
        classSpecifications.add(classSpecification);
        return classSpecifications;
    }

    private List extendClassSpecifications(List classSpecifications, List additionalClassSpecifications) {
        if (additionalClassSpecifications != null) {
            if (classSpecifications == null) {
                classSpecifications = new ArrayList();
            }
            classSpecifications.addAll(additionalClassSpecifications);
        }
        return classSpecifications;
    }

    private List extendFilter(List filter, String filterString) {
        return this.extendFilter(filter, filterString, false);
    }

    private List extendFilter(List filter, String filterString, boolean convertExternalClassNames) {
        if (filter == null) {
            filter = new ArrayList();
        }
        if (filterString == null) {
            filter.clear();
        } else {
            if (convertExternalClassNames) {
                filterString = ClassUtil.internalClassName((String)filterString);
            }
            filter.addAll(ListUtil.commaSeparatedList((String)filterString));
        }
        return filter;
    }

    private URL url(Object fileObject) throws MalformedURLException {
        File file = this.getProject().file(fileObject);
        return fileObject instanceof URL ? (URL)fileObject : (fileObject instanceof String && !file.exists() ? ProGuardTask.class.getResource((String)fileObject) : file.toURI().toURL());
    }
}

