/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.ClassSpecification;
import proguard.KeepSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.gui.MemberSpecificationsPanel;

final class ClassSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final JTextArea commentsTextArea = new JTextArea(4, 20);
    private final JRadioButton keepClassesAndMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keep"));
    private final JRadioButton keepClassMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keepClassMembers"));
    private final JRadioButton keepClassesWithMembersRadioButton = new JRadioButton(ClassSpecificationDialog.msg("keepClassesWithMembers"));
    private final JCheckBox allowShrinkingCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowShrinking"));
    private final JCheckBox allowOptimizationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowOptimization"));
    private final JCheckBox allowObfuscationCheckBox = new JCheckBox(ClassSpecificationDialog.msg("allowObfuscation"));
    private final JRadioButton[] publicRadioButtons;
    private final JRadioButton[] finalRadioButtons;
    private final JRadioButton[] interfaceRadioButtons;
    private final JRadioButton[] abstractRadioButtons;
    private final JTextField annotationTypeTextField = new JTextField(20);
    private final JTextField classNameTextField = new JTextField(20);
    private final JTextField extendsAnnotationTypeTextField = new JTextField(20);
    private final JTextField extendsClassNameTextField = new JTextField(20);
    private final MemberSpecificationsPanel memberSpecificationsPanel;
    private int returnValue;

    public ClassSpecificationDialog(JFrame owner, boolean fullKeepOptions) {
        super((Frame)owner, true);
        this.setResizable(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints constraintsStretch = new GridBagConstraints();
        constraintsStretch.fill = 2;
        constraintsStretch.weightx = 1.0;
        constraintsStretch.anchor = 17;
        constraintsStretch.insets = constraints.insets;
        GridBagConstraints constraintsLast = new GridBagConstraints();
        constraintsLast.gridwidth = 0;
        constraintsLast.anchor = 17;
        constraintsLast.insets = constraints.insets;
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraints.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraints.insets;
        GridBagConstraints stretchPanelConstraints = new GridBagConstraints();
        stretchPanelConstraints.gridwidth = 0;
        stretchPanelConstraints.fill = 1;
        stretchPanelConstraints.weightx = 1.0;
        stretchPanelConstraints.weighty = 1.0;
        stretchPanelConstraints.anchor = 18;
        stretchPanelConstraints.insets = constraints.insets;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 10;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints lastLabelConstraints = new GridBagConstraints();
        lastLabelConstraints.gridwidth = 0;
        lastLabelConstraints.anchor = 10;
        lastLabelConstraints.insets = labelConstraints.insets;
        GridBagConstraints advancedButtonConstraints = new GridBagConstraints();
        advancedButtonConstraints.weightx = 1.0;
        advancedButtonConstraints.weighty = 1.0;
        advancedButtonConstraints.anchor = 16;
        advancedButtonConstraints.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.weightx = 1.0;
        okButtonConstraints.weighty = 1.0;
        okButtonConstraints.anchor = 14;
        okButtonConstraints.insets = advancedButtonConstraints.insets;
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridwidth = 0;
        cancelButtonConstraints.weighty = 1.0;
        cancelButtonConstraints.anchor = 14;
        cancelButtonConstraints.insets = advancedButtonConstraints.insets;
        GridBagLayout layout = new GridBagLayout();
        Border etchedBorder = BorderFactory.createEtchedBorder(0);
        JPanel commentsPanel = new JPanel(layout);
        commentsPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("comments")));
        JScrollPane commentsScrollPane = new JScrollPane(this.commentsTextArea);
        commentsScrollPane.setBorder(this.classNameTextField.getBorder());
        commentsPanel.add((Component)ClassSpecificationDialog.tip(commentsScrollPane, "commentsTip"), constraintsLastStretch);
        ButtonGroup keepButtonGroup = new ButtonGroup();
        keepButtonGroup.add(this.keepClassesAndMembersRadioButton);
        keepButtonGroup.add(this.keepClassMembersRadioButton);
        keepButtonGroup.add(this.keepClassesWithMembersRadioButton);
        JPanel keepOptionPanel = new JPanel(layout);
        keepOptionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("keepTitle")));
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassesAndMembersRadioButton, "keepTip"), constraintsLastStretch);
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassMembersRadioButton, "keepClassMembersTip"), constraintsLastStretch);
        keepOptionPanel.add((Component)ClassSpecificationDialog.tip(this.keepClassesWithMembersRadioButton, "keepClassesWithMembersTip"), constraintsLastStretch);
        final JPanel allowOptionPanel = new JPanel(layout);
        allowOptionPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("allowTitle")));
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowShrinkingCheckBox, "allowShrinkingTip"), constraintsLastStretch);
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowOptimizationCheckBox, "allowOptimizationTip"), constraintsLastStretch);
        allowOptionPanel.add((Component)ClassSpecificationDialog.tip(this.allowObfuscationCheckBox, "allowObfuscationTip"), constraintsLastStretch);
        JPanel accessPanel = new JPanel(layout);
        accessPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("access")));
        accessPanel.add(Box.createGlue(), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("required")), "requiredTip"), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("not")), "notTip"), labelConstraints);
        accessPanel.add((Component)ClassSpecificationDialog.tip(new JLabel(ClassSpecificationDialog.msg("dontCare")), "dontCareTip"), labelConstraints);
        accessPanel.add(Box.createGlue(), constraintsLastStretch);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", accessPanel);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", accessPanel);
        this.interfaceRadioButtons = this.addRadioButtonTriplet("Interface", accessPanel);
        this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", accessPanel);
        final JPanel annotationTypePanel = new JPanel(layout);
        annotationTypePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("annotation")));
        annotationTypePanel.add((Component)ClassSpecificationDialog.tip(this.annotationTypeTextField, "classNameTip"), constraintsLastStretch);
        JPanel classNamePanel = new JPanel(layout);
        classNamePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("class")));
        classNamePanel.add((Component)ClassSpecificationDialog.tip(this.classNameTextField, "classNameTip"), constraintsLastStretch);
        final JPanel extendsAnnotationTypePanel = new JPanel(layout);
        extendsAnnotationTypePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("extendsImplementsAnnotation")));
        extendsAnnotationTypePanel.add((Component)ClassSpecificationDialog.tip(this.extendsAnnotationTypeTextField, "classNameTip"), constraintsLastStretch);
        JPanel extendsClassNamePanel = new JPanel(layout);
        extendsClassNamePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("extendsImplementsClass")));
        extendsClassNamePanel.add((Component)ClassSpecificationDialog.tip(this.extendsClassNameTextField, "classNameTip"), constraintsLastStretch);
        this.memberSpecificationsPanel = new MemberSpecificationsPanel(this, fullKeepOptions);
        this.memberSpecificationsPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, ClassSpecificationDialog.msg("classMembers")));
        final JButton advancedButton = new JButton(ClassSpecificationDialog.msg("basic"));
        advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean visible = !allowOptionPanel.isVisible();
                allowOptionPanel.setVisible(visible);
                annotationTypePanel.setVisible(visible);
                extendsAnnotationTypePanel.setVisible(visible);
                advancedButton.setText(ClassSpecificationDialog.msg(visible ? "basic" : "advanced"));
                ClassSpecificationDialog.this.pack();
            }
        });
        advancedButton.doClick();
        JButton okButton = new JButton(ClassSpecificationDialog.msg("ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassSpecificationDialog.this.returnValue = 0;
                ClassSpecificationDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton(ClassSpecificationDialog.msg("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassSpecificationDialog.this.hide();
            }
        });
        JPanel mainPanel = new JPanel(layout);
        mainPanel.add((Component)ClassSpecificationDialog.tip(commentsPanel, "commentsTip"), panelConstraints);
        if (fullKeepOptions) {
            mainPanel.add((Component)ClassSpecificationDialog.tip(keepOptionPanel, "keepTitleTip"), panelConstraints);
            mainPanel.add((Component)ClassSpecificationDialog.tip(allowOptionPanel, "allowTitleTip"), panelConstraints);
        }
        mainPanel.add((Component)ClassSpecificationDialog.tip(accessPanel, "accessTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(annotationTypePanel, "annotationTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(classNamePanel, "classTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(extendsAnnotationTypePanel, "extendsImplementsAnnotationTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(extendsClassNamePanel, "extendsImplementsClassTip"), panelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(this.memberSpecificationsPanel, "classMembersTip"), stretchPanelConstraints);
        mainPanel.add((Component)ClassSpecificationDialog.tip(advancedButton, "advancedTip"), advancedButtonConstraints);
        mainPanel.add((Component)okButton, okButtonConstraints);
        mainPanel.add((Component)cancelButton, cancelButtonConstraints);
        this.getContentPane().add(new JScrollPane(mainPanel));
    }

    private JRadioButton[] addRadioButtonTriplet(String labelText, JPanel panel) {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.insets = labelConstraints.insets;
        GridBagConstraints lastGlueConstraints = new GridBagConstraints();
        lastGlueConstraints.gridwidth = 0;
        lastGlueConstraints.weightx = 1.0;
        JRadioButton radioButton0 = new JRadioButton();
        JRadioButton radioButton1 = new JRadioButton();
        JRadioButton radioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton0);
        buttonGroup.add(radioButton1);
        buttonGroup.add(radioButton2);
        panel.add((Component)new JLabel(labelText), labelConstraints);
        panel.add((Component)radioButton0, buttonConstraints);
        panel.add((Component)radioButton1, buttonConstraints);
        panel.add((Component)radioButton2, buttonConstraints);
        panel.add(Box.createGlue(), lastGlueConstraints);
        return new JRadioButton[]{radioButton0, radioButton1, radioButton2};
    }

    public void setKeepSpecification(KeepSpecification keepSpecification) {
        boolean markClasses = keepSpecification.markClasses;
        boolean markConditionally = keepSpecification.markConditionally;
        boolean allowShrinking = keepSpecification.allowShrinking;
        boolean allowOptimization = keepSpecification.allowOptimization;
        boolean allowObfuscation = keepSpecification.allowObfuscation;
        JRadioButton keepOptionRadioButton = markConditionally ? this.keepClassesWithMembersRadioButton : (markClasses ? this.keepClassesAndMembersRadioButton : this.keepClassMembersRadioButton);
        keepOptionRadioButton.setSelected(true);
        this.allowShrinkingCheckBox.setSelected(allowShrinking);
        this.allowOptimizationCheckBox.setSelected(allowOptimization);
        this.allowObfuscationCheckBox.setSelected(allowObfuscation);
        this.setClassSpecification((ClassSpecification)keepSpecification);
    }

    public void setClassSpecification(ClassSpecification classSpecification) {
        String comments = classSpecification.comments;
        String annotationType = classSpecification.annotationType;
        String className = classSpecification.className;
        String extendsAnnotationType = classSpecification.extendsAnnotationType;
        String extendsClassName = classSpecification.extendsClassName;
        List keepFieldOptions = classSpecification.fieldSpecifications;
        List keepMethodOptions = classSpecification.methodSpecifications;
        this.commentsTextArea.setText(comments == null ? "" : comments);
        this.setClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.setClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        this.annotationTypeTextField.setText(annotationType == null ? "" : ClassUtil.externalType((String)annotationType));
        this.classNameTextField.setText(className == null ? "*" : ClassUtil.externalClassName((String)className));
        this.extendsAnnotationTypeTextField.setText(extendsAnnotationType == null ? "" : ClassUtil.externalType((String)extendsAnnotationType));
        this.extendsClassNameTextField.setText(extendsClassName == null ? "" : ClassUtil.externalClassName((String)extendsClassName));
        this.memberSpecificationsPanel.setMemberSpecifications(keepFieldOptions, keepMethodOptions);
    }

    public KeepSpecification getKeepSpecification() {
        boolean markClasses = !this.keepClassMembersRadioButton.isSelected();
        boolean markConditionally = this.keepClassesWithMembersRadioButton.isSelected();
        boolean allowShrinking = this.allowShrinkingCheckBox.isSelected();
        boolean allowOptimization = this.allowOptimizationCheckBox.isSelected();
        boolean allowObfuscation = this.allowObfuscationCheckBox.isSelected();
        return new KeepSpecification(markClasses, markConditionally, allowShrinking, allowOptimization, allowObfuscation, this.getClassSpecification());
    }

    public ClassSpecification getClassSpecification() {
        String comments = this.commentsTextArea.getText();
        String annotationType = this.annotationTypeTextField.getText();
        String className = this.classNameTextField.getText();
        String extendsAnnotationType = this.extendsAnnotationTypeTextField.getText();
        String extendsClassName = this.extendsClassNameTextField.getText();
        ClassSpecification classSpecification = new ClassSpecification(comments.equals("") ? null : comments, 0, 0, annotationType.equals("") ? null : ClassUtil.internalType((String)annotationType), className.equals("") || className.equals("*") ? null : ClassUtil.internalClassName((String)className), extendsAnnotationType.equals("") ? null : ClassUtil.internalType((String)extendsAnnotationType), extendsClassName.equals("") ? null : ClassUtil.internalClassName((String)extendsClassName));
        this.getClassSpecificationRadioButtons(classSpecification, 1, this.publicRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 16, this.finalRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 512, this.interfaceRadioButtons);
        this.getClassSpecificationRadioButtons(classSpecification, 1024, this.abstractRadioButtons);
        classSpecification.fieldSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(true);
        classSpecification.methodSpecifications = this.memberSpecificationsPanel.getMemberSpecifications(false);
        return classSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setClassSpecificationRadioButtons(ClassSpecification classSpecification, int flag, JRadioButton[] radioButtons) {
        int index = (classSpecification.requiredSetAccessFlags & flag) != 0 ? 0 : ((classSpecification.requiredUnsetAccessFlags & flag) != 0 ? 1 : 2);
        radioButtons[index].setSelected(true);
    }

    private void getClassSpecificationRadioButtons(ClassSpecification classSpecification, int flag, JRadioButton[] radioButtons) {
        if (radioButtons[0].isSelected()) {
            classSpecification.requiredSetAccessFlags |= flag;
        } else if (radioButtons[1].isSelected()) {
            classSpecification.requiredUnsetAccessFlags |= flag;
        }
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ClassSpecificationDialog.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

