/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.util.ListUtil;

final class MemberSpecificationDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private final boolean isField;
    private final JRadioButton[] publicRadioButtons;
    private final JRadioButton[] privateRadioButtons;
    private final JRadioButton[] protectedRadioButtons;
    private final JRadioButton[] staticRadioButtons;
    private final JRadioButton[] finalRadioButtons;
    private JRadioButton[] volatileRadioButtons;
    private JRadioButton[] transientRadioButtons;
    private JRadioButton[] synchronizedRadioButtons;
    private JRadioButton[] nativeRadioButtons;
    private JRadioButton[] abstractRadioButtons;
    private JRadioButton[] strictRadioButtons;
    private final JTextField annotationTypeTextField = new JTextField(20);
    private final JTextField nameTextField = new JTextField(20);
    private final JTextField typeTextField = new JTextField(20);
    private final JTextField argumentTypesTextField = new JTextField(20);
    private int returnValue;

    public MemberSpecificationDialog(JDialog owner, boolean isField) {
        super((Dialog)owner, true);
        this.setResizable(true);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints constraintsStretch = new GridBagConstraints();
        constraintsStretch.fill = 2;
        constraintsStretch.weightx = 1.0;
        constraintsStretch.anchor = 17;
        constraintsStretch.insets = constraints.insets;
        GridBagConstraints constraintsLast = new GridBagConstraints();
        constraintsLast.gridwidth = 0;
        constraintsLast.anchor = 17;
        constraintsLast.insets = constraints.insets;
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraints.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraints.insets;
        GridBagConstraints stretchPanelConstraints = new GridBagConstraints();
        stretchPanelConstraints.gridwidth = 0;
        stretchPanelConstraints.fill = 1;
        stretchPanelConstraints.weightx = 1.0;
        stretchPanelConstraints.weighty = 1.0;
        stretchPanelConstraints.anchor = 18;
        stretchPanelConstraints.insets = constraints.insets;
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 10;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints lastLabelConstraints = new GridBagConstraints();
        lastLabelConstraints.gridwidth = 0;
        lastLabelConstraints.anchor = 10;
        lastLabelConstraints.insets = labelConstraints.insets;
        GridBagConstraints advancedButtonConstraints = new GridBagConstraints();
        advancedButtonConstraints.weightx = 1.0;
        advancedButtonConstraints.weighty = 1.0;
        advancedButtonConstraints.anchor = 16;
        advancedButtonConstraints.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.weightx = 1.0;
        okButtonConstraints.weighty = 1.0;
        okButtonConstraints.anchor = 14;
        okButtonConstraints.insets = advancedButtonConstraints.insets;
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridwidth = 0;
        cancelButtonConstraints.weighty = 1.0;
        cancelButtonConstraints.anchor = 14;
        cancelButtonConstraints.insets = okButtonConstraints.insets;
        GridBagLayout layout = new GridBagLayout();
        Border etchedBorder = BorderFactory.createEtchedBorder(0);
        this.isField = isField;
        JPanel accessPanel = new JPanel(layout);
        accessPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, MemberSpecificationDialog.msg("access")));
        accessPanel.add(Box.createGlue(), labelConstraints);
        accessPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("required")), "requiredTip"), labelConstraints);
        accessPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("not")), "notTip"), labelConstraints);
        accessPanel.add((Component)MemberSpecificationDialog.tip(new JLabel(MemberSpecificationDialog.msg("dontCare")), "dontCareTip"), labelConstraints);
        accessPanel.add(Box.createGlue(), constraintsLastStretch);
        this.publicRadioButtons = this.addRadioButtonTriplet("Public", accessPanel);
        this.privateRadioButtons = this.addRadioButtonTriplet("Private", accessPanel);
        this.protectedRadioButtons = this.addRadioButtonTriplet("Protected", accessPanel);
        this.staticRadioButtons = this.addRadioButtonTriplet("Static", accessPanel);
        this.finalRadioButtons = this.addRadioButtonTriplet("Final", accessPanel);
        if (isField) {
            this.volatileRadioButtons = this.addRadioButtonTriplet("Volatile", accessPanel);
            this.transientRadioButtons = this.addRadioButtonTriplet("Transient", accessPanel);
        } else {
            this.synchronizedRadioButtons = this.addRadioButtonTriplet("Synchronized", accessPanel);
            this.nativeRadioButtons = this.addRadioButtonTriplet("Native", accessPanel);
            this.abstractRadioButtons = this.addRadioButtonTriplet("Abstract", accessPanel);
            this.strictRadioButtons = this.addRadioButtonTriplet("Strict", accessPanel);
        }
        JPanel typePanel = new JPanel(layout);
        typePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, MemberSpecificationDialog.msg(isField ? "fieldType" : "returnType")));
        typePanel.add((Component)MemberSpecificationDialog.tip(this.typeTextField, "typeTip"), constraintsLastStretch);
        final JPanel annotationTypePanel = new JPanel(layout);
        annotationTypePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, MemberSpecificationDialog.msg("annotation")));
        annotationTypePanel.add((Component)MemberSpecificationDialog.tip(this.annotationTypeTextField, "classNameTip"), constraintsLastStretch);
        JPanel namePanel = new JPanel(layout);
        namePanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, MemberSpecificationDialog.msg("name")));
        namePanel.add((Component)MemberSpecificationDialog.tip(this.nameTextField, isField ? "fieldNameTip" : "methodNameTip"), constraintsLastStretch);
        JPanel argumentsPanel = new JPanel(layout);
        argumentsPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, MemberSpecificationDialog.msg("argumentTypes")));
        argumentsPanel.add((Component)MemberSpecificationDialog.tip(this.argumentTypesTextField, "argumentTypes2Tip"), constraintsLastStretch);
        final JButton advancedButton = new JButton(MemberSpecificationDialog.msg("basic"));
        advancedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean visible = !annotationTypePanel.isVisible();
                annotationTypePanel.setVisible(visible);
                advancedButton.setText(MemberSpecificationDialog.msg(visible ? "basic" : "advanced"));
                MemberSpecificationDialog.this.pack();
            }
        });
        advancedButton.doClick();
        JButton okButton = new JButton(MemberSpecificationDialog.msg("ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MemberSpecificationDialog.this.returnValue = 0;
                MemberSpecificationDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton(MemberSpecificationDialog.msg("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MemberSpecificationDialog.this.hide();
            }
        });
        JPanel mainPanel = new JPanel(layout);
        mainPanel.add((Component)MemberSpecificationDialog.tip(accessPanel, "accessTip"), panelConstraints);
        mainPanel.add((Component)MemberSpecificationDialog.tip(annotationTypePanel, "annotationTip"), panelConstraints);
        mainPanel.add((Component)MemberSpecificationDialog.tip(typePanel, isField ? "fieldTypeTip" : "returnTypeTip"), panelConstraints);
        mainPanel.add((Component)MemberSpecificationDialog.tip(namePanel, "nameTip"), panelConstraints);
        if (!isField) {
            mainPanel.add((Component)MemberSpecificationDialog.tip(argumentsPanel, "argumentTypesTip"), panelConstraints);
        }
        mainPanel.add((Component)MemberSpecificationDialog.tip(advancedButton, "advancedTip"), advancedButtonConstraints);
        mainPanel.add((Component)okButton, okButtonConstraints);
        mainPanel.add((Component)cancelButton, cancelButtonConstraints);
        this.getContentPane().add(new JScrollPane(mainPanel));
    }

    private JRadioButton[] addRadioButtonTriplet(String labelText, JPanel panel) {
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.insets = new Insets(2, 10, 2, 10);
        GridBagConstraints buttonConstraints = new GridBagConstraints();
        buttonConstraints.insets = labelConstraints.insets;
        GridBagConstraints lastGlueConstraints = new GridBagConstraints();
        lastGlueConstraints.gridwidth = 0;
        lastGlueConstraints.weightx = 1.0;
        JRadioButton radioButton0 = new JRadioButton();
        JRadioButton radioButton1 = new JRadioButton();
        JRadioButton radioButton2 = new JRadioButton();
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(radioButton0);
        buttonGroup.add(radioButton1);
        buttonGroup.add(radioButton2);
        panel.add((Component)new JLabel(labelText), labelConstraints);
        panel.add((Component)radioButton0, buttonConstraints);
        panel.add((Component)radioButton1, buttonConstraints);
        panel.add((Component)radioButton2, buttonConstraints);
        panel.add(Box.createGlue(), lastGlueConstraints);
        return new JRadioButton[]{radioButton0, radioButton1, radioButton2};
    }

    public void setMemberSpecification(MemberSpecification memberSpecification) {
        String annotationType = memberSpecification.annotationType;
        String name = memberSpecification.name;
        String descriptor = memberSpecification.descriptor;
        this.annotationTypeTextField.setText(annotationType == null ? "" : ClassUtil.externalType((String)annotationType));
        this.setMemberSpecificationRadioButtons(memberSpecification, 1, this.publicRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 2, this.privateRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 4, this.protectedRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 8, this.staticRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 16, this.finalRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 64, this.volatileRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 128, this.transientRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 32, this.synchronizedRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 256, this.nativeRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 1024, this.abstractRadioButtons);
        this.setMemberSpecificationRadioButtons(memberSpecification, 2048, this.strictRadioButtons);
        this.nameTextField.setText(name == null ? "*" : name);
        if (this.isField) {
            this.typeTextField.setText(descriptor == null ? "***" : ClassUtil.externalType((String)descriptor));
        } else {
            this.typeTextField.setText(descriptor == null ? "***" : ClassUtil.externalMethodReturnType((String)descriptor));
            this.argumentTypesTextField.setText(descriptor == null ? "..." : ClassUtil.externalMethodArguments((String)descriptor));
        }
    }

    public MemberSpecification getMemberSpecification() {
        String annotationType = this.annotationTypeTextField.getText();
        String name = this.nameTextField.getText();
        String type = this.typeTextField.getText();
        String arguments = this.argumentTypesTextField.getText();
        String string = annotationType = annotationType.equals("") || annotationType.equals("***") ? null : ClassUtil.internalType((String)annotationType);
        if (name.equals("") || name.equals("*")) {
            name = null;
        }
        if (this.isField) {
            type = type.equals("") || type.equals("***") ? null : ClassUtil.internalType((String)type);
        } else {
            if (type.equals("")) {
                type = "void";
            }
            type = type.equals("***") && arguments.equals("...") ? null : ClassUtil.internalMethodDescriptor((String)type, (List)ListUtil.commaSeparatedList((String)arguments));
        }
        MemberSpecification memberSpecification = new MemberSpecification(0, 0, annotationType, name, type);
        this.getMemberSpecificationRadioButtons(memberSpecification, 1, this.publicRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 2, this.privateRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 4, this.protectedRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 8, this.staticRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 16, this.finalRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 64, this.volatileRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 128, this.transientRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 32, this.synchronizedRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 256, this.nativeRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 1024, this.abstractRadioButtons);
        this.getMemberSpecificationRadioButtons(memberSpecification, 2048, this.strictRadioButtons);
        return memberSpecification;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private void setMemberSpecificationRadioButtons(MemberSpecification memberSpecification, int flag, JRadioButton[] radioButtons) {
        if (radioButtons != null) {
            int index = (memberSpecification.requiredSetAccessFlags & flag) != 0 ? 0 : ((memberSpecification.requiredUnsetAccessFlags & flag) != 0 ? 1 : 2);
            radioButtons[index].setSelected(true);
        }
    }

    private void getMemberSpecificationRadioButtons(MemberSpecification memberSpecification, int flag, JRadioButton[] radioButtons) {
        if (radioButtons != null) {
            if (radioButtons[0].isSelected()) {
                memberSpecification.requiredSetAccessFlags |= flag;
            } else if (radioButtons[1].isSelected()) {
                memberSpecification.requiredUnsetAccessFlags |= flag;
            }
        }
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(MemberSpecificationDialog.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

