/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui.splash;

import java.awt.Color;
import java.awt.Graphics;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.VariableDouble;
import proguard.gui.splash.VariableInt;

public class ShadowedSprite
implements Sprite {
    private final VariableInt xOffset;
    private final VariableInt yOffset;
    private final VariableDouble alpha;
    private final VariableInt blur;
    private final Sprite sprite;
    private float cachedAlpha = -1.0f;
    private Color cachedColor;

    public ShadowedSprite(VariableInt xOffset, VariableInt yOffset, VariableDouble alpha, VariableInt blur, Sprite sprite) {
        this.xOffset = xOffset;
        this.yOffset = yOffset;
        this.alpha = alpha;
        this.blur = blur;
        this.sprite = sprite;
    }

    public void paint(Graphics graphics, long time) {
        int b;
        double l = this.alpha.getDouble(time);
        float a = 1.0f - (float)Math.pow(1.0 - l, 1.0 / (double)((b = this.blur.getInt(time) + 1) * b));
        if (a != this.cachedAlpha) {
            this.cachedAlpha = a;
            this.cachedColor = new Color(0.0f, 0.0f, 0.0f, a);
        }
        Color actualColor = graphics.getColor();
        graphics.setColor(this.cachedColor);
        int xo = this.xOffset.getInt(time) - b / 2;
        int yo = this.yOffset.getInt(time) - b / 2;
        for (int x = 0; x < b; ++x) {
            for (int y = 0; y < b; ++y) {
                int xt = xo + x;
                int yt = yo + y;
                graphics.translate(xt, yt);
                this.sprite.paint(graphics, time);
                graphics.translate(-xt, -yt);
            }
        }
        graphics.setColor(actualColor);
        this.sprite.paint(graphics, time);
    }
}

