/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.border.Border;
import proguard.gui.GUIResources;

public class FilterDialog
extends JDialog {
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    private static final String DEFAULT_FILTER = "**";
    private static final String DEFAULT_JAR_FILTER = "**.jar";
    private static final String DEFAULT_WAR_FILTER = "**.war";
    private static final String DEFAULT_EAR_FILTER = "**.ear";
    private static final String DEFAULT_ZIP_FILTER = "**.zip";
    private final JTextField filterTextField = new JTextField(40);
    private final JTextField jarFilterTextField = new JTextField(40);
    private final JTextField warFilterTextField = new JTextField(40);
    private final JTextField earFilterTextField = new JTextField(40);
    private final JTextField zipFilterTextField = new JTextField(40);
    private int returnValue;

    public FilterDialog(JFrame owner, String explanation) {
        super((Frame)owner, true);
        this.setResizable(true);
        GridBagConstraints textConstraints = new GridBagConstraints();
        textConstraints.gridwidth = 0;
        textConstraints.fill = 2;
        textConstraints.weightx = 1.0;
        textConstraints.weighty = 1.0;
        textConstraints.anchor = 18;
        textConstraints.insets = new Insets(10, 10, 10, 10);
        GridBagConstraints labelConstraints = new GridBagConstraints();
        labelConstraints.anchor = 17;
        labelConstraints.insets = new Insets(1, 2, 1, 2);
        GridBagConstraints textFieldConstraints = new GridBagConstraints();
        textFieldConstraints.gridwidth = 0;
        textFieldConstraints.fill = 2;
        textFieldConstraints.weightx = 1.0;
        textFieldConstraints.anchor = 17;
        textFieldConstraints.insets = labelConstraints.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.weighty = 0.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = labelConstraints.insets;
        GridBagConstraints okButtonConstraints = new GridBagConstraints();
        okButtonConstraints.weightx = 1.0;
        okButtonConstraints.weighty = 1.0;
        okButtonConstraints.anchor = 14;
        okButtonConstraints.insets = new Insets(4, 4, 8, 4);
        GridBagConstraints cancelButtonConstraints = new GridBagConstraints();
        cancelButtonConstraints.gridwidth = 0;
        cancelButtonConstraints.weighty = 1.0;
        cancelButtonConstraints.anchor = 14;
        cancelButtonConstraints.insets = okButtonConstraints.insets;
        GridBagLayout layout = new GridBagLayout();
        Border etchedBorder = BorderFactory.createEtchedBorder(0);
        JTextArea explanationTextArea = new JTextArea(explanation, 3, 0);
        explanationTextArea.setOpaque(false);
        explanationTextArea.setEditable(false);
        explanationTextArea.setLineWrap(true);
        explanationTextArea.setWrapStyleWord(true);
        JLabel filterLabel = new JLabel(FilterDialog.msg("nameFilter"));
        JLabel jarFilterLabel = new JLabel(FilterDialog.msg("jarNameFilter"));
        JLabel warFilterLabel = new JLabel(FilterDialog.msg("warNameFilter"));
        JLabel earFilterLabel = new JLabel(FilterDialog.msg("earNameFilter"));
        JLabel zipFilterLabel = new JLabel(FilterDialog.msg("zipNameFilter"));
        JPanel filterPanel = new JPanel(layout);
        filterPanel.setBorder(BorderFactory.createTitledBorder(etchedBorder, FilterDialog.msg("filters")));
        filterPanel.add((Component)explanationTextArea, textConstraints);
        filterPanel.add((Component)FilterDialog.tip(filterLabel, "nameFilterTip"), labelConstraints);
        filterPanel.add((Component)FilterDialog.tip(this.filterTextField, "fileNameFilterTip"), textFieldConstraints);
        filterPanel.add((Component)FilterDialog.tip(jarFilterLabel, "jarNameFilterTip"), labelConstraints);
        filterPanel.add((Component)FilterDialog.tip(this.jarFilterTextField, "fileNameFilterTip"), textFieldConstraints);
        filterPanel.add((Component)FilterDialog.tip(warFilterLabel, "warNameFilterTip"), labelConstraints);
        filterPanel.add((Component)FilterDialog.tip(this.warFilterTextField, "fileNameFilterTip"), textFieldConstraints);
        filterPanel.add((Component)FilterDialog.tip(earFilterLabel, "earNameFilterTip"), labelConstraints);
        filterPanel.add((Component)FilterDialog.tip(this.earFilterTextField, "fileNameFilterTip"), textFieldConstraints);
        filterPanel.add((Component)FilterDialog.tip(zipFilterLabel, "zipNameFilterTip"), labelConstraints);
        filterPanel.add((Component)FilterDialog.tip(this.zipFilterTextField, "fileNameFilterTip"), textFieldConstraints);
        JButton okButton = new JButton(FilterDialog.msg("ok"));
        okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.returnValue = 0;
                FilterDialog.this.hide();
            }
        });
        JButton cancelButton = new JButton(FilterDialog.msg("cancel"));
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.hide();
            }
        });
        JPanel mainPanel = new JPanel(layout);
        mainPanel.add((Component)filterPanel, panelConstraints);
        mainPanel.add((Component)okButton, okButtonConstraints);
        mainPanel.add((Component)cancelButton, cancelButtonConstraints);
        this.getContentPane().add(mainPanel);
    }

    public void setFilter(String filter) {
        this.filterTextField.setText(filter != null ? filter : DEFAULT_FILTER);
    }

    public String getFilter() {
        String filter = this.filterTextField.getText();
        return filter.equals(DEFAULT_FILTER) ? null : filter;
    }

    public void setJarFilter(String filter) {
        this.jarFilterTextField.setText(filter != null ? filter : DEFAULT_JAR_FILTER);
    }

    public String getJarFilter() {
        String filter = this.jarFilterTextField.getText();
        return filter.equals(DEFAULT_JAR_FILTER) ? null : filter;
    }

    public void setWarFilter(String filter) {
        this.warFilterTextField.setText(filter != null ? filter : DEFAULT_WAR_FILTER);
    }

    public String getWarFilter() {
        String filter = this.warFilterTextField.getText();
        return filter.equals(DEFAULT_WAR_FILTER) ? null : filter;
    }

    public void setEarFilter(String filter) {
        this.earFilterTextField.setText(filter != null ? filter : DEFAULT_EAR_FILTER);
    }

    public String getEarFilter() {
        String filter = this.earFilterTextField.getText();
        return filter.equals(DEFAULT_EAR_FILTER) ? null : filter;
    }

    public void setZipFilter(String filter) {
        this.zipFilterTextField.setText(filter != null ? filter : DEFAULT_ZIP_FILTER);
    }

    public String getZipFilter() {
        String filter = this.zipFilterTextField.getText();
        return filter.equals(DEFAULT_ZIP_FILTER) ? null : filter;
    }

    public int showDialog() {
        this.returnValue = 1;
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
        this.show();
        return this.returnValue;
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(FilterDialog.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

