/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.KeepClassSpecification;
import proguard.ParseException;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassPathPanel;
import proguard.gui.ClassSpecificationsPanel;
import proguard.gui.ExtensionFileFilter;
import proguard.gui.GUIResources;
import proguard.gui.KeepSpecificationsPanel;
import proguard.gui.OptimizationsDialog;
import proguard.gui.ProGuardRunnable;
import proguard.gui.ReTraceRunnable;
import proguard.gui.SwingUtil;
import proguard.gui.TabbedPane;
import proguard.gui.TextAreaOutputStream;
import proguard.gui.splash.ColorSprite;
import proguard.gui.splash.CompositeSprite;
import proguard.gui.splash.ConstantColor;
import proguard.gui.splash.ConstantDouble;
import proguard.gui.splash.ConstantFont;
import proguard.gui.splash.ConstantInt;
import proguard.gui.splash.ConstantString;
import proguard.gui.splash.FontSprite;
import proguard.gui.splash.LinearInt;
import proguard.gui.splash.LinearTiming;
import proguard.gui.splash.ShadowedSprite;
import proguard.gui.splash.SmoothTiming;
import proguard.gui.splash.SplashPanel;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.TextSprite;
import proguard.gui.splash.TypeWriterString;
import proguard.util.ListUtil;

public class ProGuardGUI
extends JFrame {
    private static final String NO_SPLASH_OPTION = "-nosplash";
    private static final String TITLE_IMAGE_FILE = "vtitle.png";
    private static final String BOILERPLATE_CONFIGURATION = "boilerplate.pro";
    private static final String DEFAULT_CONFIGURATION = "default.pro";
    private static final String OPTIMIZATIONS_DEFAULT = "*";
    private static final String KEEP_ATTRIBUTE_DEFAULT = "Exceptions,InnerClasses,Signature,Deprecated,SourceFile,LineNumberTable,LocalVariable*Table,*Annotation*,Synthetic,EnclosingMethod";
    private static final String SOURCE_FILE_ATTRIBUTE_DEFAULT = "SourceFile";
    private static final String ADAPT_RESOURCE_FILE_NAMES_DEFAULT = "**.properties";
    private static final String ADAPT_RESOURCE_FILE_CONTENTS_DEFAULT = "**.properties,META-INF/MANIFEST.MF";
    private static final Border BORDER = BorderFactory.createEtchedBorder(0);
    static boolean systemOutRedirected;
    private final JFileChooser configurationChooser = new JFileChooser("");
    private final JFileChooser fileChooser = new JFileChooser("");
    private final SplashPanel splashPanel;
    private final ClassPathPanel programPanel = new ClassPathPanel(this, true);
    private final ClassPathPanel libraryPanel = new ClassPathPanel(this, false);
    private KeepClassSpecification[] boilerplateKeep;
    private final JCheckBox[] boilerplateKeepCheckBoxes;
    private final JTextField[] boilerplateKeepTextFields;
    private final KeepSpecificationsPanel additionalKeepPanel = new KeepSpecificationsPanel(this, true, false, false, false, false);
    private KeepClassSpecification[] boilerplateKeepNames;
    private final JCheckBox[] boilerplateKeepNamesCheckBoxes;
    private final JTextField[] boilerplateKeepNamesTextFields;
    private final KeepSpecificationsPanel additionalKeepNamesPanel = new KeepSpecificationsPanel(this, true, false, true, false, false);
    private ClassSpecification[] boilerplateNoSideEffectMethods;
    private final JCheckBox[] boilerplateNoSideEffectMethodCheckBoxes;
    private final ClassSpecificationsPanel additionalNoSideEffectsPanel = new ClassSpecificationsPanel(this, false);
    private final ClassSpecificationsPanel whyAreYouKeepingPanel = new ClassSpecificationsPanel(this, false);
    private final JCheckBox shrinkCheckBox = new JCheckBox(ProGuardGUI.msg("shrink"));
    private final JCheckBox printUsageCheckBox = new JCheckBox(ProGuardGUI.msg("printUsage"));
    private final JCheckBox optimizeCheckBox = new JCheckBox(ProGuardGUI.msg("optimize"));
    private final JCheckBox allowAccessModificationCheckBox = new JCheckBox(ProGuardGUI.msg("allowAccessModification"));
    private final JCheckBox mergeInterfacesAggressivelyCheckBox = new JCheckBox(ProGuardGUI.msg("mergeInterfacesAggressively"));
    private final JLabel optimizationsLabel = new JLabel(ProGuardGUI.msg("optimizations"));
    private final JLabel optimizationPassesLabel = new JLabel(ProGuardGUI.msg("optimizationPasses"));
    private final JSpinner optimizationPassesSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
    private final JCheckBox obfuscateCheckBox = new JCheckBox(ProGuardGUI.msg("obfuscate"));
    private final JCheckBox printMappingCheckBox = new JCheckBox(ProGuardGUI.msg("printMapping"));
    private final JCheckBox applyMappingCheckBox = new JCheckBox(ProGuardGUI.msg("applyMapping"));
    private final JCheckBox obfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("obfuscationDictionary"));
    private final JCheckBox classObfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("classObfuscationDictionary"));
    private final JCheckBox packageObfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("packageObfuscationDictionary"));
    private final JCheckBox overloadAggressivelyCheckBox = new JCheckBox(ProGuardGUI.msg("overloadAggressively"));
    private final JCheckBox useUniqueClassMemberNamesCheckBox = new JCheckBox(ProGuardGUI.msg("useUniqueClassMemberNames"));
    private final JCheckBox useMixedCaseClassNamesCheckBox = new JCheckBox(ProGuardGUI.msg("useMixedCaseClassNames"));
    private final JCheckBox keepPackageNamesCheckBox = new JCheckBox(ProGuardGUI.msg("keepPackageNames"));
    private final JCheckBox flattenPackageHierarchyCheckBox = new JCheckBox(ProGuardGUI.msg("flattenPackageHierarchy"));
    private final JCheckBox repackageClassesCheckBox = new JCheckBox(ProGuardGUI.msg("repackageClasses"));
    private final JCheckBox keepAttributesCheckBox = new JCheckBox(ProGuardGUI.msg("keepAttributes"));
    private final JCheckBox keepParameterNamesCheckBox = new JCheckBox(ProGuardGUI.msg("keepParameterNames"));
    private final JCheckBox newSourceFileAttributeCheckBox = new JCheckBox(ProGuardGUI.msg("renameSourceFileAttribute"));
    private final JCheckBox adaptClassStringsCheckBox = new JCheckBox(ProGuardGUI.msg("adaptClassStrings"));
    private final JCheckBox adaptResourceFileNamesCheckBox = new JCheckBox(ProGuardGUI.msg("adaptResourceFileNames"));
    private final JCheckBox adaptResourceFileContentsCheckBox = new JCheckBox(ProGuardGUI.msg("adaptResourceFileContents"));
    private final JCheckBox preverifyCheckBox = new JCheckBox(ProGuardGUI.msg("preverify"));
    private final JCheckBox microEditionCheckBox = new JCheckBox(ProGuardGUI.msg("microEdition"));
    private final JCheckBox targetCheckBox = new JCheckBox(ProGuardGUI.msg("target"));
    private final JComboBox targetComboBox = new JComboBox<Object>(ListUtil.commaSeparatedList((String)ProGuardGUI.msg("targets")).toArray());
    private final JCheckBox verboseCheckBox = new JCheckBox(ProGuardGUI.msg("verbose"));
    private final JCheckBox noteCheckBox = new JCheckBox(ProGuardGUI.msg("note"));
    private final JCheckBox warnCheckBox = new JCheckBox(ProGuardGUI.msg("warn"));
    private final JCheckBox ignoreWarningsCheckBox = new JCheckBox(ProGuardGUI.msg("ignoreWarnings"));
    private final JCheckBox skipNonPublicLibraryClassesCheckBox = new JCheckBox(ProGuardGUI.msg("skipNonPublicLibraryClasses"));
    private final JCheckBox skipNonPublicLibraryClassMembersCheckBox = new JCheckBox(ProGuardGUI.msg("skipNonPublicLibraryClassMembers"));
    private final JCheckBox keepDirectoriesCheckBox = new JCheckBox(ProGuardGUI.msg("keepDirectories"));
    private final JCheckBox forceProcessingCheckBox = new JCheckBox(ProGuardGUI.msg("forceProcessing"));
    private final JCheckBox printSeedsCheckBox = new JCheckBox(ProGuardGUI.msg("printSeeds"));
    private final JCheckBox printConfigurationCheckBox = new JCheckBox(ProGuardGUI.msg("printConfiguration"));
    private final JCheckBox dumpCheckBox = new JCheckBox(ProGuardGUI.msg("dump"));
    private final JTextField printUsageTextField = new JTextField(40);
    private final JTextField optimizationsTextField = new JTextField(40);
    private final JTextField printMappingTextField = new JTextField(40);
    private final JTextField applyMappingTextField = new JTextField(40);
    private final JTextField obfuscationDictionaryTextField = new JTextField(40);
    private final JTextField classObfuscationDictionaryTextField = new JTextField(40);
    private final JTextField packageObfuscationDictionaryTextField = new JTextField(40);
    private final JTextField keepPackageNamesTextField = new JTextField(40);
    private final JTextField flattenPackageHierarchyTextField = new JTextField(40);
    private final JTextField repackageClassesTextField = new JTextField(40);
    private final JTextField keepAttributesTextField = new JTextField(40);
    private final JTextField newSourceFileAttributeTextField = new JTextField(40);
    private final JTextField adaptClassStringsTextField = new JTextField(40);
    private final JTextField adaptResourceFileNamesTextField = new JTextField(40);
    private final JTextField adaptResourceFileContentsTextField = new JTextField(40);
    private final JTextField noteTextField = new JTextField(40);
    private final JTextField warnTextField = new JTextField(40);
    private final JTextField keepDirectoriesTextField = new JTextField(40);
    private final JTextField printSeedsTextField = new JTextField(40);
    private final JTextField printConfigurationTextField = new JTextField(40);
    private final JTextField dumpTextField = new JTextField(40);
    private final JTextArea consoleTextArea = new JTextArea(ProGuardGUI.msg("processingInfo"), 3, 40);
    private final JCheckBox reTraceVerboseCheckBox = new JCheckBox(ProGuardGUI.msg("verbose"));
    private final JTextField reTraceMappingTextField = new JTextField(40);
    private final JTextArea stackTraceTextArea = new JTextArea(3, 40);
    private final JTextArea reTraceTextArea = new JTextArea(ProGuardGUI.msg("reTraceInfo"), 3, 40);

    public ProGuardGUI() {
        this.setTitle("ProGuard");
        this.setDefaultCloseOperation(3);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints constraintsStretch = new GridBagConstraints();
        constraintsStretch.fill = 2;
        constraintsStretch.weightx = 1.0;
        constraintsStretch.anchor = 17;
        constraintsStretch.insets = constraints.insets;
        GridBagConstraints constraintsLast = new GridBagConstraints();
        constraintsLast.gridwidth = 0;
        constraintsLast.anchor = 17;
        constraintsLast.insets = constraints.insets;
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraints.insets;
        GridBagConstraints splashPanelConstraints = new GridBagConstraints();
        splashPanelConstraints.gridwidth = 0;
        splashPanelConstraints.fill = 1;
        splashPanelConstraints.weightx = 1.0;
        splashPanelConstraints.weighty = 0.02;
        splashPanelConstraints.anchor = 18;
        GridBagConstraints welcomePaneConstraints = new GridBagConstraints();
        welcomePaneConstraints.gridwidth = 0;
        welcomePaneConstraints.fill = 0;
        welcomePaneConstraints.weightx = 1.0;
        welcomePaneConstraints.weighty = 0.01;
        welcomePaneConstraints.anchor = 10;
        welcomePaneConstraints.insets = new Insets(20, 40, 20, 40);
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraints.insets;
        GridBagConstraints stretchPanelConstraints = new GridBagConstraints();
        stretchPanelConstraints.gridwidth = 0;
        stretchPanelConstraints.fill = 1;
        stretchPanelConstraints.weightx = 1.0;
        stretchPanelConstraints.weighty = 1.0;
        stretchPanelConstraints.anchor = 18;
        stretchPanelConstraints.insets = constraints.insets;
        GridBagConstraints glueConstraints = new GridBagConstraints();
        glueConstraints.fill = 1;
        glueConstraints.weightx = 0.01;
        glueConstraints.weighty = 0.01;
        glueConstraints.anchor = 18;
        glueConstraints.insets = constraints.insets;
        GridBagConstraints bottomButtonConstraints = new GridBagConstraints();
        bottomButtonConstraints.anchor = 14;
        bottomButtonConstraints.insets = new Insets(2, 2, 4, 6);
        bottomButtonConstraints.ipadx = 10;
        bottomButtonConstraints.ipady = 2;
        GridBagConstraints lastBottomButtonConstraints = new GridBagConstraints();
        lastBottomButtonConstraints.gridwidth = 0;
        lastBottomButtonConstraints.anchor = 14;
        lastBottomButtonConstraints.insets = bottomButtonConstraints.insets;
        lastBottomButtonConstraints.ipadx = bottomButtonConstraints.ipadx;
        lastBottomButtonConstraints.ipady = bottomButtonConstraints.ipady;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            lastBottomButtonConstraints.insets = new Insets(2, 2, 4, 22);
        }
        GridBagLayout layout = new GridBagLayout();
        this.configurationChooser.addChoosableFileFilter(new ExtensionFileFilter(ProGuardGUI.msg("proExtension"), new String[]{".pro"}));
        CompositeSprite splash = new CompositeSprite(new Sprite[]{new ColorSprite(new ConstantColor(Color.gray), new FontSprite(new ConstantFont(new Font("sansserif", 1, 90)), new TextSprite(new ConstantString("ProGuard"), new ConstantInt(160), new LinearInt(-10, 120, new SmoothTiming(500L, 1000L))))), new ColorSprite(new ConstantColor(Color.white), new FontSprite(new ConstantFont(new Font("sansserif", 1, 45)), new ShadowedSprite(new ConstantInt(3), new ConstantInt(3), new ConstantDouble(0.4), new ConstantInt(1), new CompositeSprite(new Sprite[]{new TextSprite(new ConstantString(ProGuardGUI.msg("shrinking")), new LinearInt(1000, 60, new SmoothTiming(1000L, 2000L)), new ConstantInt(70)), new TextSprite(new ConstantString(ProGuardGUI.msg("optimization")), new LinearInt(1000, 400, new SmoothTiming(1500L, 2500L)), new ConstantInt(60)), new TextSprite(new ConstantString(ProGuardGUI.msg("obfuscation")), new LinearInt(1000, 10, new SmoothTiming(2000L, 3000L)), new ConstantInt(145)), new TextSprite(new ConstantString(ProGuardGUI.msg("preverification")), new LinearInt(1000, 350, new SmoothTiming(2500L, 3500L)), new ConstantInt(140)), new FontSprite(new ConstantFont(new Font("sansserif", 1, 30)), new TextSprite(new TypeWriterString(ProGuardGUI.msg("developed"), new LinearTiming(3500L, 5500L)), new ConstantInt(250), new ConstantInt(200)))}))))});
        this.splashPanel = new SplashPanel(splash, 0.5, 5500L);
        this.splashPanel.setPreferredSize(new Dimension(0, 200));
        JEditorPane welcomePane = new JEditorPane("text/html", ProGuardGUI.msg("proGuardInfo"));
        welcomePane.setPreferredSize(new Dimension(640, 350));
        welcomePane.putClientProperty("JEditorPane.honorDisplayProperties", Boolean.TRUE);
        welcomePane.setOpaque(false);
        welcomePane.setEditable(false);
        welcomePane.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.addBorder(welcomePane, "welcome");
        JPanel proGuardPanel = new JPanel(layout);
        proGuardPanel.add((Component)this.splashPanel, splashPanelConstraints);
        proGuardPanel.add((Component)welcomePane, welcomePaneConstraints);
        this.programPanel.addCopyToPanelButton("moveToLibraries", "moveToLibrariesTip", this.libraryPanel);
        this.libraryPanel.addCopyToPanelButton("moveToProgram", "moveToProgramTip", this.programPanel);
        ArrayList panelButtons = new ArrayList();
        panelButtons.addAll(this.programPanel.getButtons());
        panelButtons.addAll(this.libraryPanel.getButtons());
        this.setCommonPreferredSize(panelButtons);
        this.addBorder(this.programPanel, "programJars");
        this.addBorder(this.libraryPanel, "libraryJars");
        JPanel inputOutputPanel = new JPanel(layout);
        inputOutputPanel.add((Component)ProGuardGUI.tip(this.programPanel, "programJarsTip"), stretchPanelConstraints);
        inputOutputPanel.add((Component)ProGuardGUI.tip(this.libraryPanel, "libraryJarsTip"), stretchPanelConstraints);
        this.loadBoilerplateConfiguration();
        this.boilerplateKeepCheckBoxes = new JCheckBox[this.boilerplateKeep.length];
        this.boilerplateKeepTextFields = new JTextField[this.boilerplateKeep.length];
        JButton printUsageBrowseButton = this.createBrowseButton(this.printUsageTextField, ProGuardGUI.msg("selectUsageFile"));
        JPanel shrinkingOptionsPanel = new JPanel(layout);
        this.addBorder(shrinkingOptionsPanel, "options");
        shrinkingOptionsPanel.add((Component)ProGuardGUI.tip(this.shrinkCheckBox, "shrinkTip"), constraintsLastStretch);
        shrinkingOptionsPanel.add((Component)ProGuardGUI.tip(this.printUsageCheckBox, "printUsageTip"), constraints);
        shrinkingOptionsPanel.add((Component)ProGuardGUI.tip(this.printUsageTextField, "outputFileTip"), constraintsStretch);
        shrinkingOptionsPanel.add((Component)ProGuardGUI.tip(printUsageBrowseButton, "selectUsageFile"), constraintsLast);
        JPanel shrinkingPanel = new JPanel(layout);
        shrinkingPanel.add((Component)shrinkingOptionsPanel, panelConstraints);
        this.addClassSpecifications(this.extractClassSpecifications(this.boilerplateKeep), shrinkingPanel, this.boilerplateKeepCheckBoxes, this.boilerplateKeepTextFields);
        this.addBorder(this.additionalKeepPanel, "keepAdditional");
        shrinkingPanel.add((Component)ProGuardGUI.tip(this.additionalKeepPanel, "keepAdditionalTip"), stretchPanelConstraints);
        this.boilerplateKeepNamesCheckBoxes = new JCheckBox[this.boilerplateKeepNames.length];
        this.boilerplateKeepNamesTextFields = new JTextField[this.boilerplateKeepNames.length];
        JButton printMappingBrowseButton = this.createBrowseButton(this.printMappingTextField, ProGuardGUI.msg("selectPrintMappingFile"));
        JButton applyMappingBrowseButton = this.createBrowseButton(this.applyMappingTextField, ProGuardGUI.msg("selectApplyMappingFile"));
        JButton obfucationDictionaryBrowseButton = this.createBrowseButton(this.obfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JButton classObfucationDictionaryBrowseButton = this.createBrowseButton(this.classObfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JButton packageObfucationDictionaryBrowseButton = this.createBrowseButton(this.packageObfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JPanel obfuscationOptionsPanel = new JPanel(layout);
        this.addBorder(obfuscationOptionsPanel, "options");
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.obfuscateCheckBox, "obfuscateTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.printMappingCheckBox, "printMappingTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.printMappingTextField, "outputFileTip"), constraintsStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(printMappingBrowseButton, "selectPrintMappingFile"), constraintsLast);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.applyMappingCheckBox, "applyMappingTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.applyMappingTextField, "inputFileTip"), constraintsStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(applyMappingBrowseButton, "selectApplyMappingFile"), constraintsLast);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.obfuscationDictionaryCheckBox, "obfuscationDictionaryTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.obfuscationDictionaryTextField, "inputFileTip"), constraintsStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(obfucationDictionaryBrowseButton, "selectObfuscationDictionaryFile"), constraintsLast);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.classObfuscationDictionaryCheckBox, "classObfuscationDictionaryTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.classObfuscationDictionaryTextField, "inputFileTip"), constraintsStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(classObfucationDictionaryBrowseButton, "selectObfuscationDictionaryFile"), constraintsLast);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.packageObfuscationDictionaryCheckBox, "packageObfuscationDictionaryTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.packageObfuscationDictionaryTextField, "inputFileTip"), constraintsStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(packageObfucationDictionaryBrowseButton, "selectObfuscationDictionaryFile"), constraintsLast);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.overloadAggressivelyCheckBox, "overloadAggressivelyTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.useUniqueClassMemberNamesCheckBox, "useUniqueClassMemberNamesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.useMixedCaseClassNamesCheckBox, "useMixedCaseClassNamesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.keepPackageNamesCheckBox, "keepPackageNamesTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.keepPackageNamesTextField, "packageNamesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.flattenPackageHierarchyCheckBox, "flattenPackageHierarchyTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.flattenPackageHierarchyTextField, "packageTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.repackageClassesCheckBox, "repackageClassesTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.repackageClassesTextField, "packageTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.keepAttributesCheckBox, "keepAttributesTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.keepAttributesTextField, "attributesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.keepParameterNamesCheckBox, "keepParameterNamesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.newSourceFileAttributeCheckBox, "renameSourceFileAttributeTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.newSourceFileAttributeTextField, "sourceFileAttributeTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptClassStringsCheckBox, "adaptClassStringsTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptClassStringsTextField, "classNamesTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptResourceFileNamesCheckBox, "adaptResourceFileNamesTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptResourceFileNamesTextField, "fileNameFilterTip"), constraintsLastStretch);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptResourceFileContentsCheckBox, "adaptResourceFileContentsTip"), constraints);
        obfuscationOptionsPanel.add((Component)ProGuardGUI.tip(this.adaptResourceFileContentsTextField, "fileNameFilterTip"), constraintsLastStretch);
        JPanel obfuscationPanel = new JPanel(layout);
        obfuscationPanel.add((Component)obfuscationOptionsPanel, panelConstraints);
        this.addClassSpecifications(this.extractClassSpecifications(this.boilerplateKeepNames), obfuscationPanel, this.boilerplateKeepNamesCheckBoxes, this.boilerplateKeepNamesTextFields);
        this.addBorder(this.additionalKeepNamesPanel, "keepNamesAdditional");
        obfuscationPanel.add((Component)ProGuardGUI.tip(this.additionalKeepNamesPanel, "keepNamesAdditionalTip"), stretchPanelConstraints);
        this.boilerplateNoSideEffectMethodCheckBoxes = new JCheckBox[this.boilerplateNoSideEffectMethods.length];
        JPanel optimizationOptionsPanel = new JPanel(layout);
        this.addBorder(optimizationOptionsPanel, "options");
        JButton optimizationsButton = this.createOptimizationsButton(this.optimizationsTextField);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.optimizeCheckBox, "optimizeTip"), constraintsLastStretch);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.allowAccessModificationCheckBox, "allowAccessModificationTip"), constraintsLastStretch);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.mergeInterfacesAggressivelyCheckBox, "mergeInterfacesAggressivelyTip"), constraintsLastStretch);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.optimizationsLabel, "optimizationsTip"), constraints);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.optimizationsTextField, "optimizationsFilterTip"), constraintsStretch);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(optimizationsButton, "optimizationsSelectTip"), constraintsLast);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.optimizationPassesLabel, "optimizationPassesTip"), constraints);
        optimizationOptionsPanel.add((Component)ProGuardGUI.tip(this.optimizationPassesSpinner, "optimizationPassesTip"), constraintsLast);
        JPanel optimizationPanel = new JPanel(layout);
        optimizationPanel.add((Component)optimizationOptionsPanel, panelConstraints);
        this.addClassSpecifications(this.boilerplateNoSideEffectMethods, optimizationPanel, this.boilerplateNoSideEffectMethodCheckBoxes, null);
        this.addBorder(this.additionalNoSideEffectsPanel, "assumeNoSideEffectsAdditional");
        optimizationPanel.add((Component)ProGuardGUI.tip(this.additionalNoSideEffectsPanel, "assumeNoSideEffectsAdditionalTip"), stretchPanelConstraints);
        JPanel preverificationOptionsPanel = new JPanel(layout);
        this.addBorder(preverificationOptionsPanel, "preverificationAndTargeting");
        preverificationOptionsPanel.add((Component)ProGuardGUI.tip(this.preverifyCheckBox, "preverifyTip"), constraintsLastStretch);
        preverificationOptionsPanel.add((Component)ProGuardGUI.tip(this.microEditionCheckBox, "microEditionTip"), constraintsLastStretch);
        preverificationOptionsPanel.add((Component)ProGuardGUI.tip(this.targetCheckBox, "targetTip"), constraints);
        preverificationOptionsPanel.add((Component)ProGuardGUI.tip(this.targetComboBox, "targetTip"), constraintsLast);
        JButton printSeedsBrowseButton = this.createBrowseButton(this.printSeedsTextField, ProGuardGUI.msg("selectSeedsFile"));
        JButton printConfigurationBrowseButton = this.createBrowseButton(this.printConfigurationTextField, ProGuardGUI.msg("selectConfigurationFile"));
        JButton dumpBrowseButton = this.createBrowseButton(this.dumpTextField, ProGuardGUI.msg("selectDumpFile"));
        this.targetComboBox.setSelectedIndex(this.targetComboBox.getItemCount() - 1);
        JPanel consistencyPanel = new JPanel(layout);
        this.addBorder(consistencyPanel, "consistencyAndCorrectness");
        consistencyPanel.add((Component)ProGuardGUI.tip(this.verboseCheckBox, "verboseTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.noteCheckBox, "noteTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.noteTextField, "noteFilterTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.warnCheckBox, "warnTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.warnTextField, "warnFilterTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.ignoreWarningsCheckBox, "ignoreWarningsTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.skipNonPublicLibraryClassesCheckBox, "skipNonPublicLibraryClassesTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.skipNonPublicLibraryClassMembersCheckBox, "skipNonPublicLibraryClassMembersTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.keepDirectoriesCheckBox, "keepDirectoriesTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.keepDirectoriesTextField, "directoriesTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.forceProcessingCheckBox, "forceProcessingTip"), constraintsLastStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.printSeedsCheckBox, "printSeedsTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.printSeedsTextField, "outputFileTip"), constraintsStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(printSeedsBrowseButton, "selectSeedsFile"), constraintsLast);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.printConfigurationCheckBox, "printConfigurationTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.printConfigurationTextField, "outputFileTip"), constraintsStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(printConfigurationBrowseButton, "selectConfigurationFile"), constraintsLast);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.dumpCheckBox, "dumpTip"), constraints);
        consistencyPanel.add((Component)ProGuardGUI.tip(this.dumpTextField, "outputFileTip"), constraintsStretch);
        consistencyPanel.add((Component)ProGuardGUI.tip(dumpBrowseButton, "selectDumpFile"), constraintsLast);
        this.setCommonPreferredSize(Arrays.asList(this.printMappingCheckBox, this.applyMappingCheckBox, this.flattenPackageHierarchyCheckBox, this.repackageClassesCheckBox, this.newSourceFileAttributeCheckBox));
        JPanel optionsPanel = new JPanel(layout);
        optionsPanel.add((Component)preverificationOptionsPanel, panelConstraints);
        optionsPanel.add((Component)consistencyPanel, panelConstraints);
        this.addBorder(this.whyAreYouKeepingPanel, "whyAreYouKeeping");
        optionsPanel.add((Component)ProGuardGUI.tip(this.whyAreYouKeepingPanel, "whyAreYouKeepingTip"), stretchPanelConstraints);
        this.consoleTextArea.setOpaque(false);
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setLineWrap(false);
        this.consoleTextArea.setWrapStyleWord(false);
        JScrollPane consoleScrollPane = new JScrollPane(this.consoleTextArea);
        consoleScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(consoleScrollPane, "processingConsole");
        JPanel processPanel = new JPanel(layout);
        processPanel.add((Component)consoleScrollPane, stretchPanelConstraints);
        JButton loadButton = new JButton(ProGuardGUI.msg("loadConfiguration"));
        loadButton.addActionListener(new MyLoadConfigurationActionListener());
        JButton viewButton = new JButton(ProGuardGUI.msg("viewConfiguration"));
        viewButton.addActionListener(new MyViewConfigurationActionListener());
        JButton saveButton = new JButton(ProGuardGUI.msg("saveConfiguration"));
        saveButton.addActionListener(new MySaveConfigurationActionListener());
        JButton processButton = new JButton(ProGuardGUI.msg("process"));
        processButton.addActionListener(new MyProcessActionListener());
        JPanel reTraceSettingsPanel = new JPanel(layout);
        this.addBorder(reTraceSettingsPanel, "reTraceSettings");
        JButton reTraceMappingBrowseButton = this.createBrowseButton(this.reTraceMappingTextField, ProGuardGUI.msg("selectApplyMappingFile"));
        JLabel reTraceMappingLabel = new JLabel(ProGuardGUI.msg("mappingFile"));
        reTraceMappingLabel.setForeground(this.reTraceVerboseCheckBox.getForeground());
        reTraceSettingsPanel.add((Component)ProGuardGUI.tip(this.reTraceVerboseCheckBox, "verboseTip"), constraintsLastStretch);
        reTraceSettingsPanel.add((Component)ProGuardGUI.tip(reTraceMappingLabel, "mappingFileTip"), constraints);
        reTraceSettingsPanel.add((Component)ProGuardGUI.tip(this.reTraceMappingTextField, "inputFileTip"), constraintsStretch);
        reTraceSettingsPanel.add((Component)ProGuardGUI.tip(reTraceMappingBrowseButton, "selectApplyMappingFile"), constraintsLast);
        this.stackTraceTextArea.setOpaque(true);
        this.stackTraceTextArea.setEditable(true);
        this.stackTraceTextArea.setLineWrap(false);
        this.stackTraceTextArea.setWrapStyleWord(true);
        JScrollPane stackTraceScrollPane = new JScrollPane(this.stackTraceTextArea);
        this.addBorder(stackTraceScrollPane, "obfuscatedStackTrace");
        this.reTraceTextArea.setOpaque(false);
        this.reTraceTextArea.setEditable(false);
        this.reTraceTextArea.setLineWrap(true);
        this.reTraceTextArea.setWrapStyleWord(true);
        JScrollPane reTraceScrollPane = new JScrollPane(this.reTraceTextArea);
        reTraceScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(reTraceScrollPane, "deobfuscatedStackTrace");
        JPanel reTracePanel = new JPanel(layout);
        reTracePanel.add((Component)reTraceSettingsPanel, panelConstraints);
        reTracePanel.add((Component)ProGuardGUI.tip(stackTraceScrollPane, "obfuscatedStackTraceTip"), panelConstraints);
        reTracePanel.add((Component)reTraceScrollPane, stretchPanelConstraints);
        JButton loadStackTraceButton = new JButton(ProGuardGUI.msg("loadStackTrace"));
        loadStackTraceButton.addActionListener(new MyLoadStackTraceActionListener());
        JButton reTraceButton = new JButton(ProGuardGUI.msg("reTrace"));
        reTraceButton.addActionListener(new MyReTraceActionListener());
        TabbedPane tabs = new TabbedPane();
        tabs.add(ProGuardGUI.msg("proGuardTab"), proGuardPanel);
        tabs.add(ProGuardGUI.msg("inputOutputTab"), inputOutputPanel);
        tabs.add(ProGuardGUI.msg("shrinkingTab"), shrinkingPanel);
        tabs.add(ProGuardGUI.msg("obfuscationTab"), obfuscationPanel);
        tabs.add(ProGuardGUI.msg("optimizationTab"), optimizationPanel);
        tabs.add(ProGuardGUI.msg("informationTab"), optionsPanel);
        tabs.add(ProGuardGUI.msg("processTab"), processPanel);
        tabs.add(ProGuardGUI.msg("reTraceTab"), reTracePanel);
        tabs.addImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(TITLE_IMAGE_FILE)));
        proGuardPanel.add(Box.createGlue(), glueConstraints);
        proGuardPanel.add((Component)ProGuardGUI.tip(loadButton, "loadConfigurationTip"), bottomButtonConstraints);
        proGuardPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        inputOutputPanel.add(Box.createGlue(), glueConstraints);
        inputOutputPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        inputOutputPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        shrinkingPanel.add(Box.createGlue(), glueConstraints);
        shrinkingPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        shrinkingPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        obfuscationPanel.add(Box.createGlue(), glueConstraints);
        obfuscationPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        obfuscationPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        optimizationPanel.add(Box.createGlue(), glueConstraints);
        optimizationPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        optimizationPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        optionsPanel.add(Box.createGlue(), glueConstraints);
        optionsPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        optionsPanel.add((Component)this.createNextButton(tabs), lastBottomButtonConstraints);
        processPanel.add(Box.createGlue(), glueConstraints);
        processPanel.add((Component)this.createPreviousButton(tabs), bottomButtonConstraints);
        processPanel.add((Component)ProGuardGUI.tip(viewButton, "viewConfigurationTip"), bottomButtonConstraints);
        processPanel.add((Component)ProGuardGUI.tip(saveButton, "saveConfigurationTip"), bottomButtonConstraints);
        processPanel.add((Component)ProGuardGUI.tip(processButton, "processTip"), lastBottomButtonConstraints);
        reTracePanel.add(Box.createGlue(), glueConstraints);
        reTracePanel.add((Component)ProGuardGUI.tip(loadStackTraceButton, "loadStackTraceTip"), bottomButtonConstraints);
        reTracePanel.add((Component)ProGuardGUI.tip(reTraceButton, "reTraceTip"), lastBottomButtonConstraints);
        this.loadConfiguration(this.getClass().getResource(DEFAULT_CONFIGURATION));
        this.getContentPane().add(tabs);
    }

    public void startSplash() {
        this.splashPanel.start();
    }

    public void skipSplash() {
        this.splashPanel.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBoilerplateConfiguration() {
        try {
            ConfigurationParser parser = new ConfigurationParser(this.getClass().getResource(BOILERPLATE_CONFIGURATION));
            Configuration configuration = new Configuration();
            try {
                parser.parse(configuration);
                this.boilerplateKeep = this.extractKeepSpecifications(configuration.keep, false, false);
                this.boilerplateKeepNames = this.extractKeepSpecifications(configuration.keep, true, false);
                this.boilerplateNoSideEffectMethods = new ClassSpecification[configuration.assumeNoSideEffects.size()];
                configuration.assumeNoSideEffects.toArray(this.boilerplateNoSideEffectMethods);
            }
            finally {
                parser.close();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private KeepClassSpecification[] extractKeepSpecifications(List keepSpecifications, boolean allowShrinking, boolean allowObfuscation) {
        ArrayList<KeepClassSpecification> matches = new ArrayList<KeepClassSpecification>();
        for (int index = 0; index < keepSpecifications.size(); ++index) {
            KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepSpecifications.get(index);
            if (keepClassSpecification.allowShrinking != allowShrinking || keepClassSpecification.allowObfuscation != allowObfuscation) continue;
            matches.add(keepClassSpecification);
        }
        KeepClassSpecification[] matchingKeepClassSpecifications = new KeepClassSpecification[matches.size()];
        matches.toArray(matchingKeepClassSpecifications);
        return matchingKeepClassSpecifications;
    }

    private ClassSpecification[] extractClassSpecifications(KeepClassSpecification[] keepClassSpecifications) {
        ClassSpecification[] classSpecifications = new ClassSpecification[keepClassSpecifications.length];
        for (int index = 0; index < classSpecifications.length; ++index) {
            classSpecifications[index] = keepClassSpecifications[index];
        }
        return classSpecifications;
    }

    private void addClassSpecifications(ClassSpecification[] boilerplateClassSpecifications, JPanel classSpecificationsPanel, JCheckBox[] boilerplateCheckBoxes, JTextField[] boilerplateTextFields) {
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.anchor = 17;
        constraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints constraintsLastStretch = new GridBagConstraints();
        constraintsLastStretch.gridwidth = 0;
        constraintsLastStretch.fill = 2;
        constraintsLastStretch.weightx = 1.0;
        constraintsLastStretch.anchor = 17;
        constraintsLastStretch.insets = constraints.insets;
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.gridwidth = 0;
        panelConstraints.fill = 2;
        panelConstraints.weightx = 1.0;
        panelConstraints.anchor = 18;
        panelConstraints.insets = constraints.insets;
        GridBagLayout layout = new GridBagLayout();
        String lastPanelName = null;
        JPanel keepSubpanel = null;
        for (int index = 0; index < boilerplateClassSpecifications.length; ++index) {
            String comments = boilerplateClassSpecifications[index].comments;
            int dashIndex = comments.indexOf(45);
            int periodIndex = comments.indexOf(46, dashIndex);
            String panelName = comments.substring(0, dashIndex).trim();
            String optionName = comments.substring(dashIndex + 1, periodIndex).replace('_', '.').trim();
            String toolTip = comments.substring(periodIndex + 1);
            if (keepSubpanel == null || !panelName.equals(lastPanelName)) {
                keepSubpanel = new JPanel(layout);
                keepSubpanel.setBorder(BorderFactory.createTitledBorder(BORDER, panelName));
                classSpecificationsPanel.add((Component)keepSubpanel, panelConstraints);
                lastPanelName = panelName;
            }
            JCheckBox boilerplateCheckBox = new JCheckBox(optionName);
            boilerplateCheckBox.setToolTipText(toolTip);
            boilerplateCheckBoxes[index] = boilerplateCheckBox;
            keepSubpanel.add((Component)boilerplateCheckBox, boilerplateTextFields != null ? constraints : constraintsLastStretch);
            if (boilerplateTextFields == null) continue;
            boilerplateTextFields[index] = new JTextField(40);
            keepSubpanel.add((Component)ProGuardGUI.tip(boilerplateTextFields[index], "classNamesTip"), constraintsLastStretch);
        }
    }

    private void addBorder(JComponent component, String titleKey) {
        Border oldBorder = component.getBorder();
        TitledBorder newBorder = BorderFactory.createTitledBorder(BORDER, ProGuardGUI.msg(titleKey));
        component.setBorder(oldBorder == null ? newBorder : new CompoundBorder(newBorder, oldBorder));
    }

    private JButton createPreviousButton(final TabbedPane tabbedPane) {
        JButton browseButton = new JButton(ProGuardGUI.msg("previous"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tabbedPane.previous();
            }
        });
        return browseButton;
    }

    private JButton createNextButton(final TabbedPane tabbedPane) {
        JButton browseButton = new JButton(ProGuardGUI.msg("next"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                tabbedPane.next();
            }
        });
        return browseButton;
    }

    private JButton createBrowseButton(final JTextField textField, final String title) {
        JButton browseButton = new JButton(ProGuardGUI.msg("browse"));
        browseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ProGuardGUI.this.fileChooser.setDialogTitle(title);
                ProGuardGUI.this.fileChooser.setSelectedFile(new File(textField.getText()));
                int returnVal = ProGuardGUI.this.fileChooser.showDialog(ProGuardGUI.this, ProGuardGUI.msg("ok"));
                if (returnVal == 0) {
                    textField.setText(ProGuardGUI.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        return browseButton;
    }

    protected JButton createOptimizationsButton(final JTextField textField) {
        final OptimizationsDialog optimizationsDialog = new OptimizationsDialog(this);
        JButton optimizationsButton = new JButton(ProGuardGUI.msg("select"));
        optimizationsButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                optimizationsDialog.setFilter(textField.getText());
                int returnValue = optimizationsDialog.showDialog();
                if (returnValue == 0) {
                    textField.setText(optimizationsDialog.getFilter());
                }
            }
        });
        return optimizationsButton;
    }

    private void setCommonPreferredSize(List components) {
        JComponent component;
        int index;
        Dimension maximumSize = null;
        for (index = 0; index < components.size(); ++index) {
            component = (JComponent)components.get(index);
            Dimension size = component.getPreferredSize();
            if (maximumSize != null && !(size.getWidth() > maximumSize.getWidth())) continue;
            maximumSize = size;
        }
        for (index = 0; index < components.size(); ++index) {
            component = (JComponent)components.get(index);
            component.setPreferredSize(maximumSize);
        }
    }

    private void setProGuardConfiguration(Configuration configuration) {
        String classNames;
        int index;
        this.programPanel.setClassPath(configuration.programJars);
        this.libraryPanel.setClassPath(configuration.libraryJars);
        for (index = 0; index < this.boilerplateKeep.length; ++index) {
            classNames = this.findMatchingKeepSpecifications(this.boilerplateKeep[index], configuration.keep);
            this.boilerplateKeepCheckBoxes[index].setSelected(classNames != null);
            this.boilerplateKeepTextFields[index].setText(classNames == null ? OPTIMIZATIONS_DEFAULT : classNames);
        }
        for (index = 0; index < this.boilerplateKeepNames.length; ++index) {
            classNames = this.findMatchingKeepSpecifications(this.boilerplateKeepNames[index], configuration.keep);
            this.boilerplateKeepNamesCheckBoxes[index].setSelected(classNames != null);
            this.boilerplateKeepNamesTextFields[index].setText(classNames == null ? OPTIMIZATIONS_DEFAULT : classNames);
        }
        this.additionalKeepPanel.setClassSpecifications(this.filteredKeepSpecifications(configuration.keep, false));
        this.additionalKeepNamesPanel.setClassSpecifications(this.filteredKeepSpecifications(configuration.keep, true));
        for (index = 0; index < this.boilerplateNoSideEffectMethods.length; ++index) {
            boolean found = this.findClassSpecification(this.boilerplateNoSideEffectMethods[index], configuration.assumeNoSideEffects);
            this.boilerplateNoSideEffectMethodCheckBoxes[index].setSelected(found);
        }
        this.additionalNoSideEffectsPanel.setClassSpecifications(configuration.assumeNoSideEffects);
        this.whyAreYouKeepingPanel.setClassSpecifications(configuration.whyAreYouKeeping);
        this.shrinkCheckBox.setSelected(configuration.shrink);
        this.printUsageCheckBox.setSelected(configuration.printUsage != null);
        this.optimizeCheckBox.setSelected(configuration.optimize);
        this.allowAccessModificationCheckBox.setSelected(configuration.allowAccessModification);
        this.mergeInterfacesAggressivelyCheckBox.setSelected(configuration.mergeInterfacesAggressively);
        this.optimizationPassesSpinner.getModel().setValue(new Integer(configuration.optimizationPasses));
        this.obfuscateCheckBox.setSelected(configuration.obfuscate);
        this.printMappingCheckBox.setSelected(configuration.printMapping != null);
        this.applyMappingCheckBox.setSelected(configuration.applyMapping != null);
        this.obfuscationDictionaryCheckBox.setSelected(configuration.obfuscationDictionary != null);
        this.classObfuscationDictionaryCheckBox.setSelected(configuration.classObfuscationDictionary != null);
        this.packageObfuscationDictionaryCheckBox.setSelected(configuration.packageObfuscationDictionary != null);
        this.overloadAggressivelyCheckBox.setSelected(configuration.overloadAggressively);
        this.useUniqueClassMemberNamesCheckBox.setSelected(configuration.useUniqueClassMemberNames);
        this.useMixedCaseClassNamesCheckBox.setSelected(configuration.useMixedCaseClassNames);
        this.keepPackageNamesCheckBox.setSelected(configuration.keepPackageNames != null);
        this.flattenPackageHierarchyCheckBox.setSelected(configuration.flattenPackageHierarchy != null);
        this.repackageClassesCheckBox.setSelected(configuration.repackageClasses != null);
        this.keepAttributesCheckBox.setSelected(configuration.keepAttributes != null);
        this.keepParameterNamesCheckBox.setSelected(configuration.keepParameterNames);
        this.newSourceFileAttributeCheckBox.setSelected(configuration.newSourceFileAttribute != null);
        this.adaptClassStringsCheckBox.setSelected(configuration.adaptClassStrings != null);
        this.adaptResourceFileNamesCheckBox.setSelected(configuration.adaptResourceFileNames != null);
        this.adaptResourceFileContentsCheckBox.setSelected(configuration.adaptResourceFileContents != null);
        this.preverifyCheckBox.setSelected(configuration.preverify);
        this.microEditionCheckBox.setSelected(configuration.microEdition);
        this.targetCheckBox.setSelected(configuration.targetClassVersion != 0);
        this.verboseCheckBox.setSelected(configuration.verbose);
        this.noteCheckBox.setSelected(configuration.note == null || !configuration.note.isEmpty());
        this.warnCheckBox.setSelected(configuration.warn == null || !configuration.warn.isEmpty());
        this.ignoreWarningsCheckBox.setSelected(configuration.ignoreWarnings);
        this.skipNonPublicLibraryClassesCheckBox.setSelected(configuration.skipNonPublicLibraryClasses);
        this.skipNonPublicLibraryClassMembersCheckBox.setSelected(configuration.skipNonPublicLibraryClassMembers);
        this.keepDirectoriesCheckBox.setSelected(configuration.keepDirectories != null);
        this.forceProcessingCheckBox.setSelected(configuration.lastModified == Long.MAX_VALUE);
        this.printSeedsCheckBox.setSelected(configuration.printSeeds != null);
        this.printConfigurationCheckBox.setSelected(configuration.printConfiguration != null);
        this.dumpCheckBox.setSelected(configuration.dump != null);
        this.printUsageTextField.setText(this.fileName(configuration.printUsage));
        this.optimizationsTextField.setText(configuration.optimizations == null ? OPTIMIZATIONS_DEFAULT : ListUtil.commaSeparatedString((List)configuration.optimizations, (boolean)true));
        this.printMappingTextField.setText(this.fileName(configuration.printMapping));
        this.applyMappingTextField.setText(this.fileName(configuration.applyMapping));
        this.obfuscationDictionaryTextField.setText(this.fileName(configuration.obfuscationDictionary));
        this.classObfuscationDictionaryTextField.setText(this.fileName(configuration.classObfuscationDictionary));
        this.packageObfuscationDictionaryTextField.setText(this.fileName(configuration.packageObfuscationDictionary));
        this.keepPackageNamesTextField.setText(configuration.keepPackageNames == null ? "" : ClassUtil.externalClassName((String)ListUtil.commaSeparatedString((List)configuration.keepPackageNames, (boolean)true)));
        this.flattenPackageHierarchyTextField.setText(configuration.flattenPackageHierarchy);
        this.repackageClassesTextField.setText(configuration.repackageClasses);
        this.keepAttributesTextField.setText(configuration.keepAttributes == null ? KEEP_ATTRIBUTE_DEFAULT : ListUtil.commaSeparatedString((List)configuration.keepAttributes, (boolean)true));
        this.newSourceFileAttributeTextField.setText(configuration.newSourceFileAttribute == null ? SOURCE_FILE_ATTRIBUTE_DEFAULT : configuration.newSourceFileAttribute);
        this.adaptClassStringsTextField.setText(configuration.adaptClassStrings == null ? "" : ClassUtil.externalClassName((String)ListUtil.commaSeparatedString((List)configuration.adaptClassStrings, (boolean)true)));
        this.adaptResourceFileNamesTextField.setText(configuration.adaptResourceFileNames == null ? ADAPT_RESOURCE_FILE_NAMES_DEFAULT : ListUtil.commaSeparatedString((List)configuration.adaptResourceFileNames, (boolean)true));
        this.adaptResourceFileContentsTextField.setText(configuration.adaptResourceFileContents == null ? ADAPT_RESOURCE_FILE_CONTENTS_DEFAULT : ListUtil.commaSeparatedString((List)configuration.adaptResourceFileContents, (boolean)true));
        this.noteTextField.setText(ListUtil.commaSeparatedString((List)configuration.note, (boolean)true));
        this.warnTextField.setText(ListUtil.commaSeparatedString((List)configuration.warn, (boolean)true));
        this.keepDirectoriesTextField.setText(ListUtil.commaSeparatedString((List)configuration.keepDirectories, (boolean)true));
        this.printSeedsTextField.setText(this.fileName(configuration.printSeeds));
        this.printConfigurationTextField.setText(this.fileName(configuration.printConfiguration));
        this.dumpTextField.setText(this.fileName(configuration.dump));
        if (configuration.targetClassVersion != 0) {
            this.targetComboBox.setSelectedItem(ClassUtil.externalClassVersion((int)configuration.targetClassVersion));
        } else {
            this.targetComboBox.setSelectedIndex(this.targetComboBox.getItemCount() - 1);
        }
        if (configuration.printMapping != null) {
            this.reTraceMappingTextField.setText(this.fileName(configuration.printMapping));
        }
    }

    private Configuration getProGuardConfiguration() {
        int index;
        List additionalKeepNames;
        Configuration configuration = new Configuration();
        configuration.programJars = this.programPanel.getClassPath();
        configuration.libraryJars = this.libraryPanel.getClassPath();
        ArrayList<ClassSpecification> keep = new ArrayList<ClassSpecification>();
        List additionalKeep = this.additionalKeepPanel.getClassSpecifications();
        if (additionalKeep != null) {
            keep.addAll(additionalKeep);
        }
        if ((additionalKeepNames = this.additionalKeepNamesPanel.getClassSpecifications()) != null) {
            keep.addAll(additionalKeepNames);
        }
        for (index = 0; index < this.boilerplateKeep.length; ++index) {
            if (!this.boilerplateKeepCheckBoxes[index].isSelected()) continue;
            keep.add(this.classSpecification((ClassSpecification)this.boilerplateKeep[index], this.boilerplateKeepTextFields[index].getText()));
        }
        for (index = 0; index < this.boilerplateKeepNames.length; ++index) {
            if (!this.boilerplateKeepNamesCheckBoxes[index].isSelected()) continue;
            keep.add(this.classSpecification((ClassSpecification)this.boilerplateKeepNames[index], this.boilerplateKeepNamesTextFields[index].getText()));
        }
        if (keep.size() > 0) {
            configuration.keep = keep;
        }
        ArrayList<ClassSpecification> noSideEffectMethods = new ArrayList<ClassSpecification>();
        for (int index2 = 0; index2 < this.boilerplateNoSideEffectMethods.length; ++index2) {
            if (!this.boilerplateNoSideEffectMethodCheckBoxes[index2].isSelected()) continue;
            noSideEffectMethods.add(this.boilerplateNoSideEffectMethods[index2]);
        }
        List additionalNoSideEffectOptions = this.additionalNoSideEffectsPanel.getClassSpecifications();
        if (additionalNoSideEffectOptions != null) {
            noSideEffectMethods.addAll(additionalNoSideEffectOptions);
        }
        if (noSideEffectMethods.size() > 0) {
            configuration.assumeNoSideEffects = noSideEffectMethods;
        }
        configuration.whyAreYouKeeping = this.whyAreYouKeepingPanel.getClassSpecifications();
        configuration.shrink = this.shrinkCheckBox.isSelected();
        configuration.printUsage = this.printUsageCheckBox.isSelected() ? new File(this.printUsageTextField.getText()) : null;
        configuration.optimize = this.optimizeCheckBox.isSelected();
        configuration.allowAccessModification = this.allowAccessModificationCheckBox.isSelected();
        configuration.mergeInterfacesAggressively = this.mergeInterfacesAggressivelyCheckBox.isSelected();
        configuration.optimizations = this.optimizationsTextField.getText().length() > 1 ? ListUtil.commaSeparatedList((String)this.optimizationsTextField.getText()) : null;
        configuration.optimizationPasses = ((SpinnerNumberModel)this.optimizationPassesSpinner.getModel()).getNumber().intValue();
        configuration.obfuscate = this.obfuscateCheckBox.isSelected();
        configuration.printMapping = this.printMappingCheckBox.isSelected() ? new File(this.printMappingTextField.getText()) : null;
        configuration.applyMapping = this.applyMappingCheckBox.isSelected() ? new File(this.applyMappingTextField.getText()) : null;
        configuration.obfuscationDictionary = this.obfuscationDictionaryCheckBox.isSelected() ? new File(this.obfuscationDictionaryTextField.getText()) : null;
        configuration.classObfuscationDictionary = this.classObfuscationDictionaryCheckBox.isSelected() ? new File(this.classObfuscationDictionaryTextField.getText()) : null;
        configuration.packageObfuscationDictionary = this.packageObfuscationDictionaryCheckBox.isSelected() ? new File(this.packageObfuscationDictionaryTextField.getText()) : null;
        configuration.overloadAggressively = this.overloadAggressivelyCheckBox.isSelected();
        configuration.useUniqueClassMemberNames = this.useUniqueClassMemberNamesCheckBox.isSelected();
        configuration.useMixedCaseClassNames = this.useMixedCaseClassNamesCheckBox.isSelected();
        configuration.keepPackageNames = this.keepPackageNamesCheckBox.isSelected() ? (this.keepPackageNamesTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.keepPackageNamesTextField.getText())) : new ArrayList()) : null;
        configuration.flattenPackageHierarchy = this.flattenPackageHierarchyCheckBox.isSelected() ? ClassUtil.internalClassName((String)this.flattenPackageHierarchyTextField.getText()) : null;
        configuration.repackageClasses = this.repackageClassesCheckBox.isSelected() ? ClassUtil.internalClassName((String)this.repackageClassesTextField.getText()) : null;
        configuration.keepAttributes = this.keepAttributesCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.keepAttributesTextField.getText()) : null;
        configuration.keepParameterNames = this.keepParameterNamesCheckBox.isSelected();
        String string = configuration.newSourceFileAttribute = this.newSourceFileAttributeCheckBox.isSelected() ? this.newSourceFileAttributeTextField.getText() : null;
        configuration.adaptClassStrings = this.adaptClassStringsCheckBox.isSelected() ? (this.adaptClassStringsTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.adaptClassStringsTextField.getText())) : new ArrayList()) : null;
        configuration.adaptResourceFileNames = this.adaptResourceFileNamesCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.adaptResourceFileNamesTextField.getText()) : null;
        configuration.adaptResourceFileContents = this.adaptResourceFileContentsCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.adaptResourceFileContentsTextField.getText()) : null;
        configuration.preverify = this.preverifyCheckBox.isSelected();
        configuration.microEdition = this.microEditionCheckBox.isSelected();
        configuration.targetClassVersion = this.targetCheckBox.isSelected() ? ClassUtil.internalClassVersion((String)this.targetComboBox.getSelectedItem().toString()) : 0;
        configuration.verbose = this.verboseCheckBox.isSelected();
        List list = this.noteCheckBox.isSelected() ? (this.noteTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.noteTextField.getText())) : null) : (configuration.note = new ArrayList());
        configuration.warn = this.warnCheckBox.isSelected() ? (this.warnTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.warnTextField.getText())) : null) : new ArrayList();
        configuration.ignoreWarnings = this.ignoreWarningsCheckBox.isSelected();
        configuration.skipNonPublicLibraryClasses = this.skipNonPublicLibraryClassesCheckBox.isSelected();
        configuration.skipNonPublicLibraryClassMembers = this.skipNonPublicLibraryClassMembersCheckBox.isSelected();
        configuration.keepDirectories = this.keepDirectoriesCheckBox.isSelected() ? (this.keepDirectoriesTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.keepDirectoriesTextField.getText())) : new ArrayList()) : null;
        configuration.lastModified = this.forceProcessingCheckBox.isSelected() ? Long.MAX_VALUE : System.currentTimeMillis();
        configuration.printSeeds = this.printSeedsCheckBox.isSelected() ? new File(this.printSeedsTextField.getText()) : null;
        configuration.printConfiguration = this.printConfigurationCheckBox.isSelected() ? new File(this.printConfigurationTextField.getText()) : null;
        configuration.dump = this.dumpCheckBox.isSelected() ? new File(this.dumpTextField.getText()) : null;
        return configuration;
    }

    private boolean findClassSpecification(ClassSpecification classSpecificationTemplate, List classSpecifications) {
        if (classSpecifications == null) {
            return false;
        }
        for (int index = 0; index < classSpecifications.size(); ++index) {
            if (!classSpecificationTemplate.equals(classSpecifications.get(index))) continue;
            classSpecifications.remove(index);
            return true;
        }
        return false;
    }

    private List filteredKeepSpecifications(List keepSpecifications, boolean allowShrinking) {
        ArrayList<KeepClassSpecification> filteredKeepSpecifications = new ArrayList<KeepClassSpecification>();
        for (int index = 0; index < keepSpecifications.size(); ++index) {
            KeepClassSpecification keepClassSpecification = (KeepClassSpecification)keepSpecifications.get(index);
            if (keepClassSpecification.allowShrinking != allowShrinking) continue;
            filteredKeepSpecifications.add(keepClassSpecification);
        }
        return filteredKeepSpecifications;
    }

    private String findMatchingKeepSpecifications(KeepClassSpecification keepClassSpecificationTemplate, List keepSpecifications) {
        if (keepSpecifications == null) {
            return null;
        }
        StringBuffer buffer = null;
        for (int index = 0; index < keepSpecifications.size(); ++index) {
            String className;
            KeepClassSpecification listedKeepClassSpecification = (KeepClassSpecification)keepSpecifications.get(index);
            keepClassSpecificationTemplate.className = className = listedKeepClassSpecification.className;
            if (!keepClassSpecificationTemplate.equals((Object)listedKeepClassSpecification)) continue;
            if (buffer == null) {
                buffer = new StringBuffer();
            } else {
                buffer.append(',');
            }
            buffer.append(className == null ? OPTIMIZATIONS_DEFAULT : ClassUtil.externalClassName((String)className));
            keepSpecifications.remove(index--);
        }
        return buffer == null ? null : buffer.toString();
    }

    private ClassSpecification classSpecification(ClassSpecification classSpecificationTemplate, String className) {
        ClassSpecification classSpecification = (ClassSpecification)classSpecificationTemplate.clone();
        classSpecification.className = className.equals("") || className.equals(OPTIMIZATIONS_DEFAULT) ? null : ClassUtil.internalClassName((String)className);
        return classSpecification;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(File file) {
        this.configurationChooser.setSelectedFile(file.getAbsoluteFile());
        this.fileChooser.setCurrentDirectory(file.getAbsoluteFile().getParentFile());
        try {
            ConfigurationParser parser = new ConfigurationParser(file);
            Configuration configuration = new Configuration();
            try {
                parser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
            }
            finally {
                parser.close();
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(URL url) {
        try {
            ConfigurationParser parser = new ConfigurationParser(url);
            Configuration configuration = new Configuration();
            try {
                parser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException ex) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", url), ProGuardGUI.msg("warning"), 0);
            }
            finally {
                parser.close();
            }
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", url), ProGuardGUI.msg("warning"), 0);
        }
    }

    private void saveConfiguration(File file) {
        try {
            ConfigurationWriter writer = new ConfigurationWriter(file);
            writer.write(this.getProGuardConfiguration());
            writer.close();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantSaveConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStackTrace(File file) {
        try {
            StringBuffer buffer = new StringBuffer(1024);
            BufferedReader reader = new BufferedReader(new FileReader(file));
            try {
                int c;
                while ((c = ((Reader)reader).read()) >= 0) {
                    buffer.append(c);
                }
            }
            finally {
                ((Reader)reader).close();
            }
            this.stackTraceTextArea.setText(buffer.toString());
        }
        catch (IOException ex) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenStackTraceFile", this.fileName(file)), ProGuardGUI.msg("warning"), 0);
        }
    }

    private String fileName(File file) {
        if (this.isFile(file)) {
            try {
                return file.getCanonicalPath();
            }
            catch (IOException ex) {
                return file.getPath();
            }
        }
        return "";
    }

    private boolean isFile(File file) {
        return file != null && file.getPath().length() > 0;
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ProGuardGUI.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }

    private String msg(String messageKey, Object messageArgument) {
        return GUIResources.getMessage(messageKey, new Object[]{messageArgument});
    }

    public static void main(final String[] args) {
        try {
            SwingUtil.invokeAndWait(new Runnable(){

                public void run() {
                    try {
                        ProGuardGUI gui = new ProGuardGUI();
                        gui.pack();
                        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
                        Dimension guiSize = gui.getSize();
                        gui.setLocation((screenSize.width - guiSize.width) / 2, (screenSize.height - guiSize.height) / 2);
                        gui.show();
                        int argIndex = 0;
                        if (argIndex < args.length && ProGuardGUI.NO_SPLASH_OPTION.startsWith(args[argIndex])) {
                            gui.skipSplash();
                            ++argIndex;
                        } else {
                            gui.startSplash();
                        }
                        if (argIndex < args.length) {
                            gui.loadConfiguration(new File(args[argIndex]));
                            ++argIndex;
                        }
                        if (argIndex < args.length) {
                            System.out.println(gui.getClass().getName() + ": ignoring extra arguments [" + args[argIndex] + "...]");
                        }
                    }
                    catch (Exception e) {
                        System.out.println("Internal problem starting the ProGuard GUI (" + e.getMessage() + ")");
                    }
                }
            });
        }
        catch (Exception e) {
            System.out.println("Internal problem starting the ProGuard GUI (" + e.getMessage() + ")");
        }
    }

    private class MyReTraceActionListener
    implements ActionListener {
        private MyReTraceActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                boolean verbose = ProGuardGUI.this.reTraceVerboseCheckBox.isSelected();
                File retraceMappingFile = new File(ProGuardGUI.this.reTraceMappingTextField.getText());
                String stackTrace = ProGuardGUI.this.stackTraceTextArea.getText();
                ReTraceRunnable reTraceRunnable = new ReTraceRunnable(ProGuardGUI.this.reTraceTextArea, verbose, retraceMappingFile, stackTrace);
                reTraceRunnable.run();
            }
        }
    }

    private class MyLoadStackTraceActionListener
    implements ActionListener {
        private MyLoadStackTraceActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ProGuardGUI.this.fileChooser.setDialogTitle(ProGuardGUI.msg("selectStackTraceFile"));
            ProGuardGUI.this.fileChooser.setSelectedFile(null);
            int returnValue = ProGuardGUI.this.fileChooser.showOpenDialog(ProGuardGUI.this);
            if (returnValue == 0) {
                ProGuardGUI.this.loadStackTrace(ProGuardGUI.this.fileChooser.getSelectedFile());
            }
        }
    }

    private class MyProcessActionListener
    implements ActionListener {
        private MyProcessActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                File configurationFile = ProGuardGUI.this.configurationChooser.getSelectedFile();
                String configurationFileName = configurationFile != null ? configurationFile.getName() : ProGuardGUI.msg("sampleConfigurationFileName");
                Thread proGuardThread = new Thread(new ProGuardRunnable(ProGuardGUI.this.consoleTextArea, ProGuardGUI.this.getProGuardConfiguration(), configurationFileName));
                proGuardThread.start();
            }
        }
    }

    private class MyViewConfigurationActionListener
    implements ActionListener {
        private MyViewConfigurationActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent e) {
            if (!systemOutRedirected) {
                ProGuardGUI.this.consoleTextArea.setText("");
                TextAreaOutputStream outputStream = new TextAreaOutputStream(ProGuardGUI.this.consoleTextArea);
                try {
                    ConfigurationWriter writer = new ConfigurationWriter((OutputStream)outputStream);
                    try {
                        writer.write(ProGuardGUI.this.getProGuardConfiguration());
                    }
                    finally {
                        writer.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ProGuardGUI.this.consoleTextArea.setCaretPosition(0);
            }
        }
    }

    private class MySaveConfigurationActionListener
    implements ActionListener {
        private MySaveConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.msg("saveConfigurationFile"));
            int returnVal = ProGuardGUI.this.configurationChooser.showSaveDialog(ProGuardGUI.this);
            if (returnVal == 0) {
                ProGuardGUI.this.saveConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }

    private class MyLoadConfigurationActionListener
    implements ActionListener {
        private MyLoadConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent e) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.msg("selectConfigurationFile"));
            int returnValue = ProGuardGUI.this.configurationChooser.showOpenDialog(ProGuardGUI.this);
            if (returnValue == 0) {
                ProGuardGUI.this.loadConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }
}

