/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Cursor;
import java.io.PrintStream;
import javax.swing.JTextArea;
import proguard.Configuration;
import proguard.ProGuard;
import proguard.gui.GUIResources;
import proguard.gui.MessageDialogRunnable;
import proguard.gui.ProGuardGUI;
import proguard.gui.TextAreaOutputStream;

final class ProGuardRunnable
implements Runnable {
    private final JTextArea consoleTextArea;
    private final Configuration configuration;
    private final String configurationFileName;

    public ProGuardRunnable(JTextArea consoleTextArea, Configuration configuration, String configurationFileName) {
        this.consoleTextArea = consoleTextArea;
        this.configuration = configuration;
        this.configurationFileName = configurationFileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(3));
        this.consoleTextArea.setText("");
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        PrintStream printStream = new PrintStream(new TextAreaOutputStream(this.consoleTextArea), true);
        System.setOut(printStream);
        System.setErr(printStream);
        try {
            ProGuard proGuard = new ProGuard(this.configuration);
            proGuard.execute();
            System.out.println("Processing completed successfully");
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, ex.getMessage(), this.msg("errorProcessing"), 0);
        }
        catch (OutOfMemoryError er) {
            System.gc();
            System.out.println(this.msg("outOfMemoryInfo", this.configurationFileName));
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, this.msg("outOfMemory"), this.msg("errorProcessing"), 0);
        }
        finally {
            printStream.close();
            System.setOut(oldOut);
            System.setErr(oldErr);
        }
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(0));
        ProGuardGUI.systemOutRedirected = false;
    }

    private String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }

    private String msg(String messageKey, Object messageArgument) {
        return GUIResources.getMessage(messageKey, new Object[]{messageArgument});
    }
}

