/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Cursor;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.PrintStream;
import javax.swing.JTextArea;
import proguard.gui.GUIResources;
import proguard.gui.MessageDialogRunnable;
import proguard.gui.ProGuardGUI;
import proguard.gui.TextAreaOutputStream;
import proguard.retrace.ReTrace;

final class ReTraceRunnable
implements Runnable {
    private final JTextArea consoleTextArea;
    private final boolean verbose;
    private final File mappingFile;
    private final String stackTrace;

    public ReTraceRunnable(JTextArea consoleTextArea, boolean verbose, File mappingFile, String stackTrace) {
        this.consoleTextArea = consoleTextArea;
        this.verbose = verbose;
        this.mappingFile = mappingFile;
        this.stackTrace = stackTrace;
    }

    public void run() {
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(3));
        this.consoleTextArea.setText("");
        InputStream oldIn = System.in;
        PrintStream oldOut = System.out;
        PrintStream oldErr = System.err;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(this.stackTrace.getBytes());
        PrintStream printStream = new PrintStream(new TextAreaOutputStream(this.consoleTextArea), true);
        System.setIn(inputStream);
        System.setOut(printStream);
        System.setErr(printStream);
        try {
            ReTrace reTrace = new ReTrace("(?:\\s*%c:.*)|(?:\\s*at\\s+%c.%m\\s*\\(.*?(?::%l)?\\)\\s*)", this.verbose, this.mappingFile);
            reTrace.execute();
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, ex.getMessage(), this.msg("errorReTracing"), 0);
        }
        catch (OutOfMemoryError er) {
            System.gc();
            System.out.println(this.msg("outOfMemory"));
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, this.msg("outOfMemory"), this.msg("errorReTracing"), 0);
        }
        printStream.flush();
        System.setIn(oldIn);
        System.setOut(oldOut);
        System.setErr(oldErr);
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(0));
        this.consoleTextArea.setCaretPosition(0);
        ProGuardGUI.systemOutRedirected = false;
    }

    private String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

