/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Cursor;
import java.io.CharArrayReader;
import java.io.File;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.Writer;
import javax.swing.JTextArea;
import proguard.gui.GUIResources;
import proguard.gui.MessageDialogRunnable;
import proguard.gui.TextAreaWriter;
import proguard.retrace.ReTrace;

final class ReTraceRunnable
implements Runnable {
    private final JTextArea consoleTextArea;
    private final boolean verbose;
    private final File mappingFile;
    private final String stackTrace;

    public ReTraceRunnable(JTextArea consoleTextArea, boolean verbose, File mappingFile, String stackTrace) {
        this.consoleTextArea = consoleTextArea;
        this.verbose = verbose;
        this.mappingFile = mappingFile;
        this.stackTrace = stackTrace;
    }

    public void run() {
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(3));
        this.consoleTextArea.setText("");
        LineNumberReader reader = new LineNumberReader(new CharArrayReader(this.stackTrace.toCharArray()));
        PrintWriter writer = new PrintWriter((Writer)new TextAreaWriter(this.consoleTextArea), true);
        try {
            new ReTrace("(?:.*?\\bat\\s+%c\\.%m\\s*\\(%s(?::%l)?\\)\\s*)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)", this.verbose, this.mappingFile).retrace(reader, writer);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, ex.getMessage(), this.msg("errorReTracing"), 0);
        }
        catch (OutOfMemoryError er) {
            System.gc();
            System.out.println(this.msg("outOfMemory"));
            MessageDialogRunnable.showMessageDialog(this.consoleTextArea, this.msg("outOfMemory"), this.msg("errorReTracing"), 0);
        }
        this.consoleTextArea.setCursor(Cursor.getPredefinedCursor(0));
        this.consoleTextArea.setCaretPosition(0);
    }

    private String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }
}

