/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.List;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import proguard.ClassPath;
import proguard.ClassPathEntry;
import proguard.gui.ExtensionFileFilter;
import proguard.gui.FilterDialog;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;
import proguard.util.ListUtil;

class ClassPathPanel
extends ListPanel {
    private final JFrame owner;
    private final boolean inputAndOutput;
    private final JFileChooser chooser;
    private final FilterDialog filterDialog;

    public ClassPathPanel(JFrame owner, boolean inputAndOutput) {
        this.firstSelectionButton = inputAndOutput ? 3 : 2;
        this.owner = owner;
        this.inputAndOutput = inputAndOutput;
        this.list.setCellRenderer(new MyListCellRenderer());
        this.chooser = new JFileChooser("");
        this.chooser.setMultiSelectionEnabled(true);
        this.chooser.setFileSelectionMode(2);
        this.chooser.addChoosableFileFilter(new ExtensionFileFilter(ClassPathPanel.msg("jarExtensions"), new String[]{".apk", ".ap_", ".jar", ".aar", ".war", ".ear", ".jmod", ".zip"}));
        this.chooser.setApproveButtonText(ClassPathPanel.msg("ok"));
        this.filterDialog = new FilterDialog(owner, ClassPathPanel.msg("enterFilter"));
        this.addAddButton(inputAndOutput, false);
        if (inputAndOutput) {
            this.addAddButton(inputAndOutput, true);
        }
        this.addEditButton();
        this.addFilterButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddButton(boolean inputAndOutput, final boolean isOutput) {
        JButton addButton = new JButton(ClassPathPanel.msg(inputAndOutput ? (isOutput ? "addOutput" : "addInput") : "add"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassPathPanel.this.chooser.setDialogTitle(ClassPathPanel.msg("addJars"));
                ClassPathPanel.this.chooser.setSelectedFile(null);
                ClassPathPanel.this.chooser.setSelectedFiles(null);
                int returnValue = ClassPathPanel.this.chooser.showOpenDialog(ClassPathPanel.this.owner);
                if (returnValue == 0) {
                    File[] selectedFiles = ClassPathPanel.this.chooser.getSelectedFiles();
                    Object[] entries = ClassPathPanel.this.classPathEntries(selectedFiles, isOutput);
                    ClassPathPanel.this.addElements(entries);
                }
            }
        });
        this.addButton(ClassPathPanel.tip(addButton, inputAndOutput ? (isOutput ? "addOutputTip" : "addInputTip") : "addTip"));
    }

    protected void addEditButton() {
        JButton editButton = new JButton(ClassPathPanel.msg("edit"));
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                boolean isOutput = false;
                int[] selectedIndices = ClassPathPanel.this.list.getSelectedIndices();
                File[] selectedFiles = new File[selectedIndices.length];
                for (int index = 0; index < selectedFiles.length; ++index) {
                    ClassPathEntry entry = (ClassPathEntry)ClassPathPanel.this.listModel.getElementAt(selectedIndices[index]);
                    isOutput = entry.isOutput();
                    selectedFiles[index] = entry.getFile();
                }
                ClassPathPanel.this.chooser.setDialogTitle(ClassPathPanel.msg("chooseJars"));
                ClassPathPanel.this.chooser.setSelectedFile(selectedFiles[0].getAbsoluteFile());
                ClassPathPanel.this.chooser.setSelectedFiles(selectedFiles);
                int returnValue = ClassPathPanel.this.chooser.showOpenDialog(ClassPathPanel.this.owner);
                if (returnValue == 0) {
                    selectedFiles = ClassPathPanel.this.chooser.getSelectedFiles();
                    Object[] entries = ClassPathPanel.this.classPathEntries(selectedFiles, isOutput);
                    if (selectedIndices.length == selectedFiles.length) {
                        ClassPathPanel.this.setElementsAt(entries, selectedIndices);
                    } else {
                        ClassPathPanel.this.removeElementsAt(selectedIndices);
                        ClassPathPanel.this.addElements(entries);
                    }
                }
            }
        });
        this.addButton(ClassPathPanel.tip(editButton, "editTip"));
    }

    protected void addFilterButton() {
        JButton filterButton = new JButton(ClassPathPanel.msg("filter"));
        filterButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (!ClassPathPanel.this.list.isSelectionEmpty()) {
                    int[] selectedIndices = ClassPathPanel.this.list.getSelectedIndices();
                    ClassPathPanel.this.getFiltersFrom(selectedIndices[0]);
                    int returnValue = ClassPathPanel.this.filterDialog.showDialog();
                    if (returnValue == 0) {
                        ClassPathPanel.this.setFiltersAt(selectedIndices);
                    }
                }
            }
        });
        this.addButton(ClassPathPanel.tip(filterButton, "filterTip"));
    }

    public void setClassPath(ClassPath classPath) {
        this.listModel.clear();
        if (classPath != null) {
            for (int index = 0; index < classPath.size(); ++index) {
                this.listModel.addElement(classPath.get(index));
            }
        }
        this.enableSelectionButtons();
    }

    public ClassPath getClassPath() {
        int size = this.listModel.size();
        if (size == 0) {
            return null;
        }
        ClassPath classPath = new ClassPath();
        for (int index = 0; index < size; ++index) {
            classPath.add((ClassPathEntry)this.listModel.get(index));
        }
        return classPath;
    }

    private ClassPathEntry[] classPathEntries(File[] files, boolean isOutput) {
        ClassPathEntry[] entries = new ClassPathEntry[files.length];
        for (int index = 0; index < entries.length; ++index) {
            entries[index] = new ClassPathEntry(files[index], isOutput);
        }
        return entries;
    }

    private void getFiltersFrom(int index) {
        ClassPathEntry firstEntry = (ClassPathEntry)this.listModel.get(index);
        this.filterDialog.setFilter(firstEntry.getFilter());
        this.filterDialog.setApkFilter(firstEntry.getApkFilter());
        this.filterDialog.setJarFilter(firstEntry.getJarFilter());
        this.filterDialog.setAarFilter(firstEntry.getAarFilter());
        this.filterDialog.setWarFilter(firstEntry.getWarFilter());
        this.filterDialog.setEarFilter(firstEntry.getEarFilter());
        this.filterDialog.setJmodFilter(firstEntry.getJmodFilter());
        this.filterDialog.setZipFilter(firstEntry.getZipFilter());
    }

    private void setFiltersAt(int[] indices) {
        for (int index = indices.length - 1; index >= 0; --index) {
            ClassPathEntry entry = (ClassPathEntry)this.listModel.get(indices[index]);
            entry.setFilter(this.filterDialog.getFilter());
            entry.setApkFilter(this.filterDialog.getApkFilter());
            entry.setJarFilter(this.filterDialog.getJarFilter());
            entry.setAarFilter(this.filterDialog.getAarFilter());
            entry.setWarFilter(this.filterDialog.getWarFilter());
            entry.setEarFilter(this.filterDialog.getEarFilter());
            entry.setJmodFilter(this.filterDialog.getJmodFilter());
            entry.setZipFilter(this.filterDialog.getZipFilter());
        }
        this.list.setSelectedIndices(indices);
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ClassPathPanel.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }

    private class MyListCellRenderer
    implements ListCellRenderer {
        private static final String ARROW_IMAGE_FILE = "arrow.gif";
        private final JPanel cellPanel = new JPanel(new GridBagLayout());
        private final JLabel iconLabel = new JLabel("", 4);
        private final JLabel jarNameLabel = new JLabel("", 4);
        private final JLabel filterLabel = new JLabel("", 4);
        private final Icon arrowIcon;

        public MyListCellRenderer() {
            GridBagConstraints jarNameLabelConstraints = new GridBagConstraints();
            jarNameLabelConstraints.anchor = 17;
            jarNameLabelConstraints.insets = new Insets(1, 2, 1, 2);
            GridBagConstraints filterLabelConstraints = new GridBagConstraints();
            filterLabelConstraints.gridwidth = 0;
            filterLabelConstraints.fill = 2;
            filterLabelConstraints.weightx = 1.0;
            filterLabelConstraints.anchor = 13;
            filterLabelConstraints.insets = jarNameLabelConstraints.insets;
            this.arrowIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(ARROW_IMAGE_FILE)));
            this.cellPanel.add((Component)this.iconLabel, jarNameLabelConstraints);
            this.cellPanel.add((Component)this.jarNameLabel, jarNameLabelConstraints);
            this.cellPanel.add((Component)this.filterLabel, filterLabelConstraints);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ClassPathEntry entry = (ClassPathEntry)value;
            if (ClassPathPanel.this.inputAndOutput && entry.isOutput()) {
                this.iconLabel.setIcon(this.arrowIcon);
            } else {
                this.iconLabel.setIcon(null);
            }
            this.jarNameLabel.setText(entry.getName());
            StringBuffer filter = null;
            filter = this.appendFilter(filter, entry.getZipFilter());
            filter = this.appendFilter(filter, entry.getJmodFilter());
            filter = this.appendFilter(filter, entry.getEarFilter());
            filter = this.appendFilter(filter, entry.getWarFilter());
            filter = this.appendFilter(filter, entry.getAarFilter());
            filter = this.appendFilter(filter, entry.getJarFilter());
            filter = this.appendFilter(filter, entry.getApkFilter());
            filter = this.appendFilter(filter, entry.getFilter());
            if (filter != null) {
                filter.append(')');
            }
            this.filterLabel.setText(filter != null ? filter.toString() : "");
            if (isSelected) {
                this.cellPanel.setBackground(list.getSelectionBackground());
                this.jarNameLabel.setForeground(list.getSelectionForeground());
                this.filterLabel.setForeground(list.getSelectionForeground());
            } else {
                this.cellPanel.setBackground(list.getBackground());
                this.jarNameLabel.setForeground(list.getForeground());
                this.filterLabel.setForeground(list.getForeground());
            }
            if (!(ClassPathPanel.this.inputAndOutput && entry.isOutput() || entry.getFile().canRead())) {
                this.jarNameLabel.setForeground(Color.red);
            }
            this.cellPanel.setOpaque(true);
            return this.cellPanel;
        }

        private StringBuffer appendFilter(StringBuffer filter, List additionalFilter) {
            if (filter != null) {
                filter.append(';');
            }
            if (additionalFilter != null) {
                if (filter == null) {
                    filter = new StringBuffer().append('(');
                }
                filter.append(ListUtil.commaSeparatedString((List)additionalFilter, (boolean)true));
            }
            return filter;
        }
    }
}

