/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import proguard.ClassSpecification;
import proguard.gui.ClassSpecificationDialog;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;

class ClassSpecificationsPanel
extends ListPanel {
    protected final ClassSpecificationDialog classSpecificationDialog;

    public ClassSpecificationsPanel(JFrame owner, boolean includeKeepSettings, boolean includeFieldButton) {
        this.list.setCellRenderer(new MyListCellRenderer());
        this.classSpecificationDialog = new ClassSpecificationDialog(owner, includeKeepSettings, includeFieldButton);
        this.addAddButton();
        this.addEditButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddButton() {
        JButton addButton = new JButton(ClassSpecificationsPanel.msg("add"));
        addButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassSpecificationsPanel.this.setClassSpecification(ClassSpecificationsPanel.this.createClassSpecification());
                int returnValue = ClassSpecificationsPanel.this.classSpecificationDialog.showDialog();
                if (returnValue == 0) {
                    ClassSpecificationsPanel.this.addElement(ClassSpecificationsPanel.this.getClassSpecification());
                }
            }
        });
        this.addButton(ClassSpecificationsPanel.tip(addButton, "addTip"));
    }

    protected void addEditButton() {
        JButton editButton = new JButton(ClassSpecificationsPanel.msg("edit"));
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ClassSpecification selectedClassSpecification = (ClassSpecification)ClassSpecificationsPanel.this.list.getSelectedValue();
                ClassSpecificationsPanel.this.setClassSpecification(selectedClassSpecification);
                int returnValue = ClassSpecificationsPanel.this.classSpecificationDialog.showDialog();
                if (returnValue == 0) {
                    ClassSpecificationsPanel.this.setElementAt(ClassSpecificationsPanel.this.getClassSpecification(), ClassSpecificationsPanel.this.list.getSelectedIndex());
                }
            }
        });
        this.addButton(ClassSpecificationsPanel.tip(editButton, "editTip"));
    }

    protected ClassSpecification createClassSpecification() {
        return new ClassSpecification();
    }

    protected void setClassSpecification(ClassSpecification classSpecification) {
        this.classSpecificationDialog.setClassSpecification(classSpecification);
    }

    protected ClassSpecification getClassSpecification() {
        return this.classSpecificationDialog.getClassSpecification();
    }

    public void setClassSpecifications(List classSpecifications) {
        this.listModel.clear();
        if (classSpecifications != null) {
            for (int index = 0; index < classSpecifications.size(); ++index) {
                this.listModel.addElement(classSpecifications.get(index));
            }
        }
        this.enableSelectionButtons();
    }

    public List getClassSpecifications() {
        int size = this.listModel.size();
        if (size == 0) {
            return null;
        }
        ArrayList classSpecifications = new ArrayList(size);
        for (int index = 0; index < size; ++index) {
            classSpecifications.add(this.listModel.get(index));
        }
        return classSpecifications;
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(ClassSpecificationsPanel.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }

    private class MyListCellRenderer
    implements ListCellRenderer {
        private final JLabel label = new JLabel();

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            ClassSpecification classSpecification = (ClassSpecification)value;
            this.label.setText(ClassSpecificationsPanel.this.classSpecificationDialog.label(classSpecification, index));
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            this.label.setOpaque(true);
            return this.label;
        }
    }
}

