/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import proguard.MemberSpecification;
import proguard.classfile.util.ClassUtil;
import proguard.gui.GUIResources;
import proguard.gui.ListPanel;
import proguard.gui.MemberSpecificationDialog;

final class MemberSpecificationsPanel
extends ListPanel {
    private final MemberSpecificationDialog fieldSpecificationDialog;
    private final MemberSpecificationDialog methodSpecificationDialog;

    public MemberSpecificationsPanel(JDialog owner, boolean includeFieldButton) {
        this.firstSelectionButton = includeFieldButton ? 3 : 2;
        this.list.setCellRenderer(new MyListCellRenderer());
        this.fieldSpecificationDialog = new MemberSpecificationDialog(owner, true);
        this.methodSpecificationDialog = new MemberSpecificationDialog(owner, false);
        if (includeFieldButton) {
            this.addAddFieldButton();
        }
        this.addAddMethodButton();
        this.addEditButton();
        this.addRemoveButton();
        this.addUpButton();
        this.addDownButton();
        this.enableSelectionButtons();
    }

    protected void addAddFieldButton() {
        JButton addFieldButton = new JButton(MemberSpecificationsPanel.msg("addField"));
        addFieldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MemberSpecificationsPanel.this.fieldSpecificationDialog.setMemberSpecification(new MemberSpecification());
                int returnValue = MemberSpecificationsPanel.this.fieldSpecificationDialog.showDialog();
                if (returnValue == 0) {
                    MemberSpecificationsPanel.this.addElement(new MyMemberSpecificationWrapper(MemberSpecificationsPanel.this.fieldSpecificationDialog.getMemberSpecification(), true));
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(addFieldButton, "addFieldTip"));
    }

    protected void addAddMethodButton() {
        JButton addMethodButton = new JButton(MemberSpecificationsPanel.msg("addMethod"));
        addMethodButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MemberSpecificationsPanel.this.methodSpecificationDialog.setMemberSpecification(new MemberSpecification());
                int returnValue = MemberSpecificationsPanel.this.methodSpecificationDialog.showDialog();
                if (returnValue == 0) {
                    MemberSpecificationsPanel.this.addElement(new MyMemberSpecificationWrapper(MemberSpecificationsPanel.this.methodSpecificationDialog.getMemberSpecification(), false));
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(addMethodButton, "addMethodTip"));
    }

    protected void addEditButton() {
        JButton editButton = new JButton(MemberSpecificationsPanel.msg("edit"));
        editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                MyMemberSpecificationWrapper wrapper = (MyMemberSpecificationWrapper)MemberSpecificationsPanel.this.list.getSelectedValue();
                MemberSpecificationDialog memberSpecificationDialog = wrapper.isField ? MemberSpecificationsPanel.this.fieldSpecificationDialog : MemberSpecificationsPanel.this.methodSpecificationDialog;
                memberSpecificationDialog.setMemberSpecification(wrapper.memberSpecification);
                int returnValue = memberSpecificationDialog.showDialog();
                if (returnValue == 0) {
                    wrapper.memberSpecification = memberSpecificationDialog.getMemberSpecification();
                    MemberSpecificationsPanel.this.setElementAt(wrapper, MemberSpecificationsPanel.this.list.getSelectedIndex());
                }
            }
        });
        this.addButton(MemberSpecificationsPanel.tip(editButton, "editTip"));
    }

    public void setMemberSpecifications(List fieldSpecifications, List methodSpecifications) {
        int index;
        this.listModel.clear();
        if (fieldSpecifications != null) {
            for (index = 0; index < fieldSpecifications.size(); ++index) {
                this.listModel.addElement(new MyMemberSpecificationWrapper((MemberSpecification)fieldSpecifications.get(index), true));
            }
        }
        if (methodSpecifications != null) {
            for (index = 0; index < methodSpecifications.size(); ++index) {
                this.listModel.addElement(new MyMemberSpecificationWrapper((MemberSpecification)methodSpecifications.get(index), false));
            }
        }
        this.enableSelectionButtons();
    }

    public List getMemberSpecifications(boolean isField) {
        int size = this.listModel.size();
        if (size == 0) {
            return null;
        }
        ArrayList<MemberSpecification> memberSpecifications = new ArrayList<MemberSpecification>(size);
        for (int index = 0; index < size; ++index) {
            MyMemberSpecificationWrapper wrapper = (MyMemberSpecificationWrapper)this.listModel.get(index);
            if (wrapper.isField != isField) continue;
            memberSpecifications.add(wrapper.memberSpecification);
        }
        return memberSpecifications;
    }

    private static JComponent tip(JComponent component, String messageKey) {
        component.setToolTipText(MemberSpecificationsPanel.msg(messageKey));
        return component;
    }

    private static String msg(String messageKey) {
        return GUIResources.getMessage(messageKey);
    }

    private static class MyMemberSpecificationWrapper {
        public MemberSpecification memberSpecification;
        public final boolean isField;

        public MyMemberSpecificationWrapper(MemberSpecification memberSpecification, boolean isField) {
            this.memberSpecification = memberSpecification;
            this.isField = isField;
        }
    }

    private static class MyListCellRenderer
    implements ListCellRenderer {
        private final JLabel label = new JLabel();

        private MyListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            MyMemberSpecificationWrapper wrapper = (MyMemberSpecificationWrapper)value;
            MemberSpecification option = wrapper.memberSpecification;
            String name = option.name;
            String descriptor = option.descriptor;
            this.label.setText(wrapper.isField ? (descriptor == null ? (name == null ? "<fields>" : "*** " + name) : ClassUtil.externalFullFieldDescription((int)0, (String)(name == null ? "*" : name), (String)descriptor)) : (descriptor == null ? (name == null ? "<methods>" : "*** " + name + "(...)") : ClassUtil.externalFullMethodDescription((String)"<init>", (int)0, (String)(name == null ? "*" : name), (String)descriptor)));
            if (isSelected) {
                this.label.setBackground(list.getSelectionBackground());
                this.label.setForeground(list.getSelectionForeground());
            } else {
                this.label.setBackground(list.getBackground());
                this.label.setForeground(list.getForeground());
            }
            this.label.setOpaque(true);
            return this.label;
        }
    }
}

