/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import proguard.classfile.util.ClassUtil;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;

public class ReTrace
implements MappingProcessor {
    private static final String REGEX_OPTION = "-regex";
    private static final String VERBOSE_OPTION = "-verbose";
    public static final String STACK_TRACE_EXPRESSION = "(?:.*?\\bat\\s+%c.%m\\s*\\(.*?(?::%l)?\\)\\s*)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)";
    private static final String REGEX_CLASS = "\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b";
    private static final String REGEX_CLASS_SLASH = "\\b(?:[A-Za-z0-9_$]+/)*[A-Za-z0-9_$]+\\b";
    private static final String REGEX_LINE_NUMBER = "\\b[0-9]+\\b";
    private static final String REGEX_TYPE = "\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*";
    private static final String REGEX_MEMBER = "<?\\b[A-Za-z0-9_$]+\\b>?";
    private static final String REGEX_ARGUMENTS = "(?:\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*(?:\\s*,\\s*\\b(?:[A-Za-z0-9_$]+\\.)*[A-Za-z0-9_$]+\\b(?:\\[\\])*)*)?";
    private final String regularExpression;
    private final boolean verbose;
    private final File mappingFile;
    private final File stackTraceFile;
    private Map classMap = new HashMap();
    private Map classFieldMap = new HashMap();
    private Map classMethodMap = new HashMap();

    public ReTrace(String regularExpression, boolean verbose, File mappingFile) {
        this(regularExpression, verbose, mappingFile, null);
    }

    public ReTrace(String regularExpression, boolean verbose, File mappingFile, File stackTraceFile) {
        this.regularExpression = regularExpression;
        this.verbose = verbose;
        this.mappingFile = mappingFile;
        this.stackTraceFile = stackTraceFile;
    }

    public void execute() throws IOException {
        int nextIndex;
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        mappingReader.pump((MappingProcessor)this);
        StringBuffer expressionBuffer = new StringBuffer(this.regularExpression.length() + 32);
        char[] expressionTypes = new char[32];
        int expressionTypeCount = 0;
        int index = 0;
        while ((nextIndex = this.regularExpression.indexOf(37, index)) >= 0 && nextIndex != this.regularExpression.length() - 1 && expressionTypeCount != expressionTypes.length) {
            expressionBuffer.append(this.regularExpression.substring(index, nextIndex));
            expressionBuffer.append('(');
            char expressionType = this.regularExpression.charAt(nextIndex + 1);
            switch (expressionType) {
                case 'c': {
                    expressionBuffer.append(REGEX_CLASS);
                    break;
                }
                case 'C': {
                    expressionBuffer.append(REGEX_CLASS_SLASH);
                    break;
                }
                case 'l': {
                    expressionBuffer.append(REGEX_LINE_NUMBER);
                    break;
                }
                case 't': {
                    expressionBuffer.append(REGEX_TYPE);
                    break;
                }
                case 'f': {
                    expressionBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'm': {
                    expressionBuffer.append(REGEX_MEMBER);
                    break;
                }
                case 'a': {
                    expressionBuffer.append(REGEX_ARGUMENTS);
                }
            }
            expressionBuffer.append(')');
            expressionTypes[expressionTypeCount++] = expressionType;
            index = nextIndex + 2;
        }
        expressionBuffer.append(this.regularExpression.substring(index));
        Pattern pattern = Pattern.compile(expressionBuffer.toString());
        LineNumberReader reader = new LineNumberReader(this.stackTraceFile == null ? new InputStreamReader(System.in) : new BufferedReader(new FileReader(this.stackTraceFile)));
        try {
            String line;
            StringBuffer outLine = new StringBuffer(256);
            ArrayList extraOutLines = new ArrayList();
            String className = null;
            block35: while ((line = reader.readLine()) != null) {
                Matcher matcher = pattern.matcher(line);
                if (matcher.matches()) {
                    int lineNumber = 0;
                    String type = null;
                    String arguments = null;
                    block36: for (int expressionTypeIndex = 0; expressionTypeIndex < expressionTypeCount; ++expressionTypeIndex) {
                        int startIndex = matcher.start(expressionTypeIndex + 1);
                        if (startIndex < 0) continue;
                        String match = matcher.group(expressionTypeIndex + 1);
                        char expressionType = expressionTypes[expressionTypeIndex];
                        switch (expressionType) {
                            case 'c': {
                                className = this.originalClassName(match);
                                continue block36;
                            }
                            case 'C': {
                                className = this.originalClassName(ClassUtil.externalClassName((String)match));
                                continue block36;
                            }
                            case 'l': {
                                lineNumber = Integer.parseInt(match);
                                continue block36;
                            }
                            case 't': {
                                type = this.originalType(match);
                                continue block36;
                            }
                            case 'a': {
                                arguments = this.originalArguments(match);
                            }
                        }
                    }
                    int lineIndex = 0;
                    outLine.setLength(0);
                    extraOutLines.clear();
                    for (int expressionTypeIndex = 0; expressionTypeIndex < expressionTypeCount; ++expressionTypeIndex) {
                        int startIndex = matcher.start(expressionTypeIndex + 1);
                        if (startIndex < 0) continue;
                        int endIndex = matcher.end(expressionTypeIndex + 1);
                        String match = matcher.group(expressionTypeIndex + 1);
                        outLine.append(line.substring(lineIndex, startIndex));
                        char expressionType = expressionTypes[expressionTypeIndex];
                        switch (expressionType) {
                            case 'c': {
                                className = this.originalClassName(match);
                                outLine.append(className);
                                break;
                            }
                            case 'C': {
                                className = this.originalClassName(ClassUtil.externalClassName((String)match));
                                outLine.append(ClassUtil.internalClassName((String)className));
                                break;
                            }
                            case 'l': {
                                lineNumber = Integer.parseInt(match);
                                outLine.append(match);
                                break;
                            }
                            case 't': {
                                type = this.originalType(match);
                                outLine.append(type);
                                break;
                            }
                            case 'f': {
                                this.originalFieldName(className, match, type, outLine, extraOutLines);
                                break;
                            }
                            case 'm': {
                                this.originalMethodName(className, match, lineNumber, type, arguments, outLine, extraOutLines);
                                break;
                            }
                            case 'a': {
                                arguments = this.originalArguments(match);
                                outLine.append(arguments);
                            }
                        }
                        lineIndex = endIndex;
                    }
                    outLine.append(line.substring(lineIndex));
                    System.out.println(outLine);
                    int extraLineIndex = 0;
                    while (true) {
                        if (extraLineIndex >= extraOutLines.size()) continue block35;
                        System.out.println(extraOutLines.get(extraLineIndex));
                        ++extraLineIndex;
                    }
                }
                System.out.println(line);
            }
        }
        catch (IOException ex) {
            throw new IOException("Can't read stack trace (" + ex.getMessage() + ")");
        }
        finally {
            if (this.stackTraceFile != null) {
                try {
                    reader.close();
                }
                catch (IOException ex) {}
            }
        }
    }

    private void originalFieldName(String className, String obfuscatedFieldName, String type, StringBuffer outLine, List extraOutLines) {
        Set fieldSet;
        int extraIndent = -1;
        Map fieldMap = (Map)this.classFieldMap.get(className);
        if (fieldMap != null && (fieldSet = (Set)fieldMap.get(obfuscatedFieldName)) != null) {
            for (FieldInfo fieldInfo : fieldSet) {
                if (!fieldInfo.matches(type)) continue;
                if (extraIndent < 0) {
                    extraIndent = outLine.length();
                    if (this.verbose) {
                        outLine.append(fieldInfo.type).append(' ');
                    }
                    outLine.append(fieldInfo.originalName);
                    continue;
                }
                StringBuffer extraBuffer = new StringBuffer();
                for (int counter = 0; counter < extraIndent; ++counter) {
                    extraBuffer.append(' ');
                }
                if (this.verbose) {
                    extraBuffer.append(fieldInfo.type).append(' ');
                }
                extraBuffer.append(fieldInfo.originalName);
                extraOutLines.add(extraBuffer);
            }
        }
        if (extraIndent < 0) {
            outLine.append(obfuscatedFieldName);
        }
    }

    private void originalMethodName(String className, String obfuscatedMethodName, int lineNumber, String type, String arguments, StringBuffer outLine, List extraOutLines) {
        Set methodSet;
        int extraIndent = -1;
        Map methodMap = (Map)this.classMethodMap.get(className);
        if (methodMap != null && (methodSet = (Set)methodMap.get(obfuscatedMethodName)) != null) {
            for (MethodInfo methodInfo : methodSet) {
                if (!methodInfo.matches(lineNumber, type, arguments)) continue;
                if (extraIndent < 0) {
                    extraIndent = outLine.length();
                    if (this.verbose) {
                        outLine.append(methodInfo.type).append(' ');
                    }
                    outLine.append(methodInfo.originalName);
                    if (!this.verbose) continue;
                    outLine.append('(').append(methodInfo.arguments).append(')');
                    continue;
                }
                StringBuffer extraBuffer = new StringBuffer();
                for (int counter = 0; counter < extraIndent; ++counter) {
                    extraBuffer.append(' ');
                }
                if (this.verbose) {
                    extraBuffer.append(methodInfo.type).append(' ');
                }
                extraBuffer.append(methodInfo.originalName);
                if (this.verbose) {
                    extraBuffer.append('(').append(methodInfo.arguments).append(')');
                }
                extraOutLines.add(extraBuffer);
            }
        }
        if (extraIndent < 0) {
            outLine.append(obfuscatedMethodName);
        }
    }

    private String originalArguments(String obfuscatedArguments) {
        int endIndex;
        StringBuffer originalArguments = new StringBuffer();
        int startIndex = 0;
        while ((endIndex = obfuscatedArguments.indexOf(44, startIndex)) >= 0) {
            originalArguments.append(this.originalType(obfuscatedArguments.substring(startIndex, endIndex).trim())).append(',');
            startIndex = endIndex + 1;
        }
        originalArguments.append(this.originalType(obfuscatedArguments.substring(startIndex).trim()));
        return originalArguments.toString();
    }

    private String originalType(String obfuscatedType) {
        int index = obfuscatedType.indexOf(91);
        return index >= 0 ? this.originalClassName(obfuscatedType.substring(0, index)) + obfuscatedType.substring(index) : this.originalClassName(obfuscatedType);
    }

    private String originalClassName(String obfuscatedClassName) {
        String originalClassName = (String)this.classMap.get(obfuscatedClassName);
        return originalClassName != null ? originalClassName : obfuscatedClassName;
    }

    public boolean processClassMapping(String className, String newClassName) {
        this.classMap.put(newClassName, className);
        return true;
    }

    public void processFieldMapping(String className, String fieldType, String fieldName, String newFieldName) {
        LinkedHashSet<FieldInfo> fieldSet;
        HashMap<String, LinkedHashSet<FieldInfo>> fieldMap = (HashMap<String, LinkedHashSet<FieldInfo>>)this.classFieldMap.get(className);
        if (fieldMap == null) {
            fieldMap = new HashMap<String, LinkedHashSet<FieldInfo>>();
            this.classFieldMap.put(className, fieldMap);
        }
        if ((fieldSet = (LinkedHashSet<FieldInfo>)fieldMap.get(newFieldName)) == null) {
            fieldSet = new LinkedHashSet<FieldInfo>();
            fieldMap.put(newFieldName, fieldSet);
        }
        fieldSet.add(new FieldInfo(fieldType, fieldName));
    }

    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newMethodName) {
        LinkedHashSet<MethodInfo> methodSet;
        HashMap<String, LinkedHashSet<MethodInfo>> methodMap = (HashMap<String, LinkedHashSet<MethodInfo>>)this.classMethodMap.get(className);
        if (methodMap == null) {
            methodMap = new HashMap<String, LinkedHashSet<MethodInfo>>();
            this.classMethodMap.put(className, methodMap);
        }
        if ((methodSet = (LinkedHashSet<MethodInfo>)methodMap.get(newMethodName)) == null) {
            methodSet = new LinkedHashSet<MethodInfo>();
            methodMap.put(newMethodName, methodSet);
        }
        methodSet.add(new MethodInfo(firstLineNumber, lastLineNumber, methodReturnType, methodArguments, methodName));
    }

    public static void main(String[] args) {
        int argumentIndex;
        if (args.length < 1) {
            System.err.println("Usage: java proguard.ReTrace [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        String regularExpresssion = STACK_TRACE_EXPRESSION;
        boolean verbose = false;
        for (argumentIndex = 0; argumentIndex < args.length; ++argumentIndex) {
            String arg = args[argumentIndex];
            if (arg.equals(REGEX_OPTION)) {
                regularExpresssion = args[++argumentIndex];
                continue;
            }
            if (!arg.equals(VERBOSE_OPTION)) break;
            verbose = true;
        }
        if (argumentIndex >= args.length) {
            System.err.println("Usage: java proguard.ReTrace [-regex <regex>] [-verbose] <mapping_file> [<stacktrace_file>]");
            System.exit(-1);
        }
        File mappingFile = new File(args[argumentIndex++]);
        File stackTraceFile = argumentIndex < args.length ? new File(args[argumentIndex]) : null;
        ReTrace reTrace = new ReTrace(regularExpresssion, verbose, mappingFile, stackTraceFile);
        try {
            reTrace.execute();
        }
        catch (IOException ex) {
            if (verbose) {
                ex.printStackTrace();
            } else {
                System.err.println("Error: " + ex.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }

    private static class MethodInfo {
        private int firstLineNumber;
        private int lastLineNumber;
        private String type;
        private String arguments;
        private String originalName;

        private MethodInfo(int firstLineNumber, int lastLineNumber, String type, String arguments, String originalName) {
            this.firstLineNumber = firstLineNumber;
            this.lastLineNumber = lastLineNumber;
            this.type = type;
            this.arguments = arguments;
            this.originalName = originalName;
        }

        private boolean matches(int lineNumber, String type, String arguments) {
            return !(lineNumber != 0 && (this.firstLineNumber > lineNumber || lineNumber > this.lastLineNumber) && this.lastLineNumber != 0 || type != null && !type.equals(this.type) || arguments != null && !arguments.equals(this.arguments));
        }
    }

    private static class FieldInfo {
        private String type;
        private String originalName;

        private FieldInfo(String type, String originalName) {
            this.type = type;
            this.originalName = originalName;
        }

        private boolean matches(String type) {
            return type == null || type.equals(this.type);
        }
    }
}

