/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import proguard.obfuscate.MappingProcessor;
import proguard.retrace.FrameInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrameRemapper
implements MappingProcessor {
    private final Map<String, String> classMap = new HashMap<String, String>();
    private final Map<String, Map<String, Set<FieldInfo>>> classFieldMap = new HashMap<String, Map<String, Set<FieldInfo>>>();
    private final Map<String, Map<String, Set<MethodInfo>>> classMethodMap = new HashMap<String, Map<String, Set<MethodInfo>>>();

    public List<FrameInfo> transform(FrameInfo obfuscatedFrame) {
        String originalClassName = this.originalClassName(obfuscatedFrame.getClassName());
        if (originalClassName == null) {
            return null;
        }
        ArrayList<FrameInfo> originalFrames = new ArrayList<FrameInfo>();
        this.transformFieldInfo(obfuscatedFrame, originalClassName, originalFrames);
        this.transformMethodInfo(obfuscatedFrame, originalClassName, originalFrames);
        if (originalFrames.isEmpty()) {
            originalFrames.add(new FrameInfo(originalClassName, this.sourceFileName(originalClassName), obfuscatedFrame.getLineNumber(), obfuscatedFrame.getType(), obfuscatedFrame.getFieldName(), obfuscatedFrame.getMethodName(), obfuscatedFrame.getArguments()));
        }
        return originalFrames;
    }

    private void transformFieldInfo(FrameInfo obfuscatedFrame, String originalClassName, List<FrameInfo> originalFieldFrames) {
        String obfuscatedFieldName;
        Set<FieldInfo> fieldSet;
        Map<String, Set<FieldInfo>> fieldMap = this.classFieldMap.get(originalClassName);
        if (fieldMap != null && (fieldSet = fieldMap.get(obfuscatedFieldName = obfuscatedFrame.getFieldName())) != null) {
            String obfuscatedType = obfuscatedFrame.getType();
            String originalType = obfuscatedType == null ? null : this.originalType(obfuscatedType);
            for (FieldInfo fieldInfo : fieldSet) {
                if (!fieldInfo.matches(originalType)) continue;
                originalFieldFrames.add(new FrameInfo(fieldInfo.originalClassName, this.sourceFileName(fieldInfo.originalClassName), obfuscatedFrame.getLineNumber(), fieldInfo.originalType, fieldInfo.originalName, obfuscatedFrame.getMethodName(), obfuscatedFrame.getArguments()));
            }
        }
    }

    private void transformMethodInfo(FrameInfo obfuscatedFrame, String originalClassName, List<FrameInfo> originalMethodFrames) {
        String obfuscatedMethodName;
        Set<MethodInfo> methodSet;
        Map<String, Set<MethodInfo>> methodMap = this.classMethodMap.get(originalClassName);
        if (methodMap != null && (methodSet = methodMap.get(obfuscatedMethodName = obfuscatedFrame.getMethodName())) != null) {
            int obfuscatedLineNumber = obfuscatedFrame.getLineNumber();
            String obfuscatedType = obfuscatedFrame.getType();
            String originalType = obfuscatedType == null ? null : this.originalType(obfuscatedType);
            String obfuscatedArguments = obfuscatedFrame.getArguments();
            String originalArguments = obfuscatedArguments == null ? null : this.originalArguments(obfuscatedArguments);
            for (MethodInfo methodInfo : methodSet) {
                if (!methodInfo.matches(obfuscatedLineNumber, originalType, originalArguments)) continue;
                int lineNumber = obfuscatedFrame.getLineNumber();
                if (methodInfo.originalFirstLineNumber != methodInfo.obfuscatedFirstLineNumber) {
                    lineNumber = methodInfo.originalLastLineNumber != 0 && methodInfo.originalLastLineNumber != methodInfo.originalFirstLineNumber && methodInfo.obfuscatedFirstLineNumber != 0 && lineNumber != 0 ? methodInfo.originalFirstLineNumber - methodInfo.obfuscatedFirstLineNumber + lineNumber : methodInfo.originalFirstLineNumber;
                }
                originalMethodFrames.add(new FrameInfo(methodInfo.originalClassName, this.sourceFileName(methodInfo.originalClassName), lineNumber, methodInfo.originalType, obfuscatedFrame.getFieldName(), methodInfo.originalName, methodInfo.originalArguments));
            }
        }
    }

    private String originalArguments(String obfuscatedArguments) {
        int endIndex;
        StringBuilder originalArguments = new StringBuilder();
        int startIndex = 0;
        while ((endIndex = obfuscatedArguments.indexOf(44, startIndex)) >= 0) {
            originalArguments.append(this.originalType(obfuscatedArguments.substring(startIndex, endIndex).trim())).append(',');
            startIndex = endIndex + 1;
        }
        originalArguments.append(this.originalType(obfuscatedArguments.substring(startIndex).trim()));
        return originalArguments.toString();
    }

    private String originalType(String obfuscatedType) {
        int index = obfuscatedType.indexOf(91);
        return index >= 0 ? this.originalClassName(obfuscatedType.substring(0, index)) + obfuscatedType.substring(index) : this.originalClassName(obfuscatedType);
    }

    private String originalClassName(String obfuscatedClassName) {
        String originalClassName = this.classMap.get(obfuscatedClassName);
        return originalClassName != null ? originalClassName : obfuscatedClassName;
    }

    private String sourceFileName(String className) {
        int index1 = className.lastIndexOf(46) + 1;
        int index2 = className.indexOf(36, index1);
        return (index2 > 0 ? className.substring(index1, index2) : className.substring(index1)) + ".java";
    }

    public boolean processClassMapping(String className, String newClassName) {
        this.classMap.put(newClassName, className);
        return true;
    }

    public void processFieldMapping(String className, String fieldType, String fieldName, String newClassName, String newFieldName) {
        Set<FieldInfo> fieldSet;
        Map<String, Set<FieldInfo>> fieldMap = this.classFieldMap.get(newClassName);
        if (fieldMap == null) {
            fieldMap = new HashMap<String, Set<FieldInfo>>();
            this.classFieldMap.put(newClassName, fieldMap);
        }
        if ((fieldSet = fieldMap.get(newFieldName)) == null) {
            fieldSet = new LinkedHashSet<FieldInfo>();
            fieldMap.put(newFieldName, fieldSet);
        }
        fieldSet.add(new FieldInfo(className, fieldType, fieldName));
    }

    public void processMethodMapping(String className, int firstLineNumber, int lastLineNumber, String methodReturnType, String methodName, String methodArguments, String newClassName, int newFirstLineNumber, int newLastLineNumber, String newMethodName) {
        Set<MethodInfo> methodSet;
        Map<String, Set<MethodInfo>> methodMap = this.classMethodMap.get(newClassName);
        if (methodMap == null) {
            methodMap = new HashMap<String, Set<MethodInfo>>();
            this.classMethodMap.put(newClassName, methodMap);
        }
        if ((methodSet = methodMap.get(newMethodName)) == null) {
            methodSet = new LinkedHashSet<MethodInfo>();
            methodMap.put(newMethodName, methodSet);
        }
        methodSet.add(new MethodInfo(newFirstLineNumber, newLastLineNumber, className, firstLineNumber, lastLineNumber, methodReturnType, methodName, methodArguments));
    }

    private static class MethodInfo {
        private final int obfuscatedFirstLineNumber;
        private final int obfuscatedLastLineNumber;
        private final String originalClassName;
        private final int originalFirstLineNumber;
        private final int originalLastLineNumber;
        private final String originalType;
        private final String originalName;
        private final String originalArguments;

        private MethodInfo(int obfuscatedFirstLineNumber, int obfuscatedLastLineNumber, String originalClassName, int originalFirstLineNumber, int originalLastLineNumber, String originalType, String originalName, String originalArguments) {
            this.obfuscatedFirstLineNumber = obfuscatedFirstLineNumber;
            this.obfuscatedLastLineNumber = obfuscatedLastLineNumber;
            this.originalType = originalType;
            this.originalArguments = originalArguments;
            this.originalClassName = originalClassName;
            this.originalName = originalName;
            this.originalFirstLineNumber = originalFirstLineNumber;
            this.originalLastLineNumber = originalLastLineNumber;
        }

        private boolean matches(int obfuscatedLineNumber, String originalType, String originalArguments) {
            return !(!(obfuscatedLineNumber == 0 ? this.obfuscatedLastLineNumber == 0 : this.obfuscatedFirstLineNumber <= obfuscatedLineNumber && obfuscatedLineNumber <= this.obfuscatedLastLineNumber) || originalType != null && !originalType.equals(this.originalType) || originalArguments != null && !originalArguments.equals(this.originalArguments));
        }
    }

    private static class FieldInfo {
        private final String originalClassName;
        private final String originalType;
        private final String originalName;

        private FieldInfo(String originalClassName, String originalType, String originalName) {
            this.originalClassName = originalClassName;
            this.originalType = originalType;
            this.originalName = originalName;
        }

        private boolean matches(String originalType) {
            return originalType == null || originalType.equals(this.originalType);
        }
    }
}

