/*
 * Decompiled with CFR 0.152.
 */
package proguard.retrace;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Iterator;
import proguard.obfuscate.MappingProcessor;
import proguard.obfuscate.MappingReader;
import proguard.retrace.FrameInfo;
import proguard.retrace.FramePattern;
import proguard.retrace.FrameRemapper;

public class ReTrace {
    private static final String USAGE = "Usage: java proguard.ReTrace [-regex <regex>] [-verbose] <mapping_file> [<stacktrace_file>]";
    private static final String REGEX_OPTION = "-regex";
    private static final String VERBOSE_OPTION = "-verbose";
    public static final String STACK_TRACE_EXPRESSION = "(?:.*?\\bat\\s+%c\\.%m\\s*\\(%s(?::%l)?\\)\\s*(?:~\\[.*\\])?)|(?:(?:.*?[:\"]\\s+)?%c(?::.*)?)";
    private final String regularExpression;
    private final boolean verbose;
    private final File mappingFile;

    public ReTrace(String regularExpression, boolean verbose, File mappingFile) {
        this.regularExpression = regularExpression;
        this.verbose = verbose;
        this.mappingFile = mappingFile;
    }

    public void retrace(LineNumberReader stackTraceReader, PrintWriter stackTraceWriter) throws IOException {
        String obfuscatedLine;
        FramePattern pattern = new FramePattern(this.regularExpression, this.verbose);
        FrameRemapper mapper = new FrameRemapper();
        MappingReader mappingReader = new MappingReader(this.mappingFile);
        mappingReader.pump((MappingProcessor)mapper);
        while ((obfuscatedLine = stackTraceReader.readLine()) != null) {
            FrameInfo obfuscatedFrame = pattern.parse(obfuscatedLine);
            if (obfuscatedFrame != null) {
                Iterator<FrameInfo> retracedFrames = mapper.transform(obfuscatedFrame).iterator();
                String previousLine = null;
                while (retracedFrames.hasNext()) {
                    String trimmedLine;
                    FrameInfo retracedFrame = retracedFrames.next();
                    String retracedLine = pattern.format(obfuscatedLine, retracedFrame);
                    String string = trimmedLine = previousLine != null && obfuscatedFrame.getLineNumber() == 0 ? this.trim(retracedLine, previousLine) : retracedLine;
                    if (trimmedLine != null) {
                        stackTraceWriter.println(trimmedLine);
                    }
                    previousLine = retracedLine;
                }
                continue;
            }
            stackTraceWriter.println(obfuscatedLine);
        }
        stackTraceWriter.flush();
    }

    private String trim(String string1, String string2) {
        StringBuilder line = new StringBuilder(string1);
        int trimEnd = this.firstNonCommonIndex(string1, string2);
        if (trimEnd == string1.length()) {
            return null;
        }
        trimEnd = this.lastNonIdentifierIndex(string1, trimEnd) + 1;
        for (int index = 0; index < trimEnd; ++index) {
            if (Character.isWhitespace(string1.charAt(index))) continue;
            line.setCharAt(index, ' ');
        }
        return line.toString();
    }

    private int firstNonCommonIndex(String string1, String string2) {
        int index;
        for (index = 0; index < string1.length() && index < string2.length() && string1.charAt(index) == string2.charAt(index); ++index) {
        }
        return index;
    }

    private int lastNonIdentifierIndex(String line, int index) {
        while (index >= 0 && Character.isJavaIdentifierPart(line.charAt(index))) {
            --index;
        }
        return index;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        int argumentIndex;
        if (args.length < 1) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        String regularExpresssion = STACK_TRACE_EXPRESSION;
        boolean verbose = false;
        for (argumentIndex = 0; argumentIndex < args.length; ++argumentIndex) {
            String arg = args[argumentIndex];
            if (arg.equals(REGEX_OPTION)) {
                regularExpresssion = args[++argumentIndex];
                continue;
            }
            if (!arg.equals(VERBOSE_OPTION)) break;
            verbose = true;
        }
        if (argumentIndex >= args.length) {
            System.err.println(USAGE);
            System.exit(-1);
        }
        File mappingFile = new File(args[argumentIndex++]);
        File stackTraceFile = argumentIndex < args.length ? new File(args[argumentIndex]) : null;
        try {
            LineNumberReader reader = new LineNumberReader(new BufferedReader(new InputStreamReader(stackTraceFile == null ? System.in : new FileInputStream(stackTraceFile), "UTF-8")));
            PrintWriter writer = new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "UTF-8"));
            try {
                new ReTrace(regularExpresssion, verbose, mappingFile).retrace(reader, writer);
            }
            finally {
                if (stackTraceFile != null) {
                    reader.close();
                }
            }
        }
        catch (IOException ex) {
            if (verbose) {
                ex.printStackTrace();
            } else {
                System.err.println("Error: " + ex.getMessage());
            }
            System.exit(1);
        }
        System.exit(0);
    }
}

