/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import net.sf.qualitycheck.Check;
import net.sf.qualitytest.blueprint.Blueprint;
import net.sf.qualitytest.blueprint.BlueprintConfiguration;
import net.sf.qualitytest.blueprint.BlueprintSession;
import net.sf.qualitytest.blueprint.CreationStrategy;

class BlueprintInvocationHandler
implements InvocationHandler {
    private final BlueprintConfiguration config;
    private final BlueprintSession session;

    public BlueprintInvocationHandler(@Nonnull BlueprintConfiguration config, @Nonnull BlueprintSession session) {
        this.config = (BlueprintConfiguration)Check.notNull((Object)config, (String)"config");
        this.session = (BlueprintSession)Check.notNull((Object)session, (String)"session");
    }

    @Override
    public Object invoke(Object instance, Method method, Object[] parameters) throws Throwable {
        CreationStrategy<?> creator = this.config.findCreationStrategyForMethod(method);
        Object result = creator != null ? creator.createValue(method.getReturnType(), this.config, this.session) : Blueprint.construct(method.getReturnType(), this.config, this.session);
        return result;
    }
}

