/*
 * Decompiled with CFR 0.152.
 */
package net.sf.qualitytest.blueprint;

import javax.annotation.Nonnull;
import net.sf.qualitycheck.ArgumentsChecked;
import net.sf.qualitycheck.Check;
import net.sf.qualitycheck.Throws;
import net.sf.qualitycheck.exception.IllegalNotNullArgumentException;
import net.sf.qualitytest.blueprint.CreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.NullValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomBooleanValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomByteValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomCharValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomDoubleValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomEnumCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomFloatValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomIntValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomLongValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.RandomShortValueCreationStrategy;
import net.sf.qualitytest.blueprint.strategy.creation.SingleValueCreationStrategy;

public final class Create {
    public static <T> CreationStrategy<T> nil() {
        return new NullValueCreationStrategy();
    }

    public static CreationStrategy<Boolean> randomBoolean() {
        return new RandomBooleanValueCreationStrategy();
    }

    public static CreationStrategy<Byte> randomByte() {
        return new RandomByteValueCreationStrategy();
    }

    public static CreationStrategy<Character> randomChar() {
        return new RandomCharValueCreationStrategy();
    }

    public static CreationStrategy<Double> randomDouble() {
        return new RandomDoubleValueCreationStrategy();
    }

    public static CreationStrategy<Enum<?>> randomEnum() {
        return new RandomEnumCreationStrategy();
    }

    public static CreationStrategy<Float> randomFloat() {
        return new RandomFloatValueCreationStrategy();
    }

    public static CreationStrategy<Integer> randomInteger() {
        return new RandomIntValueCreationStrategy();
    }

    public static CreationStrategy<Long> randomLong() {
        return new RandomLongValueCreationStrategy();
    }

    public static CreationStrategy<Short> randomShort() {
        return new RandomShortValueCreationStrategy();
    }

    @ArgumentsChecked
    @Throws(value={IllegalNotNullArgumentException.class})
    public static <T> CreationStrategy<T> value(@Nonnull T value) {
        return new SingleValueCreationStrategy<Object>(Check.notNull(value, (String)"value"));
    }

    private Create() {
    }
}

