/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.AnnotationTypeMismatchException;
import java.lang.annotation.IncompleteAnnotationException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.sf.retrotranslator.android.asm.AnnotationVisitor;
import net.sf.retrotranslator.android.extra.java.lang._Class;
import net.sf.retrotranslator.android.impl.AnnotationArray;
import net.sf.retrotranslator.android.impl.AnnotationHandler;
import net.sf.retrotranslator.android.impl.AnnotationValue;
import net.sf.retrotranslator.android.impl.ClassDescriptor;
import net.sf.retrotranslator.android.impl.ClassTypeElement;
import net.sf.retrotranslator.android.impl.EmptyVisitor;
import net.sf.retrotranslator.android.impl.EnumValue;
import net.sf.retrotranslator.android.impl.GenericArrayTypeImpl;
import net.sf.retrotranslator.android.impl.LazyList;
import net.sf.retrotranslator.android.impl.LazyValue;
import net.sf.retrotranslator.android.impl.MethodDescriptor;
import net.sf.retrotranslator.android.impl.ParameterizedTypeImpl;
import net.sf.retrotranslator.android.impl.RuntimeTools;
import net.sf.retrotranslator.android.impl.TypeArgument;
import net.sf.retrotranslator.android.impl.TypeDescriptor;
import net.sf.retrotranslator.android.impl.WildcardTypeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AnnotatedElementDescriptor
extends EmptyVisitor {
    private static final Annotation[] EMPTY = new Annotation[0];
    protected static final EmptyVisitor EMPTY_VISITOR = new EmptyVisitor();
    protected int access;
    private LazyList<AnnotationValue, Annotation> declaredAnnotations = new LazyList<AnnotationValue, Annotation>(){

        @Override
        protected Annotation resolve(AnnotationValue input) {
            return AnnotatedElementDescriptor.this.createAnnotation(input);
        }

        protected Annotation[] newArray(int size) {
            return new Annotation[size];
        }
    };
    private LazyValue<LazyList<AnnotationValue, Annotation>, Annotation[]> annotations = new LazyValue<LazyList<AnnotationValue, Annotation>, Annotation[]>(this.declaredAnnotations){

        @Override
        protected Annotation[] resolve(LazyList<AnnotationValue, Annotation> input) {
            return AnnotatedElementDescriptor.this.createAnnotations(input.getLive());
        }
    };

    public boolean isAccess(int mask) {
        return (this.access & mask) != 0;
    }

    public boolean isAnnotationPresent(Class annotationType) {
        for (Annotation annotation : this.annotations.get()) {
            if (!annotationType.isInstance(annotation)) continue;
            return true;
        }
        return false;
    }

    public Annotation getAnnotation(Class annotationType) {
        for (Annotation annotation : this.annotations.get()) {
            if (!annotationType.isInstance(annotation)) continue;
            return annotation;
        }
        return null;
    }

    public Annotation[] getAnnotations() {
        Annotation[] result = this.annotations.get();
        return result.length == 0 ? result : (Annotation[])result.clone();
    }

    public Annotation[] getDeclaredAnnotations() {
        return this.declaredAnnotations.getClone();
    }

    public abstract String getName();

    public abstract String getDesc();

    public abstract ClassDescriptor getClassDescriptor();

    public abstract String getInfo();

    protected abstract TypeVariable findTypeVariable(String var1);

    protected abstract Annotation[] createAnnotations(Annotation[] var1);

    protected Annotation[] createAnnotations(List<AnnotationValue> values) {
        if (values == null) {
            return EMPTY;
        }
        Annotation[] result = new Annotation[values.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createAnnotation(values.get(i));
        }
        return result;
    }

    @Override
    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        AnnotationValue value = new AnnotationValue(desc);
        this.declaredAnnotations.add(value);
        return value;
    }

    private ClassLoader getClassLoader() {
        return this.getClassDescriptor().getTarget().getClassLoader();
    }

    protected Class getClassByInternalName(String name) {
        name = RuntimeTools.getDisplayClassName(name);
        try {
            return Class.forName(name, false, this.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new TypeNotPresentException(name, e);
        }
    }

    protected Class getClassByType(net.sf.retrotranslator.android.asm.Type type) {
        Class baseClass = RuntimeTools.getBaseClass(type);
        if (baseClass != null) {
            return baseClass;
        }
        return this.getClassByInternalName(type.getSort() == 9 ? type.getDescriptor() : type.getInternalName());
    }

    private Class getClassByDesc(String desc) {
        return this.getClassByType(net.sf.retrotranslator.android.asm.Type.getType(desc));
    }

    public Type[] createTypes(List<TypeDescriptor> descriptors) {
        if (descriptors == null) {
            return null;
        }
        Type[] result = new Type[descriptors.size()];
        Iterator<TypeDescriptor> iterator = descriptors.iterator();
        for (int i = 0; i < result.length; ++i) {
            result[i] = this.createType(iterator.next());
        }
        return result;
    }

    public Type createType(TypeDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        if (descriptor.arrayType != null) {
            return new GenericArrayTypeImpl(this.createType(descriptor.arrayType));
        }
        if (descriptor.typeVariable != null) {
            return this.findTypeVariable(descriptor.typeVariable);
        }
        LinkedList<ClassTypeElement> elements = descriptor.elements;
        if (elements != null) {
            return this.createClassType(elements.toArray(new ClassTypeElement[elements.size()]));
        }
        return RuntimeTools.getBaseClass(descriptor.baseType);
    }

    private Type createClassType(ClassTypeElement[] typeElements) {
        String className = null;
        for (ClassTypeElement typeElement : typeElements) {
            className = (className == null ? "" : className + "$") + typeElement.getName();
        }
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class Element {
            Class rawType;
            List<TypeArgument> arguments;

            public Element(Class rawType, List<TypeArgument> arguments) {
                this.rawType = rawType;
                this.arguments = arguments;
            }
        }
        LinkedList<Element> elements = new LinkedList<Element>();
        Class currentClass = this.getClassByInternalName(className);
        for (int i = typeElements.length - 1; i >= 0; --i) {
            elements.addFirst(new Element(currentClass, typeElements[i].getArguments()));
            currentClass = _Class.getDeclaringClass(currentClass);
            if (currentClass == null) break;
        }
        Type result = ((Element)elements.getFirst()).arguments.isEmpty() ? null : currentClass;
        for (Element element : elements) {
            result = result == null && element.arguments.isEmpty() ? element.rawType : new ParameterizedTypeImpl(this.createArguments(element.arguments), element.rawType, result);
        }
        return result;
    }

    private Type[] createArguments(List<TypeArgument> arguments) {
        Type[] result = new Type[arguments.size()];
        Iterator<TypeArgument> iterator = arguments.iterator();
        for (int i = 0; i < result.length; ++i) {
            TypeArgument argument = iterator.next();
            result[i] = argument.wildcard == '=' ? this.createType(argument.descriptor) : new WildcardTypeImpl(argument.wildcard == '+', this.getLazyType(argument.descriptor));
        }
        return result;
    }

    private Annotation createAnnotation(AnnotationValue annotationValue) {
        Class[] interfaces;
        ClassLoader classLoader;
        Class annotationType = this.getClassByDesc(annotationValue.getDesc());
        StringBuffer buffer = new StringBuffer("@").append(annotationType.getName()).append('(');
        HashMap<String, Object> values = new HashMap<String, Object>();
        boolean isFirst = true;
        for (MethodDescriptor descriptor : ClassDescriptor.getInstance(annotationType).getMethodDescriptors()) {
            Object resolvedValue;
            if (descriptor.getName().equals("<clinit>")) continue;
            if (isFirst) {
                isFirst = false;
            } else {
                buffer.append(", ");
            }
            String elementName = descriptor.getName();
            Object elementValue = annotationValue.getElement(elementName);
            Object object = resolvedValue = elementValue == null ? descriptor.getDefaultValue() : this.resolveValue(elementValue, descriptor.getReturnType(), descriptor);
            if (resolvedValue == null) {
                throw new IncompleteAnnotationException(annotationType, elementName);
            }
            values.put(elementName, resolvedValue);
            buffer.append(elementName).append('=');
            AnnotatedElementDescriptor.append(buffer, resolvedValue);
        }
        buffer.append(")");
        if (Annotation.class.isAssignableFrom(annotationType)) {
            classLoader = this.getClassLoader();
            interfaces = new Class[]{annotationType};
        } else {
            classLoader = this.getProxyClassLoader(annotationType);
            interfaces = new Class[]{annotationType, Annotation.class};
        }
        return (Annotation)Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new AnnotationHandler(annotationType, buffer.toString(), values));
    }

    private ClassLoader getProxyClassLoader(Class annotationType) {
        try {
            if (Annotation.class == Class.forName(Annotation.class.getName(), false, this.getClassLoader())) {
                return this.getClassLoader();
            }
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        try {
            if (annotationType == Class.forName(annotationType.getName(), false, Annotation.class.getClassLoader())) {
                return Annotation.class.getClassLoader();
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return this.getClassLoader();
    }

    protected Object resolveValue(Object value, Class type, MethodDescriptor descriptor) {
        if (value == null) {
            return null;
        }
        if (value instanceof net.sf.retrotranslator.android.asm.Type) {
            value = this.getClassByType((net.sf.retrotranslator.android.asm.Type)value);
        } else if (value instanceof EnumValue) {
            EnumValue enumValue = (EnumValue)value;
            value = this.getEnumValue(this.getClassByDesc(enumValue.getDescriptor()), enumValue.getValue());
        } else if (value instanceof AnnotationValue) {
            value = this.createAnnotation((AnnotationValue)value);
        } else if (value instanceof AnnotationArray) {
            AnnotationArray array = (AnnotationArray)value;
            Class<?> componentType = type.getComponentType();
            List<Object> values = array.getValues();
            value = Array.newInstance(componentType, values.size());
            for (int i = Array.getLength(value) - 1; i >= 0; --i) {
                Array.set(value, i, this.resolveValue(values.get(i), componentType, descriptor));
            }
        }
        if (!type.isPrimitive() && !type.isInstance(value)) {
            throw new AnnotationTypeMismatchException(descriptor.getMethod(), type.getName());
        }
        return value;
    }

    private Object getEnumValue(Class enumType, String name) {
        try {
            return Enum.valueOf(enumType, name);
        }
        catch (IllegalArgumentException e) {
            try {
                return enumType.getMethod("valueOf", String.class).invoke(null, name);
            }
            catch (Exception ex) {
                throw e;
            }
        }
    }

    private static void append(StringBuffer buffer, Object value) {
        if (value.getClass().isArray()) {
            buffer.append('[');
            int length = Array.getLength(value);
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    buffer.append(", ");
                }
                AnnotatedElementDescriptor.append(buffer, Array.get(value, i));
            }
            buffer.append(']');
        } else {
            buffer.append(value);
        }
    }

    protected LazyValue<TypeDescriptor, Type> getLazyType(TypeDescriptor descriptor) {
        if (descriptor == null) {
            return null;
        }
        return new LazyValue<TypeDescriptor, Type>(descriptor){

            @Override
            protected Type resolve(TypeDescriptor input) {
                return AnnotatedElementDescriptor.this.createType(input);
            }
        };
    }

    protected LazyList<TypeDescriptor, Type> getLazyList() {
        return new LazyList<TypeDescriptor, Type>(){

            @Override
            protected Type resolve(TypeDescriptor descriptor) {
                return AnnotatedElementDescriptor.this.createType(descriptor);
            }

            protected Type[] newArray(int size) {
                return new Type[size];
            }
        };
    }
}

