/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.lang.ref.SoftReference;
import java.lang.reflect.MalformedParameterizedTypeException;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.sf.retrotranslator.android.asm.ClassReader;
import net.sf.retrotranslator.android.asm.FieldVisitor;
import net.sf.retrotranslator.android.asm.MethodVisitor;
import net.sf.retrotranslator.android.asm.signature.SignatureReader;
import net.sf.retrotranslator.android.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.android.extra.java.lang._Class;
import net.sf.retrotranslator.android.impl.BytecodeTransformer;
import net.sf.retrotranslator.android.impl.FieldDescriptor;
import net.sf.retrotranslator.android.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.android.impl.LazyList;
import net.sf.retrotranslator.android.impl.LazyValue;
import net.sf.retrotranslator.android.impl.MethodDescriptor;
import net.sf.retrotranslator.android.impl.RuntimeTools;
import net.sf.retrotranslator.android.impl.SignatureList;
import net.sf.retrotranslator.android.impl.TypeDescriptor;
import net.sf.retrotranslator.android.impl.WeakIdentityTable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassDescriptor
extends GenericDeclarationDescriptor {
    private static final WeakIdentityTable<Class, String> metadataTable = new WeakIdentityTable();
    private static SoftReference<Map<Class, ClassDescriptor>> cache;
    private static BytecodeTransformer bytecodeTransformer;
    private String name;
    private Class target;
    private String declaringClass;
    private String enclosingClass;
    private String enclosingMethod;
    private LazyList<TypeDescriptor, Type> genericInterfaces;
    private LazyValue<TypeDescriptor, Type> genericSuperclass;
    private Map<String, FieldDescriptor> fieldDescriptors = new HashMap<String, FieldDescriptor>();
    private Map<String, MethodDescriptor> methodDescriptors = new HashMap<String, MethodDescriptor>();

    public ClassDescriptor(Class target, byte[] bytecode) {
        this.target = target;
        if (bytecode != null) {
            if (bytecodeTransformer != null) {
                bytecode = bytecodeTransformer.transform(bytecode, 0, bytecode.length);
            }
            new ClassReader(bytecode).accept(this, true);
        } else {
            this.visit(0, target.getModifiers(), net.sf.retrotranslator.android.asm.Type.getInternalName(target), null, null, null);
        }
    }

    public static void setBytecodeTransformer(BytecodeTransformer transformer) {
        bytecodeTransformer = transformer;
    }

    public static ClassDescriptor getInstance(Class target) {
        Map<Class, ClassDescriptor> map = ClassDescriptor.getMap();
        ClassDescriptor descriptor = map.get(target);
        if (descriptor != null) {
            return descriptor;
        }
        descriptor = new ClassDescriptor(target, ClassDescriptor.getBytecode(target));
        map.put(target, descriptor);
        return descriptor;
    }

    private static byte[] getBytecode(Class target) {
        byte[] bytecode = RuntimeTools.getBytecode(target);
        if (bytecode != null) {
            return bytecode;
        }
        try {
            Class.forName(target.getName(), true, target.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String s = metadataTable.lookup(target);
        return s != null ? ClassDescriptor.decode(s) : null;
    }

    private static byte[] decode(String s) {
        byte[] bytecode = new byte[s.length()];
        for (int i = 0; i < bytecode.length; ++i) {
            bytecode[i] = (byte)(127 - s.charAt(i));
        }
        return bytecode;
    }

    public static void setEncodedMetadata(Class aClass, String metadata) {
        if (metadataTable != null) {
            metadataTable.putIfAbsent(aClass, metadata);
        }
    }

    private static synchronized Map<Class, ClassDescriptor> getMap() {
        Map<Class, ClassDescriptor> map;
        Map<Class, ClassDescriptor> map2 = map = cache == null ? null : cache.get();
        if (map == null) {
            map = new Hashtable<Class, ClassDescriptor>();
            cache = new SoftReference<Map<Class, ClassDescriptor>>(map);
        }
        return map;
    }

    @Override
    protected Annotation[] createAnnotations(Annotation[] declaredAnnotations) {
        Class superclass = this.target.getSuperclass();
        if (superclass == null) {
            return declaredAnnotations;
        }
        Annotation[] superAnnotations = ClassDescriptor.getInstance(superclass).getAnnotations();
        if (superAnnotations.length == 0) {
            return declaredAnnotations;
        }
        HashMap result = new HashMap();
        for (Annotation annotation : superAnnotations) {
            Class<?> annotationClass = annotation.getClass().getInterfaces()[0];
            if (!net.sf.retrotranslator.android.main.java.lang._Class.isAnnotationPresent(annotationClass, Inherited.class)) continue;
            result.put(annotationClass, annotation);
        }
        for (Annotation annotation : declaredAnnotations) {
            result.put(annotation.getClass().getInterfaces()[0], annotation);
        }
        return result.values().toArray(new Annotation[result.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return null;
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this;
    }

    @Override
    public String getInfo() {
        return RuntimeTools.getDisplayClassName(this.name);
    }

    public MethodDescriptor getEnclosingMethodDescriptor() {
        return this.enclosingMethod == null ? null : ClassDescriptor.getInstance(this.getClassByInternalName(this.enclosingClass)).getMethodDescriptor(this.enclosingMethod);
    }

    public Class getDeclaringClass() {
        return this.declaringClass == null ? null : this.getClassByInternalName(this.declaringClass);
    }

    public boolean isLocalOrAnonymous() {
        return this.enclosingMethod != null;
    }

    public FieldDescriptor getFieldDescriptor(String name) {
        return this.fieldDescriptors.get(name);
    }

    public Type[] getGenericInterfaces() {
        return this.genericInterfaces == null ? null : this.genericInterfaces.getClone();
    }

    public Type getGenericSuperclass() {
        return this.genericSuperclass == null ? null : this.genericSuperclass.get();
    }

    public MethodDescriptor getMethodDescriptor(String key) {
        return this.methodDescriptors.get(key);
    }

    public Collection<MethodDescriptor> getMethodDescriptors() {
        return this.methodDescriptors.values();
    }

    public Collection<FieldDescriptor> getFieldDescriptors() {
        return this.fieldDescriptors.values();
    }

    @Override
    public Class getTarget() {
        return this.target;
    }

    @Override
    protected TypeVariable findTypeVariable(String name) {
        TypeVariable variable = this.getTypeVariable(name);
        if (variable != null) {
            return variable;
        }
        MethodDescriptor methodDescriptor = this.getEnclosingMethodDescriptor();
        if (methodDescriptor != null) {
            return methodDescriptor.findTypeVariable(name);
        }
        Class declaringClass = _Class.getDeclaringClass(this.target);
        if (declaringClass != null) {
            return ClassDescriptor.getInstance(declaringClass).findTypeVariable(name);
        }
        throw new MalformedParameterizedTypeException();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.access = access;
        this.name = name;
        if (signature == null) {
            signature = SignatureList.getSignature(name);
        }
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
    }

    @Override
    public void visitOuterClass(String owner, String name, String desc) {
        if (name != null) {
            this.enclosingClass = owner;
            this.enclosingMethod = name + desc;
        }
    }

    @Override
    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        if (name.equals(this.name)) {
            this.access |= access;
            this.declaringClass = outerName;
        }
    }

    @Override
    public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
        FieldDescriptor fieldDescriptor = new FieldDescriptor(this, access, name, desc, signature);
        this.fieldDescriptors.put(name, fieldDescriptor);
        return fieldDescriptor;
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodDescriptor methodDescriptor = new MethodDescriptor(this, access, name, desc, signature);
        this.methodDescriptors.put(name + desc, methodDescriptor);
        return methodDescriptor;
    }

    @Override
    public SignatureVisitor visitSuperclass() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (!this.isAccess(512)) {
            this.genericSuperclass = this.getLazyType(descriptor);
        }
        return descriptor;
    }

    @Override
    public SignatureVisitor visitInterface() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericInterfaces == null) {
            this.genericInterfaces = this.getLazyList();
        }
        this.genericInterfaces.add(descriptor);
        return descriptor;
    }
}

