/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import net.sf.retrotranslator.android.asm.signature.SignatureReader;
import net.sf.retrotranslator.android.impl.AnnotatedElementDescriptor;
import net.sf.retrotranslator.android.impl.ClassDescriptor;
import net.sf.retrotranslator.android.impl.RuntimeTools;
import net.sf.retrotranslator.android.impl.TypeDescriptor;

public class FieldDescriptor
extends AnnotatedElementDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private TypeDescriptor typeDescriptor;

    public FieldDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            this.typeDescriptor = new TypeDescriptor();
            new SignatureReader(signature).accept(this.typeDescriptor);
        }
    }

    public FieldDescriptor(ClassDescriptor classDescriptor, Field field) {
        this(classDescriptor, field.getModifiers(), field.getName(), net.sf.retrotranslator.android.asm.Type.getDescriptor(field.getType()), null);
    }

    public static FieldDescriptor getInstance(Field field) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(field.getDeclaringClass());
        FieldDescriptor fieldDescriptor = classDescriptor.getFieldDescriptor(field.getName());
        return fieldDescriptor != null ? fieldDescriptor : new FieldDescriptor(classDescriptor, field);
    }

    public String getName() {
        return this.name;
    }

    public String getDesc() {
        return this.desc;
    }

    public Type getGenericType() {
        return this.createType(this.typeDescriptor);
    }

    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    public String getInfo() {
        return RuntimeTools.getFieldInfo(this.classDescriptor.getName(), this.name);
    }

    protected TypeVariable findTypeVariable(String name) {
        return this.classDescriptor.findTypeVariable(name);
    }

    protected Annotation[] createAnnotations(Annotation[] declaredAnnotations) {
        return declaredAnnotations;
    }
}

