/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.List;
import net.sf.retrotranslator.android.asm.AnnotationVisitor;
import net.sf.retrotranslator.android.asm.signature.SignatureReader;
import net.sf.retrotranslator.android.asm.signature.SignatureVisitor;
import net.sf.retrotranslator.android.impl.AnnotationArray;
import net.sf.retrotranslator.android.impl.AnnotationValue;
import net.sf.retrotranslator.android.impl.ClassDescriptor;
import net.sf.retrotranslator.android.impl.EnumValue;
import net.sf.retrotranslator.android.impl.GenericDeclarationDescriptor;
import net.sf.retrotranslator.android.impl.LazyList;
import net.sf.retrotranslator.android.impl.LazyValue;
import net.sf.retrotranslator.android.impl.RuntimeTools;
import net.sf.retrotranslator.android.impl.TypeDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MethodDescriptor
extends GenericDeclarationDescriptor {
    private String name;
    private String desc;
    private ClassDescriptor classDescriptor;
    private LazyValue<Class, Method> method;
    private LazyValue<String, Class> returnType;
    private LazyValue<Object, Object> defaultValue;
    private LazyValue<Class, Constructor> constructor;
    private LazyValue<TypeDescriptor, Type> genericReturnType;
    private LazyList<TypeDescriptor, Type> genericParameterTypes;
    private LazyList<TypeDescriptor, Type> genericExceptionTypes;
    private LazyList<List<AnnotationValue>, Annotation[]> parameterAnnotations;

    public MethodDescriptor(ClassDescriptor classDescriptor, int access, String name, String desc, String signature) {
        this.classDescriptor = classDescriptor;
        this.access = access;
        this.name = name;
        this.desc = desc;
        if (signature != null) {
            new SignatureReader(signature).accept(this);
        }
        this.returnType = this.createReturnType();
        if (name.equals("<init>")) {
            this.constructor = this.createConstructor();
        } else if (!name.equals("<clinit>")) {
            this.method = this.createMethod();
        }
        this.parameterAnnotations = this.createParameterAnnotations();
    }

    private LazyValue<String, Class> createReturnType() {
        return new LazyValue<String, Class>(this.desc){

            @Override
            protected Class resolve(String input) {
                return MethodDescriptor.this.getClassByType(net.sf.retrotranslator.android.asm.Type.getReturnType(input));
            }
        };
    }

    private LazyValue<Class, Constructor> createConstructor() {
        return new LazyValue<Class, Constructor>(this.classDescriptor.getTarget()){

            @Override
            protected Constructor resolve(Class input) {
                for (Constructor<?> constructor : input.getDeclaredConstructors()) {
                    if (!RuntimeTools.getConstructorDescriptor(constructor).equals(MethodDescriptor.this.desc)) continue;
                    return constructor;
                }
                return null;
            }
        };
    }

    private LazyValue<Class, Method> createMethod() {
        return new LazyValue<Class, Method>(this.classDescriptor.getTarget()){

            @Override
            protected Method resolve(Class input) {
                for (Method method : input.getDeclaredMethods()) {
                    if (!method.getName().equals(MethodDescriptor.this.name) || !net.sf.retrotranslator.android.asm.Type.getMethodDescriptor(method).equals(MethodDescriptor.this.desc)) continue;
                    return method;
                }
                return null;
            }
        };
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDesc() {
        return this.desc;
    }

    public Class getReturnType() {
        return this.returnType.get();
    }

    public Object getDefaultValue() {
        return this.defaultValue == null ? null : RuntimeTools.cloneNonEmptyArray(this.defaultValue.get());
    }

    public static MethodDescriptor getInstance(Method method) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(method.getDeclaringClass());
        String desc = net.sf.retrotranslator.android.asm.Type.getMethodDescriptor(method);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor(method.getName() + desc);
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, method.getModifiers(), method.getName(), desc, null);
        }
        methodDescriptor.method.provide(method);
        return methodDescriptor;
    }

    public static MethodDescriptor getInstance(Constructor constructor) {
        ClassDescriptor classDescriptor = ClassDescriptor.getInstance(constructor.getDeclaringClass());
        String desc = RuntimeTools.getConstructorDescriptor(constructor);
        MethodDescriptor methodDescriptor = classDescriptor.getMethodDescriptor("<init>" + desc);
        if (methodDescriptor == null) {
            methodDescriptor = new MethodDescriptor(classDescriptor, constructor.getModifiers(), "<init>", desc, null);
        }
        methodDescriptor.constructor.provide(constructor);
        return methodDescriptor;
    }

    @Override
    public GenericDeclaration getTarget() {
        return this.method != null ? (Constructor)((Object)this.method.get()) : (this.constructor != null ? this.constructor.get() : null);
    }

    public Method getMethod() {
        return this.method == null ? null : this.method.get();
    }

    public Constructor getConstructor() {
        return this.constructor == null ? null : this.constructor.get();
    }

    @Override
    public ClassDescriptor getClassDescriptor() {
        return this.classDescriptor;
    }

    @Override
    public String getInfo() {
        return RuntimeTools.getMethodInfo(this.classDescriptor.getInfo(), this.name, this.desc);
    }

    @Override
    protected TypeVariable findTypeVariable(String name) {
        TypeVariable variable = this.getTypeVariable(name);
        return variable != null ? variable : this.classDescriptor.findTypeVariable(name);
    }

    public Annotation[][] getParameterAnnotations() {
        return this.parameterAnnotations.getClone();
    }

    private LazyList<List<AnnotationValue>, Annotation[]> createParameterAnnotations() {
        return new LazyList<List<AnnotationValue>, Annotation[]>(){

            @Override
            protected Annotation[] resolve(List<AnnotationValue> input) {
                return MethodDescriptor.this.createAnnotations(input);
            }

            protected Annotation[][] newArray(int size) {
                return new Annotation[net.sf.retrotranslator.android.asm.Type.getArgumentTypes(MethodDescriptor.this.desc).length][];
            }
        };
    }

    public Type getGenericReturnType() {
        return this.genericReturnType == null ? null : this.genericReturnType.get();
    }

    public Type[] getGenericParameterTypes() {
        return this.genericParameterTypes == null ? null : this.genericParameterTypes.getClone();
    }

    public Type[] getGenericExceptionTypes() {
        return this.genericExceptionTypes == null ? null : this.genericExceptionTypes.getClone();
    }

    @Override
    protected Annotation[] createAnnotations(Annotation[] declaredAnnotations) {
        return declaredAnnotations;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (!visible) {
            return EMPTY_VISITOR;
        }
        List<AnnotationValue> values = this.parameterAnnotations.get(parameter);
        if (values == null) {
            values = new ArrayList<AnnotationValue>();
            this.parameterAnnotations.set(parameter, values);
        }
        AnnotationValue value = new AnnotationValue(desc);
        values.add(value);
        return value;
    }

    @Override
    public void visit(String name, Object value) {
        this.setDefaultValue(value);
    }

    @Override
    public void visitEnum(String name, String desc, String value) {
        this.setDefaultValue(new EnumValue(desc, value));
    }

    @Override
    public AnnotationVisitor visitAnnotation(String name, String desc) {
        AnnotationValue value = new AnnotationValue(desc);
        this.setDefaultValue(value);
        return value;
    }

    @Override
    public AnnotationVisitor visitArray(String name) {
        AnnotationArray array = new AnnotationArray();
        this.setDefaultValue(array);
        return array;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericParameterTypes == null) {
            this.genericParameterTypes = this.getLazyList();
        }
        this.genericParameterTypes.add(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        this.genericReturnType = this.getLazyType(descriptor);
        return descriptor;
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        TypeDescriptor descriptor = new TypeDescriptor();
        if (this.genericExceptionTypes == null) {
            this.genericExceptionTypes = this.getLazyList();
        }
        this.genericExceptionTypes.add(descriptor);
        return descriptor;
    }

    private void setDefaultValue(Object o) {
        this.defaultValue = new LazyValue<Object, Object>(o){

            @Override
            protected Object resolve(Object input) {
                return MethodDescriptor.this.resolveValue(input, MethodDescriptor.this.getReturnType(), MethodDescriptor.this);
            }
        };
    }
}

