/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import net.sf.retrotranslator.android.impl.RuntimeTools;

public class ParameterizedTypeImpl
implements ParameterizedType {
    private Type[] actualTypeArguments;
    private Class rawType;
    private Type ownerType;

    public ParameterizedTypeImpl(Type[] actualTypeArguments, Class rawType, Type ownerType) {
        this.actualTypeArguments = actualTypeArguments;
        this.rawType = rawType;
        this.ownerType = ownerType;
    }

    public Type[] getActualTypeArguments() {
        return (Type[])this.actualTypeArguments.clone();
    }

    public Type getRawType() {
        return this.rawType;
    }

    public Type getOwnerType() {
        return this.ownerType;
    }

    public int hashCode() {
        return Arrays.hashCode(this.actualTypeArguments) ^ this.rawType.hashCode() ^ (this.ownerType == null ? 0 : this.ownerType.hashCode());
    }

    public boolean equals(Object obj) {
        if (obj instanceof ParameterizedType) {
            if (obj == this) {
                return true;
            }
            ParameterizedType type = (ParameterizedType)obj;
            return Arrays.equals(this.actualTypeArguments, type.getActualTypeArguments()) && this.rawType.equals(type.getRawType()) && (this.ownerType == null ? type.getOwnerType() == null : this.ownerType.equals(type.getOwnerType()));
        }
        return false;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.ownerType != null) {
            builder.append(RuntimeTools.getString(this.ownerType)).append('.');
        }
        String rawName = this.rawType.getName();
        if (this.ownerType instanceof ParameterizedTypeImpl) {
            rawName = rawName.substring(((ParameterizedTypeImpl)this.ownerType).rawType.getName().length() + 1);
        }
        builder.append(rawName);
        if (this.actualTypeArguments.length > 0) {
            builder.append('<');
            for (int i = 0; i < this.actualTypeArguments.length; ++i) {
                if (i > 0) {
                    builder.append(", ");
                }
                builder.append(RuntimeTools.getString(this.actualTypeArguments[i]));
            }
            builder.append('>');
        }
        return builder.toString();
    }
}

