/*
 * Decompiled with CFR 0.152.
 */
package net.sf.retrotranslator.android.impl;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import net.sf.retrotranslator.android.asm.Type;
import net.sf.retrotranslator.android.impl.RuntimeTools;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureList {
    private static final Map<String, String> map = SignatureList.getMap();

    private SignatureList() {
    }

    public static String getSignature(String className) {
        return map.get(className);
    }

    private static String getAccessToken() {
        Type randomAccessType = Type.getType("Ljava/util/RandomAccess;");
        for (Class<?> anInterface : ArrayList.class.getInterfaces()) {
            if (!anInterface.getName().equals(randomAccessType.getClassName())) continue;
            return randomAccessType.getDescriptor();
        }
        return "";
    }

    private static Map<String, String> getMap() {
        Hashtable<String, String> map = new Hashtable<String, String>();
        String prefix = RuntimeTools.CONCURRENT_PREFIX;
        if (prefix == null) {
            return map;
        }
        prefix = prefix.replace('.', '/');
        String accessToken = SignatureList.getAccessToken();
        map.put("java/util/Collection", "<E:Ljava/lang/Object;>Ljava/lang/Object;");
        map.put("java/util/Set", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Collection<TE;>;");
        map.put("java/util/List", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Collection<TE;>;");
        map.put(prefix + "java/util/Queue", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Collection<TE;>;");
        map.put("java/util/Map", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;");
        map.put("java/util/SortedSet", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Set<TE;>;");
        map.put("java/util/SortedMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Map<TK;TV;>;");
        map.put(prefix + "java/util/concurrent/BlockingQueue", "<E:Ljava/lang/Object;>Ljava/lang/Object;L" + prefix + "java/util/Queue<TE;>;");
        map.put(prefix + "java/util/concurrent/ConcurrentMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Map<TK;TV;>;");
        map.put("java/util/HashSet", "<E:Ljava/lang/Object;>Ljava/util/AbstractSet<TE;>;Ljava/util/Set<TE;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/TreeSet", "<E:Ljava/lang/Object;>Ljava/util/AbstractSet<TE;>;Ljava/util/SortedSet<TE;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/LinkedHashSet", "<E:Ljava/lang/Object;>Ljava/util/HashSet<TE;>;Ljava/util/Set<TE;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/ArrayList", "<E:Ljava/lang/Object;>Ljava/util/AbstractList<TE;>;Ljava/util/List<TE;>;" + accessToken + "Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/LinkedList", "<E:Ljava/lang/Object;>Ljava/util/AbstractSequentialList<TE;>;Ljava/util/List<TE;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put(prefix + "java/util/PriorityQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;Ljava/io/Serializable;");
        map.put("java/util/HashMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/util/Map<TK;TV;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/TreeMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/util/SortedMap<TK;TV;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/LinkedHashMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/HashMap<TK;TV;>;");
        map.put("java/util/Vector", "<E:Ljava/lang/Object;>Ljava/util/AbstractList<TE;>;Ljava/util/List<TE;>;" + accessToken + "Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/Hashtable", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/Dictionary<TK;TV;>;Ljava/util/Map<TK;TV;>;Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put("java/util/WeakHashMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/util/Map<TK;TV;>;");
        map.put("java/util/IdentityHashMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/util/AbstractMap<TK;TV;>;Ljava/util/Map<TK;TV;>;Ljava/io/Serializable;Ljava/lang/Cloneable;");
        map.put(prefix + "java/util/concurrent/CopyOnWriteArrayList", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/List<TE;>;" + accessToken + "Ljava/lang/Cloneable;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/CopyOnWriteArraySet", "<E:Ljava/lang/Object;>Ljava/util/AbstractSet<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/ConcurrentLinkedQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/Queue<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/LinkedBlockingQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/concurrent/BlockingQueue<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/ArrayBlockingQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/concurrent/BlockingQueue<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/PriorityBlockingQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/concurrent/BlockingQueue<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/DelayQueue", "<E::L" + prefix + "java/util/concurrent/Delayed;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/concurrent/BlockingQueue<TE;>;");
        map.put(prefix + "java/util/concurrent/SynchronousQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractQueue<TE;>;L" + prefix + "java/util/concurrent/BlockingQueue<TE;>;Ljava/io/Serializable;");
        map.put(prefix + "java/util/concurrent/ConcurrentHashMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>L" + prefix + "java/util/AbstractMap<TK;TV;>;L" + prefix + "java/util/concurrent/ConcurrentMap<TK;TV;>;Ljava/io/Serializable;");
        map.put("java/util/AbstractCollection", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Collection<TE;>;");
        map.put("java/util/AbstractSet", "<E:Ljava/lang/Object;>Ljava/util/AbstractCollection<TE;>;Ljava/util/Set<TE;>;");
        map.put("java/util/AbstractList", "<E:Ljava/lang/Object;>Ljava/util/AbstractCollection<TE;>;Ljava/util/List<TE;>;");
        map.put("java/util/AbstractSequentialList", "<E:Ljava/lang/Object;>Ljava/util/AbstractList<TE;>;");
        map.put(prefix + "java/util/AbstractQueue", "<E:Ljava/lang/Object;>L" + prefix + "java/util/AbstractCollection<TE;>;L" + prefix + "java/util/Queue<TE;>;");
        map.put("java/util/AbstractMap", "<K:Ljava/lang/Object;V:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Map<TK;TV;>;");
        map.put("java/util/Enumeration", "<E:Ljava/lang/Object;>Ljava/lang/Object;");
        map.put("java/util/Iterator", "<E:Ljava/lang/Object;>Ljava/lang/Object;");
        map.put("java/util/ListIterator", "<E:Ljava/lang/Object;>Ljava/lang/Object;Ljava/util/Iterator<TE;>;");
        map.put("java/lang/Comparable", "<T:Ljava/lang/Object;>Ljava/lang/Object;");
        map.put("java/util/Comparator", "<T:Ljava/lang/Object;>Ljava/lang/Object;");
        return map;
    }
}

